/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.reader.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextFormatMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.GroupMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.engine.reader.EDIStructureReaderEngine;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIStructureReader;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextFormatMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.GroupMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class EDIStructureReaderEngineImpl
implements EDIStructureReaderEngine {
    @Override
    public SdmxBeans createSdmxBeans(EDIStructureReader reader) {
        InnerEngine engine = new InnerEngine(reader);
        return engine.processMessage();
    }

    private class InnerEngine {
        private String currentLine;
        private String currentLineCopy;
        private SdmxBeans beans;
        private EDIStructureReader ediReader;
        private String agencyId;

        private InnerEngine(EDIStructureReader reader) {
            this.ediReader = reader;
            this.agencyId = this.ediReader.getMessageAgency();
        }

        private SdmxBeans processMessage() {
            ConceptSchemeMutableBeanImpl defaultConceptScheme = new ConceptSchemeMutableBeanImpl();
            defaultConceptScheme.setAgencyId(this.agencyId);
            defaultConceptScheme.setVersion("1.0");
            defaultConceptScheme.setId("STANDALONE_CONCEPT_SCHEME");
            defaultConceptScheme.addName("en", "Default Scheme");
            try {
                this.beans = new SdmxBeansImpl(this.getHeader());
                while (this.readNextLine()) {
                    String groupString;
                    if (this.ediReader.getLineType().isCodelistSegment()) {
                        groupString = this.currentLine;
                        try {
                            this.processCodelist();
                            continue;
                        }
                        catch (Throwable th) {
                            throw new IllegalArgumentException("Error while attempting to process codelist group: " + groupString, th);
                        }
                    }
                    if (this.ediReader.getLineType().isConceptSegment()) {
                        groupString = this.currentLine;
                        try {
                            this.processConcept((ConceptSchemeMutableBean)defaultConceptScheme);
                            continue;
                        }
                        catch (Throwable th) {
                            throw new IllegalArgumentException("Error while attempting to process statistical concept group: " + groupString, th);
                        }
                    }
                    if (!this.ediReader.getLineType().isDSDSegment()) continue;
                    groupString = this.currentLine;
                    try {
                        this.processDataStructure();
                    }
                    catch (Throwable th) {
                        throw new IllegalArgumentException("Error while attempting to process data structure definition group: " + groupString, th);
                    }
                }
            }
            catch (Throwable th) {
                throw new RuntimeException("Error while processing line #" + this.ediReader.getLineNumber() + " - " + this.currentLineCopy, th);
            }
            if (defaultConceptScheme.getItems().size() > 0) {
                this.beans.addConceptScheme(defaultConceptScheme.getImmutableInstance());
            }
            return this.beans;
        }

        public HeaderBean getHeader() {
            HashMap additionalAttributes = new HashMap();
            StructureReferenceBean dataProviderReference = null;
            ArrayList structure = new ArrayList();
            String datasetId = null;
            PartyBean sender = this.ediReader.getSendingAgency();
            String recievingAgency = this.ediReader.getRecievingAgency();
            String id = this.ediReader.getEdiDocumentMetadata().getInterchangeReference();
            Date prepared = this.ediReader.getPreparationDate();
            ArrayList<PartyBeanImpl> receiver = new ArrayList<PartyBeanImpl>();
            if (ObjectUtil.validString((String[])new String[]{recievingAgency})) {
                receiver.add(new PartyBeanImpl(null, recievingAgency, null, null));
            }
            DATASET_ACTION datasetAction = null;
            Date embargoDate = null;
            Date extracted = null;
            Date reportingBegin = null;
            Date reportingEnd = null;
            List name = null;
            List source = null;
            boolean test = false;
            return new HeaderBeanImpl(additionalAttributes, structure, dataProviderReference, datasetAction, id, datasetId, embargoDate, extracted, prepared, reportingBegin, reportingEnd, name, source, receiver, sender, test);
        }

        private void goBackLine() {
            this.ediReader.moveBackLine();
        }

        private boolean readNextLine() {
            this.currentLineCopy = this.currentLine = this.ediReader.getNextLine();
            return this.currentLine != null;
        }

        private void processConcept(ConceptSchemeMutableBean defaultConceptScheme) throws IOException {
            String conceptName;
            String conceptId = this.currentLine;
            EDIUtil.parseId(conceptId);
            if (!ObjectUtil.validString((String[])new String[]{conceptId})) {
                throw new SdmxSyntaxException((Object)((Object)EDI_PREFIX.CONCEPT) + " is empty.  Concept must have an Id");
            }
            this.readNextLine();
            try {
                conceptName = this.ediReader.parseTextString();
            }
            catch (Throwable th) {
                throw new SdmxException(th, "Error while attempting to process concept name for concept '" + conceptId + "'");
            }
            if (!ObjectUtil.validString((String[])new String[]{conceptName})) {
                throw new SdmxSyntaxException((Object)((Object)EDI_PREFIX.STRING) + " segment for Concept '" + conceptId + "' is empty.  Concept must have a Name");
            }
            ConceptMutableBeanImpl conceptMutableBean = new ConceptMutableBeanImpl();
            conceptMutableBean.setId(conceptId);
            conceptMutableBean.addName("en", conceptName);
            defaultConceptScheme.addItem((ItemMutableBean)conceptMutableBean);
        }

        private void processCodelist() throws IOException {
            String[] split = this.currentLine.split("\\+");
            String codelistId = split[0];
            String codelistName = split[3];
            EDIUtil.parseId(codelistId);
            CodelistMutableBeanImpl codelist = new CodelistMutableBeanImpl();
            codelist.setId(codelistId);
            codelist.setAgencyId(this.ediReader.getMessageAgency());
            codelist.addName("en", codelistName);
            try {
                while (this.processCode((CodelistMutableBean)codelist)) {
                }
            }
            catch (Throwable th) {
                throw new SdmxException(th, "Error while attempting to process codelist:  agency id='" + this.agencyId + "' id='" + codelistId + "'");
            }
            this.beans.addCodelist(codelist.getImmutableInstance());
        }

        private boolean processCode(CodelistMutableBean codelist) throws IOException {
            this.readNextLine();
            if (this.ediReader.getLineType() == EDI_PREFIX.CODE_VALUE) {
                String codeName;
                String codeValue = this.currentLine;
                this.readNextLine();
                try {
                    codeName = this.ediReader.parseTextString();
                }
                catch (Throwable th) {
                    throw new SdmxException(th, "Error while attempting to process code name for code '" + codeValue + "'");
                }
                if (!ObjectUtil.validString((String[])new String[]{codeValue})) {
                    throw new SdmxSyntaxException((Object)((Object)EDI_PREFIX.CODE_VALUE) + " segment is empty, Code must have an id");
                }
                if (!ObjectUtil.validString((String[])new String[]{codeName})) {
                    throw new SdmxSyntaxException((Object)((Object)EDI_PREFIX.STRING) + " segment for Code '" + codeValue + "' is empty, Code must have a Name");
                }
                CodeMutableBeanImpl codeMutable = new CodeMutableBeanImpl();
                codeMutable.setId(codeValue);
                EDIUtil.parseId(codeValue);
                codeMutable.addName("en", codeName);
                codelist.addItem((ItemMutableBean)codeMutable);
                return true;
            }
            this.goBackLine();
            return false;
        }

        private void processDataStructure() throws IOException {
            String dataStructureId = this.currentLine;
            this.readNextLine();
            String dataStructureName = this.ediReader.parseTextString();
            DataStructureMutableBeanImpl dataStructure = new DataStructureMutableBeanImpl();
            dataStructure.setId(dataStructureId);
            EDIUtil.parseId(dataStructureId);
            dataStructure.addName("en", dataStructureName);
            dataStructure.setAgencyId(this.agencyId);
            try {
                this.processDataStructureComponents((DataStructureMutableBean)dataStructure);
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process key family: agency id='" + this.agencyId + "' id='" + dataStructureId + "'", th);
            }
            this.beans.addDataStructure(dataStructure.getImmutableInstance());
        }

        private void processDataStructureComponents(DataStructureMutableBean dataStructure) throws IOException {
            Object[] scdSegment;
            TreeMap<Integer, DimensionMutableBeanImpl> dimensions = new TreeMap<Integer, DimensionMutableBeanImpl>();
            boolean usingStatedPositions = false;
            int i = 1;
            ArrayList<String> dimensionGroup = new ArrayList<String>();
            try {
                while (true) {
                    this.readNextLine();
                    if (this.currentLine.startsWith("1+")) {
                        int checkPos = 1;
                        for (Integer pos : dimensions.keySet()) {
                            if (pos.equals(checkPos)) {
                                ++checkPos;
                                dataStructure.addDimension((DimensionMutableBean)dimensions.get(pos));
                                continue;
                            }
                            throw new IllegalArgumentException("Dimension position '" + checkPos + "' is missing, please ensure dimension positions are sequential starting from 1");
                        }
                        break;
                    }
                    Object[] scdSegment2 = this.processSCDSegment();
                    Integer dimPos = (Integer)scdSegment2[2];
                    if (dimPos != null) {
                        if (i > 1) {
                            throw new IllegalArgumentException("Dimension positions specified for some dimensions but not others.  Please aither specify dimension positions for all dimensions, or do not specify positions.  Unspecified positions will be processed in file order.");
                        }
                        usingStatedPositions = true;
                    } else {
                        if (usingStatedPositions) {
                            throw new IllegalArgumentException("Dimension positions specified for some dimensions but not others.  Please aither specify dimension positions for all dimensions, or do not specify positions.  Unspecified positions will be processed in file order.");
                        }
                        dimPos = i;
                        ++i;
                    }
                    if (dimensions.containsKey(dimPos)) {
                        throw new IllegalArgumentException("Duplicate dimension position : " + dimPos);
                    }
                    if (dimPos <= 0) {
                        throw new IllegalArgumentException("Dimension position must be a positive integer, can not process given position '" + dimPos + "'");
                    }
                    DimensionMutableBeanImpl dim = new DimensionMutableBeanImpl();
                    if (scdSegment2[0].equals(13)) {
                        dim.setFrequencyDimension(true);
                        if (!dimPos.equals(1)) {
                            throw new IllegalArgumentException("Frequency dimension must be the first dimension, but has been given as dimension position : " + dimPos);
                        }
                    } else if (!scdSegment2[0].equals(4)) {
                        this.throwSCDSegmentException("either", (Integer)scdSegment2[0], 14, 13);
                    }
                    StructureReferenceBean conceptRef = this.getComponentConceptReference((String)scdSegment2[1]);
                    dim.setConceptRef(conceptRef);
                    dimensionGroup.add(conceptRef.getIdentifiableIds()[0]);
                    this.readNextLine();
                    RepresentationMutableBeanImpl rep = new RepresentationMutableBeanImpl();
                    dim.setRepresentation((RepresentationMutableBean)rep);
                    TextFormatMutableBean textFormat = this.processFieldLength();
                    rep.setTextFormat(textFormat);
                    this.readNextLine();
                    rep.setRepresentation(this.processCodelistReference());
                    dimensions.put(dimPos, dim);
                }
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process key family dimension", th);
            }
            try {
                scdSegment = this.processSCDSegment();
                this.readNextLine();
                RepresentationMutableBeanImpl tdRepresentation = new RepresentationMutableBeanImpl();
                TextFormatMutableBean textFormat = this.processFieldLength();
                textFormat.setTextType(TEXT_TYPE.OBSERVATIONAL_TIME_PERIOD);
                tdRepresentation.setTextFormat(textFormat);
                DimensionMutableBeanImpl timeDimension = new DimensionMutableBeanImpl();
                timeDimension.setTimeDimension(true);
                timeDimension.setRepresentation((RepresentationMutableBean)tdRepresentation);
                timeDimension.setConceptRef(this.getComponentConceptReference((String)scdSegment[1]));
                dataStructure.addDimension((DimensionMutableBean)timeDimension);
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process time dimension", th);
            }
            this.readNextLine();
            try {
                AttributeMutableBeanImpl timeFormatAttribute = new AttributeMutableBeanImpl();
                Object[] scdSegment3 = this.processSCDSegment();
                if (!scdSegment3[0].equals(1)) {
                    this.throwSCDSegmentException("time format", (Integer)scdSegment3[0], 1);
                }
                timeFormatAttribute.setConceptRef(this.getComponentConceptReference((String)scdSegment3[1]));
                timeFormatAttribute.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP);
                timeFormatAttribute.setAssignmentStatus("Mandatory");
                timeFormatAttribute.setDimensionReferences(dimensionGroup);
                this.readNextLine();
                RepresentationMutableBeanImpl tfRepresentation = new RepresentationMutableBeanImpl();
                timeFormatAttribute.setRepresentation((RepresentationMutableBean)tfRepresentation);
                TextFormatMutableBean textFormat = this.processFieldLength();
                tfRepresentation.setTextFormat(textFormat);
                this.readNextLine();
                if (this.ediReader.getLineType().isCodelistReference()) {
                    tfRepresentation.setRepresentation(this.processCodelistReference());
                } else {
                    this.goBackLine();
                }
                dataStructure.addAttribute((AttributeMutableBean)timeFormatAttribute);
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process time format", th);
            }
            this.readNextLine();
            try {
                scdSegment = this.processSCDSegment();
                if (!scdSegment[0].equals(3)) {
                    this.throwSCDSegmentException("primary measure", (Integer)scdSegment[0], 3);
                }
                this.readNextLine();
                TextFormatMutableBean textFormat = this.processFieldLength();
                PrimaryMeasureMutableBeanImpl primaryMeasure = new PrimaryMeasureMutableBeanImpl();
                RepresentationMutableBeanImpl pmRepresentation = new RepresentationMutableBeanImpl();
                pmRepresentation.setTextFormat(textFormat);
                primaryMeasure.setRepresentation((RepresentationMutableBean)pmRepresentation);
                primaryMeasure.setConceptRef(this.getComponentConceptReference((String)scdSegment[1]));
                dataStructure.setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasure);
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process primary measure", th);
            }
            this.readNextLine();
            try {
                scdSegment = this.processSCDSegment();
                if (!scdSegment[0].equals(3)) {
                    this.throwSCDSegmentException("observation attribute", (Integer)scdSegment[0], 3);
                }
                AttributeMutableBeanImpl obsAttribute = new AttributeMutableBeanImpl();
                this.processAttribute((AttributeMutableBean)obsAttribute, (String)scdSegment[1]);
                dataStructure.addAttribute((AttributeMutableBean)obsAttribute);
                this.readNextLine();
                if (this.currentLine.startsWith("3+")) {
                    scdSegment = this.processSCDSegment();
                    if (!scdSegment[0].equals(3)) {
                        this.throwSCDSegmentException("Observation attribute", (Integer)scdSegment[0], 3);
                    }
                    obsAttribute = new AttributeMutableBeanImpl();
                    this.processAttribute((AttributeMutableBean)obsAttribute, (String)scdSegment[1]);
                    dataStructure.addAttribute((AttributeMutableBean)obsAttribute);
                    this.readNextLine();
                }
                if (this.currentLine.startsWith("3+")) {
                    scdSegment = this.processSCDSegment();
                    if (!scdSegment[0].equals(3)) {
                        this.throwSCDSegmentException("Observation attribute", (Integer)scdSegment[0], 3);
                    }
                    obsAttribute = new AttributeMutableBeanImpl();
                    this.processAttribute((AttributeMutableBean)obsAttribute, (String)scdSegment[1]);
                    dataStructure.addAttribute((AttributeMutableBean)obsAttribute);
                    this.readNextLine();
                }
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process observation attributes, expecting observation status, followed by observation confidentiality, followed by observation pre-break", th);
            }
            boolean processedGroupAttribute = false;
            try {
                while (this.ediReader.getLineType().isAttribute()) {
                    AttributeMutableBeanImpl attribute = new AttributeMutableBeanImpl();
                    this.processAttribute((AttributeMutableBean)attribute, this.currentLine);
                    if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.GROUP) {
                        if (!processedGroupAttribute) {
                            GroupMutableBeanImpl siblingGroup = new GroupMutableBeanImpl();
                            siblingGroup.setId(EDIUtil.getSiblingGroupId());
                            dataStructure.addGroup((GroupMutableBean)siblingGroup);
                            ArrayList<String> dimensionRef = new ArrayList<String>();
                            for (DimensionMutableBean currentDim : dataStructure.getDimensions()) {
                                if (currentDim.isFrequencyDimension() || currentDim.isTimeDimension()) continue;
                                dimensionRef.add(currentDim.getConceptRef().getChildReference().getId());
                            }
                            siblingGroup.setDimensionRef(dimensionRef);
                        }
                        attribute.setAttachmentGroup(EDIUtil.getSiblingGroupId());
                        processedGroupAttribute = true;
                    } else if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP) {
                        attribute.setDimensionReferences(dimensionGroup);
                    }
                    dataStructure.addAttribute((AttributeMutableBean)attribute);
                    this.readNextLine();
                }
            }
            catch (Throwable th) {
                throw new IllegalArgumentException("Error while attempting to process key family attribute", th);
            }
            this.goBackLine();
        }

        private void throwSCDSegmentException(String expecting, int actual, int ... expected) {
            StringBuilder sb = new StringBuilder();
            String concat = "";
            sb.append("Expecting " + expecting + ", SCD segment ");
            int[] nArray = expected;
            int n = expected.length;
            int n2 = 0;
            while (n2 < n) {
                int currentExpected = nArray[n2];
                sb.append(String.valueOf(concat) + "type '" + currentExpected + "'");
                sb.append(" (" + this.getSCDSegmentTypeAsString(currentExpected) + ")");
                concat = " or ";
                ++n2;
            }
            sb.append(" but got SCD segment " + this.getSCDSegmentTypeAsString(actual));
            throw new IllegalArgumentException(sb.toString());
        }

        private String getSCDSegmentTypeAsString(int type) {
            switch (type) {
                case 1: {
                    return "time";
                }
                case 3: {
                    return "array cell";
                }
                case 13: {
                    return "frequency dimension";
                }
                case 4: {
                    return "dimension";
                }
            }
            return "unknown";
        }

        private Object[] processSCDSegment() throws IOException {
            int dimensionType;
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.DIMENSION, true);
            String[] splitOnColon = this.currentLine.split(":");
            this.currentLine = splitOnColon[0];
            Integer keyPosition = null;
            if (splitOnColon.length > 1 && splitOnColon[1] != null) {
                keyPosition = Integer.parseInt(splitOnColon[1]);
            }
            String[] splitOnPlus = this.currentLine.split("\\+");
            try {
                dimensionType = Integer.parseInt(splitOnPlus[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error while processing SCD segment, unexpected: '" + splitOnPlus[0] + "': was expecting an integer defining the concept role");
            }
            String conceptId = splitOnPlus[1];
            Object[] returnObj = new Object[]{dimensionType, conceptId, keyPosition};
            return returnObj;
        }

        private void processAttribute(AttributeMutableBean attribute, String conceptId) throws IOException {
            ATTRIBUTE_ATTACHMENT_LEVEL attachement;
            String useageStatsStr;
            attribute.setConceptRef(this.getComponentConceptReference(conceptId));
            this.readNextLine();
            RepresentationMutableBeanImpl representation = new RepresentationMutableBeanImpl();
            representation.setTextFormat(this.processFieldLength());
            attribute.setRepresentation((RepresentationMutableBean)representation);
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.USEAGE_STATUS, true);
            int useageStatus = Integer.parseInt(this.currentLine.substring(0, 1));
            switch (useageStatus) {
                case 1: {
                    useageStatsStr = "Conditional";
                    break;
                }
                case 2: {
                    useageStatsStr = "Mandatory";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Useage Status " + useageStatus + ". Expecting 1 or 2");
                }
            }
            attribute.setAssignmentStatus(useageStatsStr);
            this.readNextLine();
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.ATTRIBUTE_ATTACHMENT_VALUE, true);
            int attachmentLevel = Integer.parseInt(this.currentLine.substring(0, 1));
            switch (attachmentLevel) {
                case 1: {
                    attachement = ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET;
                    break;
                }
                case 4: {
                    attachement = ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP;
                    break;
                }
                case 5: {
                    attachement = ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION;
                    break;
                }
                case 9: {
                    attachement = ATTRIBUTE_ATTACHMENT_LEVEL.GROUP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Attribute attachment level " + attachmentLevel + ". Expecting 1, 4, 5 or 9");
                }
            }
            attribute.setAttachmentLevel(attachement);
            this.readNextLine();
            if (this.ediReader.getLineType().isCodelistReference()) {
                representation.setRepresentation(this.processCodelistReference());
            } else {
                this.goBackLine();
            }
        }

        private StructureReferenceBean getComponentConceptReference(String conceptId) {
            StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(this.agencyId, "STANDALONE_CONCEPT_SCHEME", "1.0", SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{conceptId});
            return sRef;
        }

        private TextFormatMutableBean processFieldLength() throws IOException {
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.FIELD_LENGTH, true);
            boolean upToLength = false;
            if (this.currentLine.contains("..")) {
                upToLength = true;
                this.currentLine = this.currentLine.replace("..", "");
            }
            boolean alphaNumeric = false;
            if (this.currentLine.contains("AN")) {
                alphaNumeric = true;
                this.currentLine = this.currentLine.replace("AN", "");
            }
            this.currentLine = this.currentLine.replace("N", "");
            BigInteger fieldLength = BigInteger.valueOf(Long.parseLong(this.currentLine));
            TextFormatMutableBeanImpl textFormat = new TextFormatMutableBeanImpl();
            textFormat.setMaxLength(fieldLength);
            if (upToLength) {
                textFormat.setMinLength(BigInteger.ONE);
            } else {
                textFormat.setMinLength(fieldLength);
            }
            if (alphaNumeric) {
                textFormat.setTextType(TEXT_TYPE.STRING);
            } else {
                textFormat.setTextType(TEXT_TYPE.BIG_INTEGER);
            }
            return textFormat;
        }

        private StructureReferenceBean processCodelistReference() throws IOException {
            EDIUtil.assertPrefix(this.ediReader, EDI_PREFIX.CODELIST_REFERENCE, true);
            StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(this.agencyId, this.currentLine, "1.0", SDMX_STRUCTURE_TYPE.CODE_LIST, new String[0]);
            return sRef;
        }
    }
}

