/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.writer.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.model.impl.InterchangeHeader;
import org.sdmxsource.sdmx.ediparser.model.impl.MessageIdentification;

public abstract class AbstractEdiOutputEngine {

    protected class InnerEngine {
        private OutputStreamWriter writer;
        private int numLines;
        private int numMessages;
        private InterchangeHeader header;
        private MessageIdentification messageId;

        public InnerEngine(OutputStream out) {
            try {
                this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to open writer!", e);
            }
        }

        protected void writeInterchangeAdministration(InterchangeHeader header) throws IOException {
            this.header = header;
            this.write((Object)((Object)EDI_PREFIX.MESSAGE_START) + "'");
            this.write(header.toString());
        }

        protected void writeMessageIdentification(MessageIdentification messageId) throws IOException {
            this.messageId = messageId;
            this.numLines = 1;
            ++this.numMessages;
            this.writeSegment(messageId.toString());
        }

        protected void writeMessageFunction(MESSSAGE_FUNCTION messagefunctionEnum) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_FUNCTION.toString()) + messagefunctionEnum.getEDIString() + "'");
        }

        protected void writeStructureMaintAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeRecievingAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.RECIEVING_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeSendingAgency(String agencyId) throws IOException {
            this.writeSegment(String.valueOf(EDI_PREFIX.SENDING_AGENCY.toString()) + agencyId + "'");
        }

        protected void writeEndMessageAdministration() {
            this.writeSegment(String.valueOf(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString()) + this.numLines + "+" + this.messageId.getMessageRefNum() + "'");
        }

        protected void writeEndMessage() {
            this.write(String.valueOf(EDI_PREFIX.END_MESSAGE.toString()) + this.numMessages + "+" + this.header.getInterchangeRef() + "'");
        }

        protected void writeSegment(String str) {
            this.write(str);
            ++this.numLines;
        }

        public void closeResources() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close: ", e);
            }
        }

        private void write(String value) {
            try {
                this.writer.write(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write the string: " + value, e);
            }
            try {
                this.writer.write(System.getProperty("line.separator"));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write!", e);
            }
        }
    }
}

