/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MapParameter
extends LeafParameter<Map> {
    private Class<?> keyInstanceType = String.class;
    private Class<?> valueInstanceType = String.class;
    private List<?> expectedKeys = new ArrayList();

    private MapParameter() {
    }

    public MapParameter(String identifier, String name, String description, Cardinality cardinality, Class<?> keyInstanceType, Class<?> valueInstanceType) {
        super(identifier, name, description, cardinality);
        this.keyInstanceType = keyInstanceType;
        this.valueInstanceType = valueInstanceType;
    }

    public MapParameter(String identifier, String name, String description, Cardinality cardinality, Class<?> keyInstanceType, Class<?> valueInstanceType, List<?> expectedKeys) {
        super(identifier, name, description, cardinality);
        this.keyInstanceType = keyInstanceType;
        this.valueInstanceType = valueInstanceType;
        this.expectedKeys = expectedKeys;
    }

    @Override
    public Class<Map> getParameterType() {
        return Map.class;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MapParameter [keyInstanceType=");
        builder.append(this.keyInstanceType);
        builder.append(", valueInstanceType=");
        builder.append(this.valueInstanceType);
        builder.append(", expectedKeys=");
        builder.append(this.expectedKeys);
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    public Class<?> getKeyInstanceType() {
        return this.keyInstanceType;
    }

    public Class<?> getValueInstanceType() {
        return this.valueInstanceType;
    }

    public List<?> getExpectedKeys() {
        return this.expectedKeys;
    }

    @Override
    public void validateValue(Object valueObj) throws Exception {
        super.validateValue(valueObj);
        Map value = (Map)valueObj;
        for (Object obj : this.expectedKeys) {
            if (value.containsKey(obj)) continue;
            throw new Exception(String.format("Expected key %s not found in map parameter %s", obj, this.getName()));
        }
        if (!value.isEmpty()) {
            for (Map.Entry entry : value.entrySet()) {
                if (!this.keyInstanceType.isInstance(entry.getKey())) {
                    throw new Exception(String.format("Found invalid key class %s in map parameter %s, expected %s", entry.getKey().getClass(), this.getName(), this.keyInstanceType));
                }
                if (this.valueInstanceType.isInstance(entry.getValue())) continue;
                throw new Exception(String.format("Found invalid value class %s in map parameter %s, expected %s", entry.getValue().getClass(), this.getName(), this.valueInstanceType));
            }
        }
    }
}

