/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.map.MapCreationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4MapCreation
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4MapCreation.class);
    private TabularDataService service;
    private MapCreationSession mapCreationSession;

    public OpExecution4MapCreation(TabularDataService service, MapCreationSession mapCreationSession) {
        this.service = service;
        this.mapCreationSession = mapCreationSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug(this.mapCreationSession.toString());
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.GenerateMap.toString(), this.service);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<ColumnData> fut = this.mapCreationSession.getFeature();
        ArrayList<ColumnReference> futures = new ArrayList<ColumnReference>();
        String tableIdS = null;
        tableIdS = this.mapCreationSession.getTrId().isViewTable() ? this.mapCreationSession.getTrId().getReferenceTargetTableId() : this.mapCreationSession.getTrId().getTableId();
        TableId tableId = new TableId(Long.valueOf(tableIdS).longValue());
        for (ColumnData c : fut) {
            ColumnLocalId columnId = new ColumnLocalId(c.getColumnId());
            ColumnReference columnRef = new ColumnReference(tableId, columnId);
            futures.add(columnRef);
        }
        ColumnLocalId columnGeometryId = new ColumnLocalId(this.mapCreationSession.getGeometry().getColumnId());
        ColumnReference columnGeometryRef = new ColumnReference(tableId, columnGeometryId);
        map.put("mapName", this.mapCreationSession.getName());
        map.put("feature", futures);
        map.put("geom", columnGeometryRef);
        map.put("useView", new Boolean(this.mapCreationSession.isUseView()));
        map.put("metaAbstract", this.mapCreationSession.getMetaAbstract());
        map.put("metaPurpose", this.mapCreationSession.getMetaPurpose());
        map.put("User", this.mapCreationSession.getUsername());
        map.put("metaCredits", this.mapCreationSession.getMetaCredits());
        map.put("metaKeywords", this.mapCreationSession.getMetaKeywords());
        OperationExecution invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

