/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;

public class IdentifiableRetrievalManagerImpl
implements IdentifiableRetrievalManager {
    private SdmxBeanRetrievalManager retrievalManager;

    public IdentifiableRetrievalManagerImpl(SdmxBeanRetrievalManager retrievalManager) {
        if (retrievalManager == null) {
            throw new RuntimeException("IdentifiableRetrievalManagerImpl - SdmxBeanRetrievalManager can not be null");
        }
        this.retrievalManager = retrievalManager;
    }

    public <T> T getIdentifiableBean(CrossReferenceBean crossRef, Class<T> structureType) throws CrossReferenceException {
        IdentifiableBean bean = this.getIdentifiableBean(crossRef);
        if (structureType.isAssignableFrom(bean.getClass())) {
            return (T)bean;
        }
        throw new CrossReferenceException(crossRef);
    }

    public IdentifiableBean getIdentifiableBean(CrossReferenceBean crossReferenceBean) {
        try {
            IdentifiableBean idetifiableBean = this.getIdentifiableBean((StructureReferenceBean)crossReferenceBean);
            if (idetifiableBean != null) {
                return idetifiableBean;
            }
        }
        catch (CrossReferenceException crossReferenceException) {}
        throw new CrossReferenceException(crossReferenceBean);
    }

    public IdentifiableBean getIdentifiableBean(StructureReferenceBean sRef) {
        MaintainableBean maint = this.retrievalManager.getMaintainableBean(sRef);
        if (maint == null) {
            return null;
        }
        String targetURN = sRef.getTargetUrn();
        if (maint.getUrn().equals(targetURN)) {
            return maint;
        }
        for (IdentifiableBean currentIdent : maint.getIdentifiableComposites()) {
            if (!currentIdent.getUrn().equals(targetURN)) continue;
            return currentIdent;
        }
        return null;
    }

    public <T> T getIdentifiableBean(StructureReferenceBean sRef, Class<T> structureType) throws CrossReferenceException {
        IdentifiableBean bean = this.getIdentifiableBean(sRef);
        if (bean == null) {
            return null;
        }
        if (structureType.isAssignableFrom(bean.getClass())) {
            return (T)bean;
        }
        throw new SdmxReferenceException(sRef);
    }
}

