/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.springutil.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.util.exception.SchemaValidationException;
import org.sdmxsource.util.io.StreamUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class XMLParser {
    private static final Logger log = Logger.getLogger(XMLParser.class);
    private static boolean enableValidation = true;
    private static Map<SDMX_SCHEMA, URI> schemaLocations = new HashMap<SDMX_SCHEMA, URI>();
    private static Map<SDMX_SCHEMA, Schema> schemas = new HashMap<SDMX_SCHEMA, Schema>();
    private static final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    public static void validateXML(ReadableDataLocation sourceData, SDMX_SCHEMA schemaVersion, ReadableDataLocation ... extraLocations) throws SdmxSyntaxException {
        XMLParser.validateXML(sourceData.getInputStream(), schemaVersion, extraLocations);
    }

    public static void validateXML(InputStream xml, SDMX_SCHEMA schemaVersion, ReadableDataLocation ... extraLocations) throws SdmxSyntaxException {
        log.debug((Object)("Validate XML Enabled :" + enableValidation));
        if (!enableValidation) {
            log.warn((Object)"Validation disabled");
            return;
        }
        if (!schemaLocations.containsKey(schemaVersion)) {
            throw new IllegalArgumentException("Schema location has not been set for schema : " + schemaVersion);
        }
        if (extraLocations == null) {
            URI schema = schemaLocations.get(schemaVersion);
            XMLParser.validateXML(xml, schema, extraLocations);
        } else {
            XMLParser.validateXML(xml, schemaLocations.get(schemaVersion), new ReadableDataLocation[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateXML(InputStream xmlLocation, URI schemaURI, ReadableDataLocation ... schemaLocation) throws SdmxSyntaxException {
        Schema schema;
        log.debug((Object)("Validate XML Enabled :" + enableValidation));
        if (!enableValidation) {
            log.warn((Object)"Validation disabled");
            return;
        }
        Source[] schemaSource = new Source[schemaLocation.length + 1];
        log.debug((Object)("Create Schema" + schemaURI.toString()));
        schemaSource[0] = new StreamSource(schemaURI.toString());
        if (schemaLocation != null) {
            for (int i = 0; i < schemaLocation.length; ++i) {
                log.debug((Object)("Create Stream Source" + schemaLocation[i]));
                schemaSource[i + 1] = new StreamSource(schemaLocation[i].getInputStream());
            }
        }
        log.debug((Object)"Create Schema from Source[]");
        SchemaFactory schemaFactory = XMLParser.schemaFactory;
        synchronized (schemaFactory) {
            try {
                schema = XMLParser.schemaFactory.newSchema(schemaSource);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        XMLParser.validateXML(xmlLocation, schema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateXML(InputStream xmlLocation, Schema schema) throws SdmxSyntaxException {
        log.debug((Object)("Validate XML Enabled :" + enableValidation));
        if (!enableValidation) {
            log.warn((Object)"Validation disabled");
            return;
        }
        StreamSource source = null;
        try {
            Validator schemaValidator = schema.newValidator();
            ErrorHandler eh = new ErrorHandler();
            schemaValidator.setErrorHandler(eh);
            source = new StreamSource(xmlLocation);
            log.debug((Object)"Validate XML");
            schemaValidator.validate(source);
            source.getInputStream().close();
            log.debug((Object)"Validation complete");
            if (eh.getErrors().size() > 0) {
                ArrayList<String> validationErrors = new ArrayList<String>();
                for (SAXParseException ex : eh.getErrors()) {
                    String message = ex.getMessage() + "line/column: " + ex.getLineNumber() + "/" + ex.getColumnNumber();
                    validationErrors.add(message);
                }
                throw new SchemaValidationException(validationErrors);
            }
            log.debug((Object)"XML is Valid");
            if (source == null) return;
        }
        catch (Throwable th) {
            try {
                if (!(th instanceof SchemaValidationException)) throw new SchemaValidationException(th);
                throw (SchemaValidationException)((Object)th);
            }
            catch (Throwable throwable) {
                if (source == null) throw throwable;
                StreamUtil.closeStream(source.getInputStream());
                throw throwable;
            }
        }
        StreamUtil.closeStream(source.getInputStream());
        return;
    }

    public void setEnableValidation(boolean enableValidation) {
        XMLParser.enableValidation = enableValidation;
    }

    static {
        try {
            schemaLocations.put(SDMX_SCHEMA.VERSION_ONE, new ClassPathResource("/xsd/1_0/SDMXMessage.xsd").getURI());
            schemaLocations.put(SDMX_SCHEMA.VERSION_TWO, new ClassPathResource("/xsd/2_0/SDMXMessage.xsd").getURI());
            schemaLocations.put(SDMX_SCHEMA.VERSION_TWO_POINT_ONE, new ClassPathResource("/xsd/2_1/SDMXMessage.xsd").getURI());
            for (SDMX_SCHEMA schemaVersion : schemaLocations.keySet()) {
                URI schemaUri = schemaLocations.get(schemaVersion);
                StreamSource source = new StreamSource(schemaUri.toString());
                schemas.put(schemaVersion, schemaFactory.newSchema(source));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class ErrorHandler
    extends DefaultHandler {
        private List<SAXParseException> errors = new ArrayList<SAXParseException>();

        protected ErrorHandler() {
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        @Override
        public void error(SAXParseException parseException) throws SAXException {
            log.error((Object)parseException);
            this.errors.add(parseException);
        }

        @Override
        public void fatalError(SAXParseException parseException) throws SAXException {
            log.error((Object)parseException);
            this.errors.add(parseException);
        }

        @Override
        public void warning(SAXParseException parseException) throws SAXException {
            log.error((Object)parseException);
            this.errors.add(parseException);
        }
    }
}

