/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v21.common.ConceptReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalDimensionReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttributeRelationshipType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.UsageStatusType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.ComponentAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttributeXmlAssembler
implements Assembler<AttributeType, AttributeBean> {
    @Autowired
    private ComponentAssembler componentAssembler;

    @Override
    public void assemble(AttributeType assembleInto, AttributeBean assembleFrom) throws SdmxException {
        this.componentAssembler.assembleComponent((ComponentType)assembleInto, (ComponentBean)assembleFrom);
        if (assembleFrom.getConceptRoles() != null) {
            for (CrossReferenceBean currentConceptRole : assembleFrom.getConceptRoles()) {
                ConceptReferenceType conceptRef = assembleInto.addNewConceptRole();
                this.componentAssembler.setReference(conceptRef.addNewRef(), (StructureReferenceBean)currentConceptRole);
            }
        }
        if (assembleFrom.getAssignmentStatus() != null) {
            assembleInto.setAssignmentStatus(UsageStatusType.Enum.forString((String)assembleFrom.getAssignmentStatus()));
        }
        AttributeRelationshipType attributeRelationship = assembleInto.addNewAttributeRelationship();
        if (ObjectUtil.validCollection((Collection)assembleFrom.getDimensionReferences())) {
            for (String currentDimensionRef : assembleFrom.getDimensionReferences()) {
                LocalDimensionReferenceType dimRef = attributeRelationship.addNewDimension();
                dimRef.addNewRef().setId(currentDimensionRef);
            }
        } else if (ObjectUtil.validString((String[])new String[]{assembleFrom.getAttachmentGroup()})) {
            attributeRelationship.addNewGroup().addNewRef().setId(assembleFrom.getAttachmentGroup());
        } else if (ObjectUtil.validString((String[])new String[]{assembleFrom.getPrimaryMeasureReference()})) {
            attributeRelationship.addNewPrimaryMeasure().addNewRef().setId(assembleFrom.getPrimaryMeasureReference());
        } else {
            attributeRelationship.addNewNone();
        }
    }
}

