/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportPeriodTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.RepresentationType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportPeriodTargetBean;
import org.sdmxsource.sdmx.api.model.mutable.base.IdentifiableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.ReportPeriodTargetMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.util.ObjectUtil;

public class ReportPeriodTargetBeanImpl
extends IdentifiableBeanImpl
implements ReportPeriodTargetBean {
    private static final long serialVersionUID = -7145150029575176604L;
    private SdmxDate startTime;
    private SdmxDate endTime;
    private TEXT_TYPE textType = TEXT_TYPE.OBSERVATIONAL_TIME_PERIOD;

    public ReportPeriodTargetBeanImpl(IdentifiableBean parent, ReportPeriodTargetMutableBean bean) {
        super((IdentifiableMutableBean)bean, (SdmxStructureBean)parent);
        if (bean.getStartTime() != null) {
            this.startTime = new SdmxDateImpl(bean.getStartTime(), TIME_FORMAT.DATE_TIME);
        }
        if (bean.getEndTime() != null) {
            this.endTime = new SdmxDateImpl(bean.getEndTime(), TIME_FORMAT.DATE_TIME);
        }
        if (bean.getTextType() != null) {
            this.textType = bean.getTextType();
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    protected ReportPeriodTargetBeanImpl(ReportPeriodTargetType reportPeriodTargetType, MetadataTargetBean parent) {
        super(reportPeriodTargetType, SDMX_STRUCTURE_TYPE.REPORT_PERIOD_TARGET, (SdmxStructureBean)parent);
        RepresentationType repType;
        if (reportPeriodTargetType.getLocalRepresentation() != null && (repType = reportPeriodTargetType.getLocalRepresentation()).getTextFormat() != null) {
            if (repType.getTextFormat().getStartTime() != null) {
                this.startTime = new SdmxDateImpl(repType.getTextFormat().getStartTime().toString());
            }
            if (repType.getTextFormat().getEndTime() != null) {
                this.endTime = new SdmxDateImpl(repType.getTextFormat().getEndTime().toString());
            }
            if (repType.getTextFormat().getTextType() != null) {
                this.textType = TextTypeUtil.getTextType(repType.getTextFormat().getTextType());
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ReportPeriodTargetBean that = (ReportPeriodTargetBean)bean;
            if (!ObjectUtil.equivalent((Object)this.startTime, (Object)that.getStartTime())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.endTime, (Object)that.getEndTime())) {
                return false;
            }
            return super.deepEqualsInternal((IdentifiableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        this.setId("REPORT_PERIOD_TARGET");
        if (this.startTime != null && this.endTime != null && this.startTime.isLater(this.endTime)) {
            throw new SdmxSemmanticException("Report Period Target - start time can not be later then end time");
        }
    }

    public TEXT_TYPE getTextType() {
        return this.textType;
    }

    public SdmxDate getStartTime() {
        return this.startTime;
    }

    public SdmxDate getEndTime() {
        return this.endTime;
    }

    @Override
    public String getId() {
        return "REPORT_PERIOD_TARGET";
    }
}

