/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelectionGroup;

public class DataQuerySelectionGroupImpl
implements DataQuerySelectionGroup {
    private static final long serialVersionUID = -2517041257822059001L;
    private Set<DataQuerySelection> selections = new HashSet<DataQuerySelection>();
    private Map<String, DataQuerySelection> selectionForConcept = new HashMap<String, DataQuerySelection>();
    private SdmxDate dateFrom;
    private SdmxDate dateTo;

    public DataQuerySelectionGroupImpl(Set<DataQuerySelection> selections, SdmxDate dateFrom, SdmxDate dateTo) {
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        if (selections == null) {
            return;
        }
        this.selections = selections;
        for (DataQuerySelection dimSel : selections) {
            if (this.selectionForConcept.containsKey(dimSel.getComponentId())) {
                throw new IllegalArgumentException("Duplicate concept");
            }
            this.selectionForConcept.put(dimSel.getComponentId(), dimSel);
        }
    }

    public DataQuerySelection getSelectionsForConcept(String coneptId) {
        return this.selectionForConcept.get(coneptId);
    }

    public boolean hasSelectionForConcept(String conceptId) {
        return this.selectionForConcept.containsKey(conceptId);
    }

    public Set<DataQuerySelection> getSelections() {
        return new HashSet<DataQuerySelection>(this.selections);
    }

    public SdmxDate getDateFrom() {
        return this.dateFrom;
    }

    public SdmxDate getDateTo() {
        return this.dateTo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (DataQuerySelection dqs : this.selections) {
            sb.append(concat + dqs.getComponentId() + " = (");
            concat = "";
            for (String val : dqs.getValues()) {
                sb.append(concat + val);
                concat = " OR ";
            }
            sb.append(")");
            concat = " AND ";
        }
        if (this.dateFrom != null) {
            sb.append(concat + " Date >= " + this.dateFrom.getDateInSdmxFormat());
            concat = " AND ";
        }
        if (this.dateTo != null) {
            sb.append(concat + " Date <= " + this.dateTo.getDateInSdmxFormat());
            concat = " AND ";
        }
        return sb.toString();
    }
}

