/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4CSVExport
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4CSVExport.class);
    private HttpSession session;
    private TabularDataService service;
    private CSVExportSession csvExportSession;

    public OpExecution4CSVExport(HttpSession session, TabularDataService service, CSVExportSession csvExportSession) {
        this.service = service;
        this.csvExportSession = csvExportSession;
        this.session = session;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug("CSV Export: " + this.csvExportSession);
        SessionUtil.setCSVExportEnd(this.session, false);
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.CSVExport.toString(), this.service);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encoding", this.csvExportSession.getEncoding());
        map.put("separator", this.csvExportSession.getSeparator());
        map.put("useView", this.csvExportSession.isExportViewColumns());
        map.put("columns", this.csvExportSession.getColumnsAsString());
        OperationExecution invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

