/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.mapping.ColumnMappingData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.mapping.ColumnMappingList;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4ChangeColumnType
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4ChangeColumnType.class);
    private TabularDataService service;
    private ChangeColumnTypeSession changeColumnTypeSession;

    public OpExecution4ChangeColumnType(TabularDataService service, ChangeColumnTypeSession changeColumnTypeSession) {
        this.service = service;
        this.changeColumnTypeSession = changeColumnTypeSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.changeColumnTypeSession.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        ColumnTypeCode type = this.changeColumnTypeSession.getColumnTypeCodeTarget();
        switch (type) {
            case ANNOTATION: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToAnnotationColumn.toString(), this.service);
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case ATTRIBUTE: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToAttributeColumn.toString(), this.service);
                map.put("targetDataType", ColumnDataTypeMap.map(this.changeColumnTypeSession.getColumnDataTypeTarget()));
                if (this.changeColumnTypeSession.getValueDataFormat() != null) {
                    map.put("inputFormatId", this.changeColumnTypeSession.getValueDataFormat().getId());
                }
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case CODE: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToCodeColumn.toString(), this.service);
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case CODEDESCRIPTION: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToCodeDescription.toString(), this.service);
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case CODENAME: {
                DataLocaleMetadata locale = new DataLocaleMetadata(this.changeColumnTypeSession.getLocale());
                map.put("additionalMeta", locale);
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToCodeName.toString(), this.service);
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case DIMENSION: {
                ArrayList<ColumnMappingData> columnMapping;
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToDimensionColumn.toString(), this.service);
                ColumnData col = this.changeColumnTypeSession.getCodelistColumnReference();
                logger.debug("ReferenceColumn To Set: " + col);
                ColumnLocalId cId = new ColumnLocalId(col.getColumnId());
                TRId trId = col.getTrId();
                logger.debug("trID: " + trId);
                long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
                TableId tId = new TableId(tabId);
                ColumnReference columnReference = new ColumnReference(tId, cId);
                map.put("refColumn", columnReference);
                ColumnMappingList columnMappingList = this.changeColumnTypeSession.getColumnMappingList();
                if (columnMappingList != null && (columnMapping = columnMappingList.getMapping()) != null && columnMapping.size() > 0) {
                    HashMap<Long, Long> mapping = new HashMap<Long, Long>();
                    for (ColumnMappingData columnMappingData : columnMapping) {
                        if (columnMappingData.getSourceArg() == null || columnMappingData.getTargetArg() == null) continue;
                        DimensionRow source = columnMappingData.getSourceArg();
                        DimensionRow target = columnMappingData.getTargetArg();
                        mapping.put(new Long(source.getRowId()), new Long(target.getRowId()));
                    }
                    map.put("mapping", mapping);
                }
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case MEASURE: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToMeasureColumn.toString(), this.service);
                map.put("targetDataType", ColumnDataTypeMap.map(this.changeColumnTypeSession.getColumnDataTypeTarget()));
                if (this.changeColumnTypeSession.getValueDataFormat() != null) {
                    map.put("inputFormatId", this.changeColumnTypeSession.getValueDataFormat().getId());
                }
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
            case TIMEDIMENSION: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ChangeToTimeDimensionColumn.toString(), this.service);
                map.put("periodFormat", this.changeColumnTypeSession.getPeriodDataType().getLabel());
                map.put("inputFormatId", this.changeColumnTypeSession.getValueDataFormat().getId());
                invocation = new OperationExecution(this.changeColumnTypeSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
                break;
            }
        }
        this.operationExecutionSpec.setOp(invocation);
    }
}

