/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ComponentMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeListMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionListMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.GroupMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.MeasureListMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MaintainableMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeListMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionListMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.GroupMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.MeasureListMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;

public class DataStructureMutableBeanImpl
extends MaintainableMutableBeanImpl
implements DataStructureMutableBean {
    private static final long serialVersionUID = 1L;
    private List<GroupMutableBean> groups = new ArrayList<GroupMutableBean>();
    private DimensionListMutableBean dimensionList;
    private AttributeListMutableBean attributeList;
    private MeasureListMutableBean measureList;

    public DataStructureMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.DSD);
    }

    public DataStructureMutableBeanImpl(DataStructureBean bean) {
        super((MaintainableBean)bean);
        if (bean.getGroups() != null) {
            for (GroupBean currentGroupBean : bean.getGroups()) {
                this.groups.add(new GroupMutableBeanImpl(currentGroupBean));
            }
        }
        if (bean.getDimensionList() != null) {
            this.dimensionList = new DimensionListMutableBeanImpl(bean.getDimensionList());
        }
        if (bean.getAttributeList() != null) {
            this.attributeList = new AttributeListMutableBeanImpl(bean.getAttributeList());
        }
        if (bean.getMeasureList() != null) {
            this.measureList = new MeasureListMutableBeanImpl(bean.getMeasureList());
        }
    }

    public DataStructureMutableBean removeComponent(String id) {
        this.removeComponent(this.getDimensions(), id);
        this.removeComponent(this.getAttributes(), id);
        return this;
    }

    public DimensionMutableBean getDimension(String id) {
        return (DimensionMutableBean)this.getComponentById(this.getDimensions(), id);
    }

    public AttributeMutableBean getAttribute(String id) {
        return (AttributeMutableBean)this.getComponentById(this.getAttributes(), id);
    }

    private void removeComponent(List<? extends ComponentMutableBean> comps, String removeId) {
        if (comps == null) {
            return;
        }
        ComponentMutableBean toRemove = this.getComponentById(comps, removeId);
        if (toRemove != null) {
            comps.remove(toRemove);
        }
    }

    private ComponentMutableBean getComponentById(List<? extends ComponentMutableBean> comps, String removeId) {
        if (comps == null) {
            return null;
        }
        for (ComponentMutableBean componentMutableBean : comps) {
            if (componentMutableBean.getId() == null || !componentMutableBean.getId().equals(removeId)) continue;
            return componentMutableBean;
        }
        return null;
    }

    public DimensionMutableBean addDimension(StructureReferenceBean conceptRef, StructureReferenceBean codelistRef) {
        DimensionMutableBeanImpl newDimension = new DimensionMutableBeanImpl();
        newDimension.setConceptRef(conceptRef);
        if (codelistRef != null) {
            RepresentationMutableBeanImpl representation = new RepresentationMutableBeanImpl();
            representation.setRepresentation(codelistRef);
            newDimension.setRepresentation(representation);
        }
        this.addDimension(newDimension);
        return newDimension;
    }

    public AttributeMutableBean addAttribute(StructureReferenceBean conceptRef, StructureReferenceBean codelistRef) {
        AttributeMutableBeanImpl newAttribute = new AttributeMutableBeanImpl();
        newAttribute.setConceptRef(conceptRef);
        if (codelistRef != null) {
            RepresentationMutableBeanImpl representation = new RepresentationMutableBeanImpl();
            representation.setRepresentation(codelistRef);
            newAttribute.setRepresentation(representation);
        }
        this.addAttribute(newAttribute);
        return newAttribute;
    }

    public PrimaryMeasureMutableBean addPrimaryMeasure(StructureReferenceBean conceptRef) {
        PrimaryMeasureMutableBeanImpl primaryMeasure = new PrimaryMeasureMutableBeanImpl();
        primaryMeasure.setConceptRef(conceptRef);
        this.setPrimaryMeasure(primaryMeasure);
        return primaryMeasure;
    }

    public List<DimensionMutableBean> getDimensions() {
        if (this.dimensionList != null) {
            return this.dimensionList.getDimensions();
        }
        return null;
    }

    public List<AttributeMutableBean> getAttributes() {
        if (this.attributeList != null) {
            return this.attributeList.getAttributes();
        }
        return null;
    }

    public void setPrimaryMeasure(PrimaryMeasureMutableBean primaryMeasure) {
        if (this.measureList == null) {
            this.measureList = new MeasureListMutableBeanImpl();
        }
        this.measureList.setPrimaryMeasure(primaryMeasure);
    }

    public void addGroup(GroupMutableBean group) {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupMutableBean>();
        }
        this.groups.add(group);
    }

    public DataStructureBean getImmutableInstance() {
        return new DataStructureBeanImpl(this);
    }

    public List<GroupMutableBean> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupMutableBean> groups) {
        this.groups = groups;
    }

    public DimensionListMutableBean getDimensionList() {
        return this.dimensionList;
    }

    public void setDimensionList(DimensionListMutableBean dimensionList) {
        this.dimensionList = dimensionList;
    }

    public AttributeListMutableBean getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(AttributeListMutableBean attributeList) {
        this.attributeList = attributeList;
    }

    public MeasureListMutableBean getMeasureList() {
        return this.measureList;
    }

    public void setMeasureList(MeasureListMutableBean measureList) {
        this.measureList = measureList;
    }

    public void addAttribute(AttributeMutableBean attribute) {
        if (this.attributeList == null) {
            this.attributeList = new AttributeListMutableBeanImpl();
        }
        this.attributeList.addAttribute(attribute);
    }

    public void addDimension(DimensionMutableBean dimension) {
        if (this.dimensionList == null) {
            this.dimensionList = new DimensionListMutableBeanImpl();
        }
        this.dimensionList.addDimension(dimension);
    }
}

