/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.dataparser.transform.DataReaderWriterTransform;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Component;

@Component
public class DataReaderWriterTransformImpl
implements DataReaderWriterTransform {
    private void pivot(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension) {
        HashMap outputMap = new HashMap();
        DatasetHeaderBean datasetHeader = dataReaderEngine.getCurrentDatasetHeaderBean();
        String currentCrossSectionConcept = datasetHeader.getDataStructureReference().getDimensionAtObservation();
        boolean pivotIsTime = pivotDimension.equals("TIME_PERIOD");
        boolean fromIsTimeSeries = datasetHeader.isTimeSeries();
        DataStructureBean keyFamily = dataReaderEngine.getDataStructure();
        List<String> seriesAttributeConcepts = null;
        List<String> obsAttributeConcepts = null;
        if (keyFamily != null) {
            seriesAttributeConcepts = this.getSeriesAttributes(pivotDimension, keyFamily);
            obsAttributeConcepts = this.getObsAttributes(pivotDimension, keyFamily);
        }
        HashSet<String> shortCodes = new HashSet<String>();
        HashMap<String, Keyable> keyMap = new HashMap<String, Keyable>();
        HashMap<String, HashSet<ObservationImpl>> obsMap = new HashMap<String, HashSet<ObservationImpl>>();
        while (dataReaderEngine.moveNextKeyable()) {
            String codeForPivot;
            Keyable key = dataReaderEngine.getCurrentKey();
            if (!key.isSeries()) {
                this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, key, 0);
                continue;
            }
            String string = codeForPivot = pivotIsTime ? key.getObsTime() : key.getKeyValue(pivotDimension);
            while (dataReaderEngine.moveNextObservation()) {
                Observation obs = dataReaderEngine.getCurrentObservation();
                String currentObsCode = fromIsTimeSeries ? obs.getObsTime() : obs.getCrossSectionalValue().getCode();
                String newKeyShortCode = this.getKeyShortCode(key, currentObsCode, pivotDimension);
                HashSet<ObservationImpl> observations = (HashSet<ObservationImpl>)obsMap.get(newKeyShortCode);
                if (!shortCodes.contains(newKeyShortCode)) {
                    shortCodes.add(newKeyShortCode);
                    keyMap.put(newKeyShortCode, this.createNewKey(key, pivotDimension, currentCrossSectionConcept, currentObsCode, pivotIsTime, fromIsTimeSeries, seriesAttributeConcepts));
                    observations = new HashSet<ObservationImpl>();
                    obsMap.put(newKeyShortCode, observations);
                }
                observations.add(new ObservationImpl(key, codeForPivot, obs.getObservationValue(), obs.getAttributes(), new AnnotationBean[0]));
            }
        }
        for (String currentKey : keyMap.keySet()) {
            Keyable key = (Keyable)keyMap.get(currentKey);
            this.writeKeyableToWriter(dataWriterEngine, (Keyable)keyMap.get(currentKey));
            for (Observation obs : (Set)obsMap.get(currentKey)) {
                this.writeObsToWriter(dataWriterEngine, key, obs);
            }
        }
    }

    private String getKeyShortCode(Keyable currentKey, String promoteCode, String ignoreConcept) {
        String returnString = "";
        for (KeyValue kv : currentKey.getKey()) {
            if (kv.getConcept().equals(ignoreConcept)) continue;
            returnString = returnString + kv.getCode() + ":";
        }
        returnString = returnString + promoteCode;
        return returnString;
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean copyHeader, boolean closeWriter) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, null, includeObs, -1, null, null, copyHeader, closeWriter);
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, boolean includeHeader, boolean closeOnCompletion) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, null, true, -1, null, null, includeHeader, closeOnCompletion);
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean closeOnCompletion) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, pivotDimension, true, -1, null, null, true, closeOnCompletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean includeHeader, boolean closeOnCompletion) {
        dataReaderEngine.reset();
        HeaderBean header = dataReaderEngine.getHeader();
        if (includeHeader && header != null) {
            dataWriterEngine.writeHeader(header);
        }
        try {
            DatasetHeaderBean dsHeader = null;
            List attributeValues = null;
            while (dataReaderEngine.moveNextDataset()) {
                boolean startNewDataset = false;
                if (dataReaderEngine.getDatasetPosition() > 0) {
                    startNewDataset = !ObjectUtil.containsAll((Collection)attributeValues, (Collection)dataReaderEngine.getDatasetAttributes());
                }
                attributeValues = dataReaderEngine.getDatasetAttributes();
                dsHeader = this.copyDatasetToWriter(dsHeader, dataReaderEngine, dataWriterEngine, pivotDimension, includeObs, maxObs, dateFrom, dateTo, false, false, startNewDataset);
            }
        }
        finally {
            if (closeOnCompletion) {
                dataWriterEngine.close(new DataWriterEngine.FooterMessage[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetHeaderBean copyDatasetToWriter(DatasetHeaderBean previousDatasetHeader, DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean includeHeader, boolean closeOnCompletion, boolean forceStartNewDataset) {
        try {
            if (includeHeader && dataReaderEngine.getHeader() != null) {
                dataWriterEngine.writeHeader(dataReaderEngine.getHeader());
            }
            DatasetHeaderBean datasetHeader = dataReaderEngine.getCurrentDatasetHeaderBean();
            boolean fromIsTimeSeries = datasetHeader.isTimeSeries();
            String dimensionAtObs = datasetHeader.getDataStructureReference().getDimensionAtObservation();
            if (pivotDimension == null || fromIsTimeSeries && pivotDimension.equals("TIME_PERIOD") || dimensionAtObs.equals(pivotDimension)) {
                if (forceStartNewDataset || previousDatasetHeader == null || !this.isHeaderEqual(datasetHeader, previousDatasetHeader)) {
                    dataWriterEngine.startDataset(dataReaderEngine.getDataFlow(), dataReaderEngine.getDataStructure(), datasetHeader, new AnnotationBean[0]);
                }
                for (KeyValue kv : dataReaderEngine.getDatasetAttributes()) {
                    dataWriterEngine.writeAttributeValue(kv.getConcept(), kv.getCode());
                }
                Keyable currentKey = null;
                while (true) {
                    try {
                        if (!dataReaderEngine.moveNextKeyable()) break;
                        currentKey = dataReaderEngine.getCurrentKey();
                    }
                    catch (Throwable th) {
                        if (currentKey == null) {
                            throw new SdmxException(th, "Error while trying read first series key");
                        }
                        throw new SdmxException(th, "Error while trying to read next series/group in the DataSet.  The last sucessfully processed key was: " + currentKey);
                    }
                    try {
                        if (includeObs) {
                            this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, currentKey, maxObs, dateFrom, dateTo);
                            continue;
                        }
                        this.writeKeyableToWriter(dataWriterEngine, currentKey);
                    }
                    catch (Throwable th) {
                        throw new SdmxException(th, "Error occurred while processing " + currentKey);
                    }
                }
                DatasetHeaderBean th = datasetHeader;
                return th;
            }
            String dsId = null;
            StructureReferenceBean structureRef = null;
            String serviceURL = null;
            String structureURL = null;
            if (datasetHeader.getDataStructureReference() != null) {
                dsId = datasetHeader.getDataStructureReference().getId();
                structureRef = datasetHeader.getDataStructureReference().getStructureReference();
                serviceURL = datasetHeader.getDataStructureReference().getServiceURL();
                structureURL = datasetHeader.getDataStructureReference().getStructureURL();
            } else {
                structureRef = dataReaderEngine.getDataStructure().asReference();
            }
            DatasetStructureReferenceBeanImpl dsStructureRef = new DatasetStructureReferenceBeanImpl(dsId, structureRef, serviceURL, structureURL, pivotDimension);
            DatasetHeaderBean modifiedDatasetHeader = datasetHeader.modifyDataStructureReference((DatasetStructureReferenceBean)dsStructureRef);
            if (previousDatasetHeader == null || !this.isHeaderEqual(datasetHeader, previousDatasetHeader)) {
                dataWriterEngine.startDataset(dataReaderEngine.getDataFlow(), dataReaderEngine.getDataStructure(), modifiedDatasetHeader, new AnnotationBean[0]);
            }
            this.pivot(dataReaderEngine, dataWriterEngine, pivotDimension);
            DatasetHeaderBean datasetHeaderBean = modifiedDatasetHeader;
            return datasetHeaderBean;
        }
        finally {
            if (closeOnCompletion) {
                dataWriterEngine.close(new DataWriterEngine.FooterMessage[0]);
            }
        }
    }

    public boolean isHeaderEqual(DatasetHeaderBean one, DatasetHeaderBean two) {
        if (!ObjectUtil.equivalent((Object)one.getAction(), (Object)two.getAction())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getDataProviderReference(), (Object)two.getDataProviderReference())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getDatasetId(), (Object)two.getDatasetId())) {
            return false;
        }
        if (!this.isHeaderEqual(one.getDataStructureReference(), two.getDataStructureReference())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getPublicationPeriod(), (Object)two.getPublicationPeriod())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getPublicationYear(), (Object)two.getPublicationYear())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getReportingBeginDate(), (Object)two.getReportingBeginDate())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getReportingEndDate(), (Object)two.getReportingEndDate())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getValidFrom(), (Object)two.getValidFrom())) {
            return false;
        }
        return ObjectUtil.equivalent((Object)one.getValidTo(), (Object)two.getValidTo());
    }

    private boolean isHeaderEqual(DatasetStructureReferenceBean one, DatasetStructureReferenceBean two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (one.isTimeSeries() != two.isTimeSeries()) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getStructureReference(), (Object)two.getStructureReference())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getServiceURL(), (Object)two.getServiceURL())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)one.getStructureURL(), (Object)two.getStructureURL())) {
            return false;
        }
        return ObjectUtil.equivalent((Object)one.getDimensionAtObservation(), (Object)two.getDimensionAtObservation());
    }

    @Override
    public void copyDatasetToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean includeHeader, boolean closeOnCompletion) {
        this.copyDatasetToWriter(null, dataReaderEngine, dataWriterEngine, pivotDimension, includeObs, maxObs, dateFrom, dateTo, includeHeader, closeOnCompletion, true);
    }

    private List<String> getSeriesAttributes(String pivotDimension, DataStructureBean keyFamily) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (AttributeBean currentAttribute : keyFamily.getSeriesAttributes(pivotDimension)) {
            returnList.add(currentAttribute.getId());
        }
        return returnList;
    }

    private List<String> getObsAttributes(String pivotDimension, DataStructureBean keyFamily) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (AttributeBean currentAttribute : keyFamily.getObservationAttributes(pivotDimension)) {
            returnList.add(currentAttribute.getId());
        }
        return returnList;
    }

    private Keyable createNewKey(Keyable keyable, String ignoreConcept, String includeNewConcept, String newConceptValue, boolean movingToTimeSeries, boolean movingFromTimeSeries, List<String> seriesAttributeConcepts) {
        List newKeyList = keyable.getKey();
        KeyValue removeKv = null;
        for (KeyValue kv : keyable.getKey()) {
            if (!kv.getConcept().equals(ignoreConcept)) continue;
            removeKv = kv;
            break;
        }
        ArrayList<KeyValue> newAttList = new ArrayList<KeyValue>();
        for (KeyValue currentAttr : keyable.getAttributes()) {
            if (!seriesAttributeConcepts.contains(currentAttr.getConcept())) continue;
            newAttList.add(currentAttr);
        }
        newKeyList.remove(removeKv);
        if (movingToTimeSeries) {
            newKeyList.add(new KeyValueImpl(keyable.getObsTime(), "TIME_PERIOD"));
        } else {
            newKeyList.add(new KeyValueImpl(newConceptValue, includeNewConcept));
        }
        return new KeyableImpl(keyable.getDataflow(), keyable.getDataStructure(), newKeyList, newAttList, null, null, null);
    }

    @Override
    public void writeKeyableToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, Keyable keyable, Integer maxObs, Date dateFrom, Date dateTo) {
        boolean seriesKeysOnly;
        boolean writtenKey = false;
        boolean filteredObs = false;
        String fromDateFormatted = null;
        String toDateFormatted = null;
        boolean bl = seriesKeysOnly = maxObs != null && maxObs == 0;
        if (keyable.isSeries() && !seriesKeysOnly) {
            boolean hasMax = maxObs != null && maxObs > 0;
            ArrayList<Observation> obsList = new ArrayList<Observation>();
            Observation obs = null;
            while (true) {
                TIME_FORMAT format;
                try {
                    if (!dataReaderEngine.moveNextObservation()) {
                        break;
                    }
                }
                catch (Throwable th) {
                    if (obs == null) {
                        throw new SdmxException(th, "Error occurred whilst trying to read frist observation in key");
                    }
                    throw new SdmxException(th, "Error occurred whilst trying to determine if series key had another observation, last successfully processed observation: " + obs);
                }
                obs = dataReaderEngine.getCurrentObservation();
                if (dateFrom != null) {
                    if (fromDateFormatted == null) {
                        format = obs.getObsTimeFormat();
                        fromDateFormatted = DateUtil.formatDate((Date)dateFrom, (TIME_FORMAT)format);
                    }
                    if (obs.getObsTime().compareTo(fromDateFormatted) < 0) {
                        filteredObs = true;
                        continue;
                    }
                }
                if (dateTo != null) {
                    if (toDateFormatted == null) {
                        format = obs.getObsTimeFormat();
                        toDateFormatted = DateUtil.formatDate((Date)dateTo, (TIME_FORMAT)format);
                    }
                    if (obs.getObsTime().compareTo(toDateFormatted) > 0) {
                        filteredObs = true;
                        continue;
                    }
                }
                if (!writtenKey) {
                    this.writeKeyableToWriter(dataWriterEngine, keyable);
                    writtenKey = true;
                }
                if (!hasMax) {
                    this.writeObsToWriter(dataWriterEngine, keyable, obs);
                    continue;
                }
                obsList.add(obs);
            }
            if (obsList.size() > 0) {
                Collections.sort(obsList);
                Collections.reverse(obsList);
                int loopCount = obsList.size() > maxObs ? maxObs.intValue() : obsList.size();
                for (int i = 0; i < loopCount; ++i) {
                    this.writeObsToWriter(dataWriterEngine, keyable, (Observation)obsList.get(i));
                }
            }
            if (!filteredObs && !writtenKey) {
                this.writeKeyableToWriter(dataWriterEngine, keyable);
            }
        } else {
            this.writeKeyableToWriter(dataWriterEngine, keyable);
        }
    }

    @Override
    public void writeObsToWriter(DataWriterEngine dataWriterEngine, Keyable keyable, Observation obs) {
        if (obs.isCrossSection()) {
            KeyValue crossSection = obs.getCrossSectionalValue();
            if (crossSection == null) {
                throw new SdmxSemmanticException("Dataset is cross sectional, missing cross section value for observation at time '" + keyable.getObsTime());
            }
            dataWriterEngine.writeObservation(crossSection.getConcept(), crossSection.getCode(), obs.getObservationValue(), this.getAnnotations(obs.getAnnotations()));
        } else {
            dataWriterEngine.writeObservation("TIME_PERIOD", obs.getObsTime(), obs.getObservationValue(), this.getAnnotations(obs.getAnnotations()));
        }
        if (obs.getAttributes() != null) {
            for (KeyValue kv : obs.getAttributes()) {
                dataWriterEngine.writeAttributeValue(kv.getConcept(), kv.getCode());
            }
        }
    }

    @Override
    public void writeKeyableToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, Keyable keyable, Integer maxObs) {
        this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, keyable, maxObs, null, null);
    }

    private void writeKeyableToWriter(DataWriterEngine dataWriterEngine, Keyable keyable) {
        if (keyable.isSeries()) {
            dataWriterEngine.startSeries(this.getAnnotations(keyable.getAnnotations()));
            for (KeyValue kv : keyable.getKey()) {
                dataWriterEngine.writeSeriesKeyValue(kv.getConcept(), kv.getCode());
            }
            if (!keyable.isTimeSeries()) {
                if (keyable.getObsTime() == null) {
                    throw new SdmxSemmanticException("Dataset is cross sectional, cross section is missing a time");
                }
                dataWriterEngine.writeSeriesKeyValue("TIME_PERIOD", keyable.getObsTime());
            }
        } else {
            dataWriterEngine.startGroup(keyable.getGroupName(), new AnnotationBean[0]);
            for (KeyValue kv : keyable.getKey()) {
                dataWriterEngine.writeGroupKeyValue(kv.getConcept(), kv.getCode());
            }
        }
        if (keyable.getAttributes() != null) {
            for (KeyValue kv : keyable.getAttributes()) {
                dataWriterEngine.writeAttributeValue(kv.getConcept(), kv.getCode());
            }
        }
    }

    private AnnotationBean[] getAnnotations(List<AnnotationBean> annotationList) {
        if (annotationList.size() == 0) {
            return null;
        }
        AnnotationBean[] annotationArr = new AnnotationBean[annotationList.size()];
        for (int i = 0; i < annotationList.size(); ++i) {
            annotationArr[i] = annotationList.get(i);
        }
        return annotationArr;
    }
}

