/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.constants;

public enum EDI_PREFIX {
    MESSAGE_START("UNA:+.? "),
    INTERCHANGE_HEADER("UNB+"),
    MESSAGE_IDENTIFICATION("UNH+"),
    MESSAGE_FUNCTION("BGM+"),
    END_MESSAGE_ADMINISTRATION("UNT+"),
    END_MESSAGE("UNZ+"),
    CONTACT_INFORMATION("CTA+"),
    COMMUNICATION_NUMBER("COM+"),
    DATA_START("DSI+"),
    DATASET_ACTION("STS+3+"),
    DATASET_DATETIME("DTM+"),
    DATASET_SEND_METHOD("GIS+AR3"),
    DATASET_MISSING_VALUE_SYMBOL("GIS+1:::"),
    DATASET_DATA("ARR++"),
    DATASET_DATAATTRIBUTE("ARR+"),
    DATASET_FOOTNOTE_SECTION("FNS+"),
    DATASET_ATTRIBUTE_SCOPE("REL+Z01+"),
    DATASET_ATTRIBUTE_CODED("IDE+Z10+"),
    MESSAGE_ID_PROVIDED_BY_SENDER("IDE+10+"),
    DATASET_ATTRIBUTE_UNCODED("IDE+Z11+"),
    DSD_REFERENCE("IDE+5+"),
    MESSAGE_AGENCY("NAD+Z02+"),
    RECIEVING_AGENCY("NAD+MR+"),
    SENDING_AGENCY("NAD+MS+"),
    CODELIST("VLI+"),
    CODE_VALUE("CDV+"),
    DSD("ASI+"),
    ATTRIBUTE("SCD+Z09+"),
    DIMENSION("SCD+"),
    CONCEPT("STC+"),
    STRING("FTX+ACM+++"),
    FIELD_LENGTH("ATT+3+5+:::"),
    USEAGE_STATUS("ATT+3+35+"),
    ATTRIBUTE_ATTACHMENT_VALUE("ATT+3+32+"),
    CODELIST_REFERENCE("IDE+1+");

    private String prefix;

    private EDI_PREFIX(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static EDI_PREFIX parseString(String str) {
        EDI_PREFIX[] eDI_PREFIXArray = EDI_PREFIX.values();
        int n = eDI_PREFIXArray.length;
        int n2 = 0;
        while (n2 < n) {
            EDI_PREFIX currentPrefix = eDI_PREFIXArray[n2];
            if (str.startsWith(currentPrefix.getPrefix())) {
                return currentPrefix;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown EDI Prefix for Line : " + str);
    }

    public boolean isMessageStart() {
        return this == MESSAGE_START;
    }

    public boolean isInterchangeHeader() {
        return this == INTERCHANGE_HEADER;
    }

    public boolean isMessageIdentification() {
        return this == MESSAGE_IDENTIFICATION;
    }

    public boolean isEndMessageAdministration() {
        return this == END_MESSAGE_ADMINISTRATION;
    }

    public boolean isCodelistReference() {
        return this == CODELIST_REFERENCE;
    }

    public boolean isAttribute() {
        return this == ATTRIBUTE;
    }

    public boolean isMessageFunction() {
        return this == MESSAGE_FUNCTION;
    }

    public boolean isCodelistSegment() {
        return this == CODELIST;
    }

    public boolean isConceptSegment() {
        return this == CONCEPT;
    }

    public boolean isDSDSegment() {
        return this == DSD;
    }

    public boolean isStructureSegment() {
        return this.isCodelistSegment() || this.isConceptSegment() || this.isDSDSegment();
    }

    public boolean isDataSegment() {
        return this == DATA_START;
    }

    public String toString() {
        return this.prefix;
    }
}

