/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureMapType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ComponentMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.mutable.base.SchemeMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.StructureMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.ComponentMapMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.ComponentMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.SchemeMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class StructureMapBeanImpl
extends SchemeMapBeanImpl
implements StructureMapBean {
    private static final long serialVersionUID = 1L;
    private List<ComponentMapBean> components = new ArrayList<ComponentMapBean>();
    private boolean extension;

    public StructureMapBeanImpl(StructureMapMutableBean structMapType, StructureSetBean parent) {
        super((SchemeMapMutableBean)structMapType, (IdentifiableBean)parent);
        this.extension = structMapType.isExtension();
        if (structMapType.getComponents() != null) {
            for (ComponentMapMutableBean mutable : structMapType.getComponents()) {
                this.components.add(new ComponentMapBeanImpl(mutable, (SdmxStructureBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    public StructureMapBeanImpl(StructureMapType structMapType, StructureSetBean parent) {
        super(structMapType, SDMX_STRUCTURE_TYPE.STRUCTURE_MAP, (IdentifiableBean)parent);
        this.sourceRef = RefUtil.createReference(this, structMapType.getSource());
        this.targetRef = RefUtil.createReference(this, structMapType.getTarget());
        if (ObjectUtil.validCollection(structMapType.getComponentMapList())) {
            for (ComponentMapType cmType : structMapType.getComponentMapList()) {
                this.components.add(new ComponentMapBeanImpl(cmType, (StructureMapBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    public StructureMapBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.StructureMapType structMapType, StructureSetBean parent) {
        super((XmlObject)structMapType, SDMX_STRUCTURE_TYPE.STRUCTURE_MAP, structMapType.getId(), null, structMapType.getNameList(), structMapType.getDescriptionList(), structMapType.getAnnotations(), (IdentifiableBean)parent);
        String agencyId;
        this.extension = structMapType.getIsExtension();
        if (structMapType.getKeyFamilyRef() != null) {
            if (ObjectUtil.validString((String[])new String[]{structMapType.getKeyFamilyRef().getURN()})) {
                this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, structMapType.getKeyFamilyRef().getURN());
            } else {
                agencyId = structMapType.getKeyFamilyRef().getKeyFamilyAgencyID();
                if (!ObjectUtil.validString((String[])new String[]{agencyId})) {
                    agencyId = this.getMaintainableParent().getAgencyId();
                }
                this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, agencyId, structMapType.getKeyFamilyRef().getKeyFamilyID(), structMapType.getKeyFamilyRef().getVersion(), SDMX_STRUCTURE_TYPE.DSD);
            }
        } else if (structMapType.getMetadataStructureRef() != null) {
            if (ObjectUtil.validString((String[])new String[]{structMapType.getMetadataStructureRef().getURN()})) {
                this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, structMapType.getMetadataStructureRef().getURN());
            } else {
                agencyId = structMapType.getKeyFamilyRef().getKeyFamilyAgencyID();
                if (!ObjectUtil.validString((String[])new String[]{agencyId})) {
                    agencyId = this.getMaintainableParent().getAgencyId();
                }
                this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, agencyId, structMapType.getMetadataStructureRef().getMetadataStructureID(), structMapType.getMetadataStructureRef().getVersion(), SDMX_STRUCTURE_TYPE.MSD);
            }
        }
        if (structMapType.getTargetKeyFamilyRef() != null) {
            if (ObjectUtil.validString((String[])new String[]{structMapType.getTargetKeyFamilyRef().getURN()})) {
                this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, structMapType.getTargetKeyFamilyRef().getURN());
            } else {
                agencyId = structMapType.getTargetKeyFamilyRef().getKeyFamilyAgencyID();
                if (!ObjectUtil.validString((String[])new String[]{agencyId})) {
                    agencyId = this.getMaintainableParent().getAgencyId();
                }
                this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, agencyId, structMapType.getTargetKeyFamilyRef().getKeyFamilyID(), structMapType.getTargetKeyFamilyRef().getVersion(), SDMX_STRUCTURE_TYPE.DSD);
            }
        } else if (structMapType.getTargetMetadataStructureRef() != null) {
            if (ObjectUtil.validString((String[])new String[]{structMapType.getTargetMetadataStructureRef().getURN()})) {
                this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, structMapType.getTargetMetadataStructureRef().getURN());
            } else {
                agencyId = structMapType.getTargetMetadataStructureRef().getMetadataStructureAgencyID();
                if (!ObjectUtil.validString((String[])new String[]{agencyId})) {
                    agencyId = this.getMaintainableParent().getAgencyId();
                }
                this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, agencyId, structMapType.getTargetMetadataStructureRef().getMetadataStructureID(), structMapType.getTargetMetadataStructureRef().getVersion(), SDMX_STRUCTURE_TYPE.MSD);
            }
        }
        if (structMapType.getComponentMapList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentMapType compMap : structMapType.getComponentMapList()) {
                ComponentMapBeanImpl cRef = new ComponentMapBeanImpl(compMap, (StructureMapBean)this);
                this.components.add(cRef);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            StructureMapBean that = (StructureMapBean)bean;
            if (!super.equivalent(this.components, that.getComponents(), includeFinalProperties)) {
                return false;
            }
            if (this.isExtension() != that.isExtension()) {
                return false;
            }
            return super.deepEqualsInternal((NameableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.sourceRef == null) {
            throw new SdmxSemmanticException("Structure Map missing source component");
        }
        if (this.targetRef == null) {
            throw new SdmxSemmanticException("Structure Map missing target component");
        }
        HashSet<SDMX_STRUCTURE_TYPE> allowedTypes = new HashSet<SDMX_STRUCTURE_TYPE>();
        allowedTypes.add(SDMX_STRUCTURE_TYPE.DATAFLOW);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.DSD);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.METADATA_FLOW);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.MSD);
        this.verifyTypes(allowedTypes, this.sourceRef.getTargetReference());
        this.verifyTypes(allowedTypes, this.targetRef.getTargetReference());
    }

    private void verifyTypes(Set<SDMX_STRUCTURE_TYPE> allowedTypes, SDMX_STRUCTURE_TYPE actualType) {
        if (!allowedTypes.contains(actualType)) {
            String allowedTypesStr = "";
            for (SDMX_STRUCTURE_TYPE currentType : allowedTypes) {
                allowedTypesStr = allowedTypesStr + currentType + ",";
            }
            allowedTypesStr = allowedTypesStr.substring(0, allowedTypesStr.length() - 2);
            throw new SdmxSemmanticException("Disallowed concept map type '" + actualType + "' allowed types are '" + allowedTypesStr + "'");
        }
    }

    public List<ComponentMapBean> getComponents() {
        return new ArrayList<ComponentMapBean>(this.components);
    }

    public boolean isExtension() {
        return this.extension;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.components, composites);
        return composites;
    }
}

