/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class KeyableImpl
implements Keyable {
    private DataStructureBean dataStructure;
    private DataflowBean dataflowBean;
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    private List<KeyValue> key = new ArrayList<KeyValue>();
    private Map<String, KeyValue> attributeMap = new HashMap<String, KeyValue>();
    private Map<String, String> keyMap = new HashMap<String, String>();
    private List<AnnotationBean> annotations = new ArrayList<AnnotationBean>();
    private boolean series;
    private String groupName;
    private TIME_FORMAT timeFormat;
    private String uniqueId;
    private String shotCode;
    private boolean isTimeSeries = true;
    private String crossSectionConcept;
    private String obsTime;
    private Date date;

    public KeyableImpl(DataflowBean dataflowBean, DataStructureBean dataStructure, List<KeyValue> key, List<KeyValue> attributes, TIME_FORMAT timeFormat, String crossSectionConcept, String obsTime, AnnotationBean ... annotationBeans) {
        this(dataflowBean, dataStructure, key, attributes, null, timeFormat, annotationBeans);
        this.isTimeSeries = false;
        this.crossSectionConcept = crossSectionConcept;
        this.obsTime = obsTime;
        if (obsTime == null) {
            throw new SdmxSemmanticException("Cross sectional dataset missing time value for key : " + this);
        }
    }

    public KeyableImpl(DataflowBean dataflowBean, DataStructureBean dataStructure, List<KeyValue> key, List<KeyValue> attributes, TIME_FORMAT timeFormat, AnnotationBean ... annotationBeans) {
        this(dataflowBean, dataStructure, key, attributes, null, timeFormat, annotationBeans);
    }

    public KeyableImpl(DataflowBean dataflowBean, DataStructureBean dataStructure, List<KeyValue> key, List<KeyValue> attributes, String groupName, AnnotationBean ... annotationBeans) {
        this(dataflowBean, dataStructure, key, attributes, groupName, (TIME_FORMAT)null, annotationBeans);
    }

    public KeyableImpl(DataflowBean dataflowBean, DataStructureBean dataStructure, List<KeyValue> key, List<KeyValue> attributes, String groupName, TIME_FORMAT timeFormat, AnnotationBean ... annotationBeans) {
        this.dataStructure = dataStructure;
        this.dataflowBean = dataflowBean;
        if (dataStructure == null) {
            throw new IllegalArgumentException("Data Structure can not be null");
        }
        this.series = !ObjectUtil.validString((String[])new String[]{groupName});
        if (attributes != null) {
            this.attributes = new ArrayList<KeyValue>(attributes);
            for (KeyValue currentKv : attributes) {
                this.attributeMap.put(currentKv.getConcept(), currentKv);
            }
        }
        if (key != null) {
            this.key = new ArrayList<KeyValue>(key);
            for (KeyValue currentKv : key) {
                this.keyMap.put(currentKv.getConcept(), currentKv.getCode());
            }
        }
        if (annotationBeans != null) {
            for (AnnotationBean currentAnnotation : annotationBeans) {
                this.annotations.add(currentAnnotation);
            }
        }
        this.groupName = groupName;
        this.timeFormat = timeFormat;
    }

    public List<AnnotationBean> getAnnotations() {
        return new ArrayList<AnnotationBean>(this.annotations);
    }

    public DataStructureBean getDataStructure() {
        return this.dataStructure;
    }

    public DataflowBean getDataflow() {
        return this.dataflowBean;
    }

    public String getShortCode() {
        if (this.shotCode == null) {
            this.generateUniqueId();
        }
        return this.shotCode;
    }

    public KeyValue getAttribute(String concept) {
        return this.attributeMap.get(concept);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public String getCrossSectionConcept() {
        return this.crossSectionConcept;
    }

    public String getObsTime() {
        return this.obsTime;
    }

    public String getKeyValue(String dimensionId) {
        return this.keyMap.get(dimensionId);
    }

    public Date getObsAsTimeDate() {
        if (this.isTimeSeries) {
            return null;
        }
        if (this.date == null) {
            this.date = DateUtil.formatDate((Object)this.obsTime, (boolean)true);
        }
        return new Date(this.date.getTime());
    }

    public List<KeyValue> getKey() {
        return new ArrayList<KeyValue>(this.key);
    }

    public List<KeyValue> getAttributes() {
        return new ArrayList<KeyValue>(this.attributes);
    }

    public boolean isSeries() {
        return this.series;
    }

    public TIME_FORMAT getTimeFormat() {
        return this.timeFormat;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyableImpl) {
            if (this.uniqueId == null) {
                this.generateUniqueId();
            }
            KeyableImpl that = (KeyableImpl)obj;
            if (that.uniqueId == null) {
                that.generateUniqueId();
            }
            return this.uniqueId.equals(that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        if (this.uniqueId == null) {
            this.generateUniqueId();
        }
        return this.uniqueId.hashCode();
    }

    private void generateUniqueId() {
        this.shotCode = "";
        String concat = "";
        StringBuilder sb = new StringBuilder();
        for (KeyValue kv : this.getKey()) {
            this.shotCode = this.shotCode + concat + kv.getCode();
            concat = ":";
            sb.append(kv.getConcept() + concat + kv.getCode());
        }
        for (KeyValue kv : this.getAttributes()) {
            sb.append(kv.getConcept() + concat + kv.getCode());
        }
        sb.append(this.series);
        if (this.groupName != null) {
            sb.append(this.groupName);
        }
        this.uniqueId = sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.series) {
            sb.append("series ");
        } else {
            sb.append("group " + this.groupName + " ");
        }
        String concat = "";
        for (KeyValue kv : this.key) {
            sb.append(concat);
            sb.append(kv.getConcept());
            sb.append(":");
            sb.append(kv.getCode());
            concat = ",";
        }
        if (!this.isTimeSeries) {
            sb.append(concat);
            sb.append(this.getObsTime());
        }
        return sb.toString();
    }
}

