/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex;

import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.ORDERED_OPERATOR;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_SEARCH;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexComponentValue;

public class ComplexComponentValueImpl
implements ComplexComponentValue {
    private String value;
    private TEXT_SEARCH textOperator;
    private ORDERED_OPERATOR orderedOperator;

    public ComplexComponentValueImpl(String value, TEXT_SEARCH textOperator, SDMX_STRUCTURE_TYPE componentType) {
        if (componentType.equals((Object)SDMX_STRUCTURE_TYPE.DIMENSION) || componentType.equals((Object)SDMX_STRUCTURE_TYPE.TIME_DIMENSION)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_ILLEGAL_OPERATOR, new Object[0]);
        }
        this.value = value;
        this.textOperator = textOperator != null ? textOperator : TEXT_SEARCH.EQUAL;
    }

    public ComplexComponentValueImpl(String value, ORDERED_OPERATOR orderedOperator, SDMX_STRUCTURE_TYPE componentType) {
        if (componentType.equals((Object)SDMX_STRUCTURE_TYPE.TIME_DIMENSION) && orderedOperator.equals((Object)ORDERED_OPERATOR.NOT_EQUAL)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_ILLEGAL_OPERATOR, new Object[0]);
        }
        this.value = value;
        this.orderedOperator = orderedOperator != null ? orderedOperator : ORDERED_OPERATOR.EQUAL;
    }

    public String getValue() {
        return this.value;
    }

    public TEXT_SEARCH getTextSearchOperator() {
        return this.textOperator;
    }

    public ORDERED_OPERATOR getOrderedOperator() {
        return this.orderedOperator;
    }

    public boolean equals(Object obj) {
        return obj instanceof ComplexComponentValue && ((ComplexComponentValue)obj).getValue().equals(this.value) && ((ComplexComponentValue)obj).getOrderedOperator().equals((Object)this.orderedOperator) && ((ComplexComponentValue)obj).getTextSearchOperator().equals((Object)this.textOperator);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Operator");
        sb.append(" : ");
        if (this.textOperator != null) {
            sb.append(this.textOperator.toString());
        }
        if (this.orderedOperator != null) {
            sb.append(this.orderedOperator.toString());
        }
        sb.append("applied upon ");
        sb.append(this.value);
        return sb.toString();
    }
}

