/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.factory.WriteableDataLocationFactory;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.dataparser.manager.DataParseManager;
import org.sdmxsource.sdmx.dataparser.manager.DataReaderManager;
import org.sdmxsource.sdmx.dataparser.manager.DataWriterManager;
import org.sdmxsource.sdmx.dataparser.transform.DataReaderWriterTransform;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataParseManagerImpl
implements DataParseManager {
    private final Logger log = Logger.getLogger(DataParseManagerImpl.class);
    @Autowired
    private DataReaderManager dataReaderManager;
    @Autowired
    private DataWriterManager dataWriterManager;
    @Autowired
    private DataReaderWriterTransform dataReaderWriterTransform;
    @Autowired
    private StructureParsingManager structureParsingManager;
    @Autowired
    private WriteableDataLocationFactory writeableDataLocationFactory;

    @Override
    public void performTransform(ReadableDataLocation sourceData, ReadableDataLocation dsdLocation, OutputStream out, DataFormat dataFormat) {
        SdmxBeans beans = this.structureParsingManager.parseStructures(dsdLocation).getStructureBeans(false);
        this.performTransform(sourceData, out, dataFormat, (SdmxBeanRetrievalManager)new InMemoryRetrievalManager(beans));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performTransform(ReadableDataLocation sourceData, OutputStream out, DataFormat dataFormat, DataStructureBean dsd, DataflowBean flow) {
        LoggingUtil.debug((Logger)this.log, (String)"Perform transform request");
        try {
            DataReaderEngine dre = this.dataReaderManager.getDataReaderEngine(sourceData, dsd, flow);
            DataWriterEngine dwe = this.dataWriterManager.getDataWriterEngine(dataFormat, out);
            this.dataReaderWriterTransform.copyToWriter(dre, dwe, true, true);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
            throw throwable;
        }
        StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
    }

    @Override
    public List<ReadableDataLocation> performTransformAndSplit(ReadableDataLocation sourceData, ReadableDataLocation dsdLocation, DataFormat dataFormat) {
        SdmxBeans beans = this.structureParsingManager.parseStructures(dsdLocation).getStructureBeans(false);
        InMemoryRetrievalManager retrievalManager = new InMemoryRetrievalManager(beans);
        return this.performTransformAndSplit(sourceData, dataFormat, (SdmxBeanRetrievalManager)retrievalManager);
    }

    @Override
    public List<ReadableDataLocation> performTransformAndSplit(ReadableDataLocation sourceData, DataFormat dataFormat, SdmxBeanRetrievalManager retrievalManager) {
        DataReaderEngine dre = this.dataReaderManager.getDataReaderEngine(sourceData, retrievalManager);
        ArrayList<ReadableDataLocation> returnList = new ArrayList<ReadableDataLocation>();
        while (dre.moveNextDataset()) {
            WriteableDataLocation tmpDataLocation = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
            DataWriterEngine dwe = this.dataWriterManager.getDataWriterEngine(dataFormat, tmpDataLocation.getOutputStream());
            this.dataReaderWriterTransform.copyDatasetToWriter(dre, dwe, null, true, null, null, null, true, true);
            returnList.add((ReadableDataLocation)tmpDataLocation);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performTransform(ReadableDataLocation sourceData, OutputStream out, DataFormat dataFormat, SdmxBeanRetrievalManager beanRetrievalManager) {
        LoggingUtil.debug((Logger)this.log, (String)"Perform transform request");
        DataReaderEngine dre = null;
        DataWriterEngine dwe = null;
        try {
            dre = this.dataReaderManager.getDataReaderEngine(sourceData, beanRetrievalManager);
            dwe = this.dataWriterManager.getDataWriterEngine(dataFormat, out);
            this.dataReaderWriterTransform.copyToWriter(dre, dwe, true, true);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
            if (dre != null) {
                dre.close();
            }
            if (dwe != null) {
                dwe.close(new DataWriterEngine.FooterMessage[0]);
            }
            throw throwable;
        }
        StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
        if (dre != null) {
            dre.close();
        }
        if (dwe != null) {
            dwe.close(new DataWriterEngine.FooterMessage[0]);
        }
    }

    @Override
    public ReadableDataLocation performTransform(ReadableDataLocation sourceData, DataFormat dataFormat, SdmxBeanRetrievalManager beanRetrievalManager) {
        WriteableDataLocation writeableDataLocation;
        block5: {
            WriteableDataLocation tmpDataLocation = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
            try {
                LoggingUtil.debug((Logger)this.log, (String)("URI generated to write transformed dataset to :" + tmpDataLocation.toString()));
                this.performTransform(sourceData, tmpDataLocation.getOutputStream(), dataFormat, beanRetrievalManager);
                writeableDataLocation = tmpDataLocation;
                if (tmpDataLocation == null) break block5;
            }
            catch (RuntimeException rtEx) {
                try {
                    tmpDataLocation.close();
                    throw rtEx;
                }
                catch (Throwable throwable) {
                    if (tmpDataLocation != null) {
                        StreamUtil.closeStream((OutputStream[])new OutputStream[]{tmpDataLocation.getOutputStream()});
                    }
                    throw throwable;
                }
            }
            StreamUtil.closeStream((OutputStream[])new OutputStream[]{tmpDataLocation.getOutputStream()});
        }
        return writeableDataLocation;
    }

    @Override
    public ReadableDataLocation performTransform(ReadableDataLocation sourceData, DataFormat dataFormat, DataStructureBean dsd, DataflowBean flow) {
        OutputStream outputstream = null;
        WriteableDataLocation tmpBuffer = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
        try {
            LoggingUtil.debug((Logger)this.log, (String)("URI generated to write transformed dataset to :" + tmpBuffer.toString()));
            outputstream = tmpBuffer.getOutputStream();
            this.performTransform(sourceData, outputstream, dataFormat, dsd, flow);
            WriteableDataLocation writeableDataLocation = tmpBuffer;
            return writeableDataLocation;
        }
        catch (RuntimeException rtEx) {
            tmpBuffer.close();
            throw rtEx;
        }
        finally {
            if (outputstream != null) {
                try {
                    outputstream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

