/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryStructureResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StructureType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.MaintainableBeanException;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalDataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalMeasureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AgencySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataConsumerSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataProviderSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.ReportingTaxonomyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchicalCodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.CrossSectionalDataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.StructureSetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ProcessBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl.AbstractSdmxBeansV2Builder;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class SdmxBeansV2RegDocBuilder
extends AbstractSdmxBeansV2Builder
implements Builder<SdmxBeans, RegistryInterfaceDocument> {
    public SdmxBeans build(RegistryInterfaceDocument rid) throws SdmxException {
        RegistryInterfaceType rit = rid.getRegistryInterface();
        SdmxBeansImpl beans = new SdmxBeansImpl((HeaderBean)new HeaderBeanImpl(rit.getHeader()));
        if (rit.getSubmitStructureRequest() != null && rit.getSubmitStructureRequest().getStructure() != null) {
            this.build(rit.getSubmitStructureRequest().getStructure(), (SdmxBeans)beans);
        }
        if (rit.getQueryStructureResponse() != null) {
            this.build(rit.getQueryStructureResponse(), (SdmxBeans)beans);
        }
        return beans;
    }

    public SdmxBeans build(StructureType structures, SdmxBeans beans) throws SdmxException {
        HashSet<String> urns = new HashSet<String>();
        this.processCategorySchemes(structures.getCategorySchemes(), beans);
        if (structures.getCodeLists() != null && structures.getCodeLists().getCodeListList() != null) {
            for (CodeListType currentType : structures.getCodeLists().getCodeListList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new CodelistBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CODE_LIST, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        if (structures.getConcepts() != null && structures.getConcepts().getConceptSchemeList() != null) {
            for (CodeListType currentType : structures.getConcepts().getConceptSchemeList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ConceptSchemeBeanImpl((ConceptSchemeType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        HashMap conceptAgencyMap = new HashMap();
        if (structures.getConcepts() != null && structures.getConcepts().getConceptList() != null) {
            for (ConceptType currentType : structures.getConcepts().getConceptList()) {
                List<ConceptType> concepts;
                if (conceptAgencyMap.containsKey(currentType.getAgencyID())) {
                    concepts = (List)conceptAgencyMap.get(currentType.getAgencyID());
                } else {
                    concepts = new ArrayList();
                    conceptAgencyMap.put(currentType.getAgencyID(), concepts);
                }
                concepts.add(currentType);
            }
        }
        for (String currentConceptAgency : conceptAgencyMap.keySet()) {
            try {
                this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ConceptSchemeBeanImpl((List)conceptAgencyMap.get(currentConceptAgency), currentConceptAgency));
            }
            catch (Throwable th) {
                throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentConceptAgency, "STANDALONE_CONCEPT_SCHEME", "1.0");
            }
        }
        this.processDataflows(structures.getDataflows(), beans);
        if (structures.getHierarchicalCodelists() != null && structures.getHierarchicalCodelists().getHierarchicalCodelistList() != null) {
            for (ConceptType currentType : structures.getHierarchicalCodelists().getHierarchicalCodelistList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new HierarchicalCodelistBeanImpl((HierarchicalCodelistType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        if (structures.getKeyFamilies() != null && structures.getKeyFamilies().getKeyFamilyList() != null) {
            for (ConceptType currentType : structures.getKeyFamilies().getKeyFamilyList()) {
                try {
                    if (currentType.getComponents() != null && ObjectUtil.validCollection((Collection)currentType.getComponents().getCrossSectionalMeasureList())) {
                        CrossSectionalDataStructureBeanImpl xsdBean = new CrossSectionalDataStructureBeanImpl((KeyFamilyType)currentType);
                        CrossSectionalDataStructureMutableBean mutable = xsdBean.getMutableInstance();
                        CrossSectionalMeasureMutableBean xsMutable = (CrossSectionalMeasureMutableBean)mutable.getCrossSectionalMeasures().get(0);
                        StructureReferenceBean sRef = xsMutable.getConceptRef();
                        HashMap<String, StructureReferenceBean> mapping = new HashMap<String, StructureReferenceBean>();
                        StructureReferenceBeanImpl cocneptSchemeRef = new StructureReferenceBeanImpl(sRef.getMaintainableReference(), SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
                        for (DimensionMutableBean dim : mutable.getDimensions()) {
                            mapping.put(dim.getId(), dim.getRepresentation().getRepresentation());
                            if (!dim.isMeasureDimension()) continue;
                            dim.getRepresentation().setRepresentation((StructureReferenceBean)cocneptSchemeRef);
                        }
                        mutable.setMeasureDimensionCodelistMapping(mapping);
                        continue;
                    }
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataStructureBeanImpl((KeyFamilyType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DSD, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        this.processMetadataFlows(structures.getMetadataflows(), beans);
        if (structures.getMetadataStructureDefinitions() != null && structures.getMetadataStructureDefinitions().getMetadataStructureDefinitionList() != null) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1"});
        }
        if (structures.getOrganisationSchemes() != null) {
            for (OrganisationSchemeType orgSchemeType : structures.getOrganisationSchemes().getOrganisationSchemeList()) {
                if (ObjectUtil.validCollection((Collection)orgSchemeType.getAgenciesList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new AgencySchemeBeanImpl(orgSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, orgSchemeType.getAgencyID(), orgSchemeType.getId(), orgSchemeType.getVersion());
                    }
                }
                if (ObjectUtil.validCollection((Collection)orgSchemeType.getDataConsumersList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataConsumerSchemeBeanImpl(orgSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, orgSchemeType.getAgencyID(), orgSchemeType.getId(), orgSchemeType.getVersion());
                    }
                }
                if (ObjectUtil.validCollection((Collection)orgSchemeType.getDataProvidersList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataProviderSchemeBeanImpl(orgSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, orgSchemeType.getAgencyID(), orgSchemeType.getId(), orgSchemeType.getVersion());
                    }
                }
                if (!orgSchemeType.getAgenciesList().isEmpty() || !orgSchemeType.getDataConsumersList().isEmpty() || !orgSchemeType.getDataProvidersList().isEmpty()) continue;
                throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_INVALID_ORGANISATION_SCHEME_NO_CONTENT, new Object[]{orgSchemeType.getAgencyID(), orgSchemeType.getId()});
            }
        }
        if (structures.getProcesses() != null && structures.getProcesses().getProcessList() != null) {
            for (ConceptType currentType : structures.getProcesses().getProcessList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ProcessBeanImpl((ProcessType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.PROCESS, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        if (structures.getReportingTaxonomies() != null && structures.getReportingTaxonomies().getReportingTaxonomyList() != null) {
            for (ConceptType currentType : structures.getReportingTaxonomies().getReportingTaxonomyList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ReportingTaxonomyBeanImpl((ReportingTaxonomyType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        if (structures.getStructureSets() != null && structures.getStructureSets().getStructureSetList() != null) {
            for (ConceptType currentType : structures.getStructureSets().getStructureSetList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new StructureSetBeanImpl((StructureSetType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        return beans;
    }

    private SdmxBeans build(QueryStructureResponseType structures, SdmxBeans beans) {
        ConceptType currentType3;
        HashSet<String> urns = new HashSet<String>();
        this.processCategorySchemes(structures.getCategorySchemes(), beans);
        if (structures.getCodeLists() != null && structures.getCodeLists().getCodeListList() != null) {
            for (CodeListType currentType2 : structures.getCodeLists().getCodeListList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new CodelistBeanImpl(currentType2));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CODE_LIST, currentType2.getAgencyID(), currentType2.getId(), currentType2.getVersion());
                }
            }
        }
        if (structures.getConcepts() != null && structures.getConcepts().getConceptSchemeList() != null) {
            for (CodeListType currentType2 : structures.getConcepts().getConceptSchemeList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ConceptSchemeBeanImpl((ConceptSchemeType)currentType2));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentType2.getAgencyID(), currentType2.getId(), currentType2.getVersion());
                }
            }
        }
        HashMap conceptAgencyMap = new HashMap();
        if (structures.getConcepts() != null && structures.getConcepts().getConceptList() != null) {
            for (ConceptType currentType3 : structures.getConcepts().getConceptList()) {
                List<ConceptType> concepts;
                if (conceptAgencyMap.containsKey(currentType3.getAgencyID())) {
                    concepts = (List)conceptAgencyMap.get(currentType3.getAgencyID());
                } else {
                    concepts = new ArrayList();
                    conceptAgencyMap.put(currentType3.getAgencyID(), concepts);
                }
                concepts.add(currentType3);
            }
        }
        Iterator<Object> iterator = conceptAgencyMap.keySet().iterator();
        while (iterator.hasNext()) {
            String currentConceptAgency = (String)iterator.next();
            try {
                this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ConceptSchemeBeanImpl((List)conceptAgencyMap.get(currentConceptAgency), currentConceptAgency));
            }
            catch (Throwable th) {
                throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentConceptAgency, "STANDALONE_CONCEPT_SCHEME", "1.0");
            }
        }
        this.processDataflows(structures.getDataflows(), beans);
        if (structures.getHierarchicalCodelists() != null && structures.getHierarchicalCodelists().getHierarchicalCodelistList() != null) {
            iterator = structures.getHierarchicalCodelists().getHierarchicalCodelistList().iterator();
            while (iterator.hasNext()) {
                currentType3 = (HierarchicalCodelistType)iterator.next();
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new HierarchicalCodelistBeanImpl((HierarchicalCodelistType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        if (structures.getKeyFamilies() != null && structures.getKeyFamilies().getKeyFamilyList() != null) {
            iterator = structures.getKeyFamilies().getKeyFamilyList().iterator();
            while (iterator.hasNext()) {
                currentType3 = (KeyFamilyType)iterator.next();
                try {
                    if (this.isXsDataStructure((KeyFamilyType)currentType3)) {
                        CrossSectionalDataStructureBeanImpl xsdBean = new CrossSectionalDataStructureBeanImpl((KeyFamilyType)currentType3);
                        CrossSectionalDataStructureMutableBean mutable = xsdBean.getMutableInstance();
                        CrossSectionalMeasureMutableBean xsMutable = (CrossSectionalMeasureMutableBean)mutable.getCrossSectionalMeasures().get(0);
                        StructureReferenceBean sRef = xsMutable.getConceptRef();
                        HashMap<String, StructureReferenceBean> mapping = new HashMap<String, StructureReferenceBean>();
                        StructureReferenceBeanImpl cocneptSchemeRef = new StructureReferenceBeanImpl(sRef.getMaintainableReference(), SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
                        for (DimensionMutableBean dim : mutable.getDimensions()) {
                            if (!dim.isMeasureDimension()) continue;
                            mapping.put(dim.getId(), dim.getRepresentation().getRepresentation());
                            dim.getRepresentation().setRepresentation((StructureReferenceBean)cocneptSchemeRef);
                        }
                        mutable.setMeasureDimensionCodelistMapping(mapping);
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)mutable.getImmutableInstance());
                        continue;
                    }
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataStructureBeanImpl((KeyFamilyType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DSD, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        this.processMetadataFlows(structures.getMetadataflows(), beans);
        if (structures.getMetadataStructureDefinitions() != null && structures.getMetadataStructureDefinitions().getMetadataStructureDefinitionList() != null && (iterator = structures.getMetadataStructureDefinitions().getMetadataStructureDefinitionList().iterator()).hasNext()) {
            currentType3 = (MetadataStructureDefinitionType)iterator.next();
            try {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1"});
            }
            catch (Throwable th) {
                throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.MSD, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
            }
        }
        if (structures.getOrganisationSchemes() != null) {
            for (ConceptType currentType3 : structures.getOrganisationSchemes().getOrganisationSchemeList()) {
                if (ObjectUtil.validCollection((Collection)currentType3.getAgenciesList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new AgencySchemeBeanImpl((OrganisationSchemeType)currentType3));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                    }
                }
                if (ObjectUtil.validCollection((Collection)currentType3.getDataConsumersList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataConsumerSchemeBeanImpl((OrganisationSchemeType)currentType3));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                    }
                }
                if (!ObjectUtil.validCollection((Collection)currentType3.getDataProvidersList())) continue;
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new DataProviderSchemeBeanImpl((OrganisationSchemeType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        if (structures.getProcesses() != null && structures.getProcesses().getProcessList() != null) {
            for (ConceptType currentType3 : structures.getProcesses().getProcessList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ProcessBeanImpl((ProcessType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.PROCESS, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        if (structures.getReportingTaxonomies() != null && structures.getReportingTaxonomies().getReportingTaxonomyList() != null) {
            for (ConceptType currentType3 : structures.getReportingTaxonomies().getReportingTaxonomyList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new ReportingTaxonomyBeanImpl((ReportingTaxonomyType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        if (structures.getStructureSets() != null && structures.getStructureSets().getStructureSetList() != null) {
            for (ConceptType currentType3 : structures.getStructureSets().getStructureSetList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, (IdentifiableBean)new StructureSetBeanImpl((StructureSetType)currentType3));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, currentType3.getAgencyID(), currentType3.getId(), currentType3.getVersion());
                }
            }
        }
        return beans;
    }

    private boolean isXsDataStructure(KeyFamilyType keyFamilyType) {
        ComponentsType components = keyFamilyType.getComponents();
        if (components != null) {
            if (ObjectUtil.validCollection((Collection)components.getDimensionList())) {
                for (DimensionType dim : components.getDimensionList()) {
                    if (!dim.getCrossSectionalAttachDataSet() && !dim.getCrossSectionalAttachGroup() && !dim.getCrossSectionalAttachSection() && !dim.getCrossSectionalAttachObservation()) continue;
                    return true;
                }
            }
            if (ObjectUtil.validCollection((Collection)components.getAttributeList())) {
                for (AttributeType att : components.getAttributeList()) {
                    if (!att.getCrossSectionalAttachDataSet() && !att.getCrossSectionalAttachGroup() && !att.getCrossSectionalAttachSection() && !att.getCrossSectionalAttachObservation()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

