/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttributeListType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureComponentsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DimensionListType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MaintainableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MeasureListType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.MeasureListBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.AttributeXmlAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.DimensionXmlAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.GroupXmlAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.MaintainableBeanAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.MeasureDimensionXmlAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.PrimaryMeasureXmlAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.TimeDimensionXmlAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStructureXmlBeanBuilder
extends MaintainableBeanAssembler
implements Builder<DataStructureType, DataStructureBean> {
    @Autowired
    private DimensionXmlAssembler dimensionXmlAssembler;
    @Autowired
    private MeasureDimensionXmlAssembler measureDimensionXmlAssembler;
    @Autowired
    private TimeDimensionXmlAssembler timeDimensionXmlAssembler;
    @Autowired
    private GroupXmlAssembler groupXmlAssembler;
    @Autowired
    private AttributeXmlAssembler attributeXmlAssembler;
    @Autowired
    private PrimaryMeasureXmlAssembler primaryMeasureXmlAssembler;

    public DataStructureType build(DataStructureBean buildFrom) throws SdmxException {
        DataStructureType builtObj = DataStructureType.Factory.newInstance();
        super.assembleMaintainable((MaintainableType)builtObj, (MaintainableBean)buildFrom);
        DataStructureComponentsType components = null;
        if (buildFrom.getDimensions(new SDMX_STRUCTURE_TYPE[0]).size() > 0) {
            if (components == null) {
                components = builtObj.addNewDataStructureComponents();
            }
            this.processDimensionList(components.addNewDimensionList(), buildFrom.getDimensionList());
        }
        if (ObjectUtil.validCollection((Collection)buildFrom.getGroups())) {
            if (components == null) {
                components = builtObj.addNewDataStructureComponents();
            }
            for (GroupBean currentGroup : buildFrom.getGroups()) {
                this.groupXmlAssembler.assemble(components.addNewGroup(), currentGroup);
            }
        }
        if (buildFrom.getAttributes().size() > 0) {
            if (components == null) {
                components = builtObj.addNewDataStructureComponents();
            }
            this.processAttributeList(components.addNewAttributeList(), buildFrom.getAttributeList());
        }
        if (buildFrom.getPrimaryMeasure() != null) {
            if (components == null) {
                components = builtObj.addNewDataStructureComponents();
            }
            this.processMeasureList(components.addNewMeasureList(), buildFrom.getMeasureList());
        }
        return builtObj;
    }

    private void processDimensionList(DimensionListType dimensionListType, DimensionListBean dimensionList) {
        super.assembleIdentifiable((IdentifiableType)dimensionListType, (IdentifiableBean)dimensionList);
        if (dimensionList.getDimensions() != null) {
            for (DimensionBean currentDimension : dimensionList.getDimensions()) {
                if (currentDimension.isMeasureDimension()) {
                    this.measureDimensionXmlAssembler.assemble(dimensionListType.addNewMeasureDimension(), currentDimension);
                    continue;
                }
                if (currentDimension.isTimeDimension()) {
                    this.timeDimensionXmlAssembler.assemble(dimensionListType.addNewTimeDimension(), currentDimension);
                    continue;
                }
                this.dimensionXmlAssembler.assemble(dimensionListType.addNewDimension(), currentDimension);
            }
        }
    }

    private void processAttributeList(AttributeListType attributeListType, AttributeListBean attributeList) {
        super.assembleIdentifiable((IdentifiableType)attributeListType, (IdentifiableBean)attributeList);
        if (attributeList.getAttributes() != null) {
            for (AttributeBean currentAttribute : attributeList.getAttributes()) {
                this.attributeXmlAssembler.assemble(attributeListType.addNewAttribute(), currentAttribute);
            }
        }
    }

    private void processMeasureList(MeasureListType measureListType, MeasureListBean measureList) {
        super.assembleIdentifiable((IdentifiableType)measureListType, (IdentifiableBean)measureList);
        if (measureList.getPrimaryMeasure() != null) {
            this.primaryMeasureXmlAssembler.assemble(measureListType.addNewPrimaryMeasure(), measureList.getPrimaryMeasure());
        }
    }
}

