/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ColumnTypeParameter
extends LeafParameter<ColumnType> {
    private static final List<ColumnType> DEFAULT_ALLOWED_COLUMN_TYPES = new ArrayList<ColumnType>();
    private List<ColumnType> allowedColumnTypes;

    private ColumnTypeParameter() {
    }

    public ColumnTypeParameter(String identifier, String name, String description, Cardinality cardinality, List<ColumnType> allowedColumnTypes) {
        super(identifier, name, description, cardinality);
        this.allowedColumnTypes = allowedColumnTypes;
    }

    public ColumnTypeParameter(String identifier, String name, String description, Cardinality cardinality) {
        this(identifier, name, description, cardinality, DEFAULT_ALLOWED_COLUMN_TYPES);
    }

    public List<ColumnType> getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    @Override
    public Class<ColumnType> getParameterType() {
        return ColumnType.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedColumnTypes == null ? 0 : this.allowedColumnTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnTypeParameter other = (ColumnTypeParameter)obj;
        return !(this.allowedColumnTypes == null ? other.allowedColumnTypes != null : !this.allowedColumnTypes.equals(other.allowedColumnTypes));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnTypeParameter [getAllowedColumnTypes()=");
        builder.append(this.getAllowedColumnTypes());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object value) throws Exception {
        super.validateValue(value);
        boolean ok = false;
        for (ColumnType allowed : this.allowedColumnTypes) {
            if (!allowed.getClass().equals(value.getClass())) continue;
            ok = true;
        }
        if (!ok) {
            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getAllowedColumnTypes()));
        }
    }

    static {
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new AnnotationColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new AttributeColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new CodeColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new CodeDescriptionColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new CodeNameColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new DimensionColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new MeasureColumnType());
        DEFAULT_ALLOWED_COLUMN_TYPES.add((ColumnType)new TimeDimensionColumnType());
    }
}

