/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.rest;

import java.io.OutputStream;
import org.sdmxsource.sdmx.api.exception.SdmxNoResultsException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.output.SchemaWriterManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.rest.RestSchemaQueryManager;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.format.SchemaFormat;
import org.sdmxsource.sdmx.api.model.query.RESTSchemaQuery;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.ProvisionAgreementSuperBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class RestSchemaQueryManagerImpl
implements RestSchemaQueryManager {
    private SdmxSuperBeanRetrievalManager superBeanRetrievalManager;
    @Autowired
    private SchemaWriterManager schemaWriterManager;

    public void writeSchema(RESTSchemaQuery schemaQuery, SchemaFormat format, OutputStream out) {
        DataStructureSuperBean dsd = null;
        StructureReferenceBean sRef = schemaQuery.getReference();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        switch (sRef.getTargetReference()) {
            case DATAFLOW: {
                DataflowSuperBean flow = this.superBeanRetrievalManager.getDataflowSuperBean(mRef);
                if (flow == null) {
                    throw new SdmxNoResultsException("No dataflow found for argument:" + mRef);
                }
                dsd = flow.getDataStructure();
                break;
            }
            case DSD: {
                dsd = this.superBeanRetrievalManager.getDataStructureSuperBean(mRef);
                if (dsd != null) break;
                throw new SdmxNoResultsException("No data structure found for argument:" + mRef);
            }
            case PROVISION_AGREEMENT: {
                ProvisionAgreementSuperBean provision = this.superBeanRetrievalManager.getProvisionAgreementSuperBean(mRef);
                if (provision == null) {
                    throw new SdmxNoResultsException("No provision found for argument:" + mRef);
                }
                dsd = provision.getDataflowSuperBean().getDataStructure();
                break;
            }
            default: {
                throw new SdmxNotImplementedException("Schema query by " + sRef.getTargetReference().getType());
            }
        }
        if ("TIME_PERIOD".equals(schemaQuery.getDimAtObs())) {
            this.schemaWriterManager.generateSchema(out, dsd, format, null, null);
        } else {
            this.schemaWriterManager.generateCrossSectionalSchema(out, dsd, format, null, schemaQuery.getDimAtObs(), null);
        }
    }

    @Required
    public void setSuperBeanRetrievalManager(SdmxSuperBeanRetrievalManager superBeanRetrievalManager) {
        this.superBeanRetrievalManager = superBeanRetrievalManager;
    }
}

