/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.CodelistMappingFileUploadSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    protected static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final String[] ZIP_MIMETYPES = new String[]{"application/x-compress", "application/x-compressed", "application/x-gzip", "application/x-winzip", "application/x-zip", "application/zip", "multipart/x-zip"};

    public static boolean isZipContentType(String contentType) {
        String[] stringArray = ZIP_MIMETYPES;
        int n = ZIP_MIMETYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String zip_mimetype = stringArray[n2];
            if (zip_mimetype.equals(contentType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String unZip(InputStream is, OutputStream os) throws Exception {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
            }
            if (entry == null || entry.isDirectory()) {
                zis.close();
                os.close();
                throw new Exception("Unzip error: No file entry found");
            }
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            os.close();
            return entry.getName();
        }
        catch (IOException e) {
            throw new Exception("Unzip error: " + e.getMessage(), e);
        }
    }

    public static String exceptionDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        StringBuilder message = new StringBuilder("Error message:\n");
        message.append(out.toString());
        return message.toString();
    }

    public static void setImportFileCSV(CSVFileUploadSession fileUploadSession, InputStream is, String name, String mimeType) throws Exception {
        File csvTmp = FileUtil.setImportFile(is, "import", ".csv", name, mimeType);
        fileUploadSession.setCsvName(name);
        fileUploadSession.setCsvFile(csvTmp);
    }

    public static void setImportFileCodelistMapping(CodelistMappingFileUploadSession fileUploadSession, InputStream is, String name, String mimeType) throws Exception {
        File xmlTmp = FileUtil.setImportFile(is, "importCodMap", ".xml", name, mimeType);
        fileUploadSession.setCodelistMappingName(name);
        fileUploadSession.setCodelistMappingFile(xmlTmp);
    }

    public static File setImportFile(InputStream is, String tempName, String extention, String name, String mimeType) throws Exception {
        File fileTmp = File.createTempFile(tempName, extention);
        fileTmp.deleteOnExit();
        logger.debug("Import File mimeType: " + mimeType);
        if (FileUtil.isZipContentType(mimeType)) {
            logger.trace("is a zip file");
            name = FileUtil.unZip(is, new FileOutputStream(fileTmp));
        } else {
            logger.trace("is a text file");
            IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(fileTmp));
        }
        logger.trace("upload completed");
        return fileTmp;
    }
}

