/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelectionGroup;
import org.sdmxsource.sdmx.api.model.query.RESTDataQuery;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.BaseDataQuery;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryDimensionSelectionImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQuerySelectionGroupImpl;
import org.sdmxsource.util.ObjectUtil;

public class DataQueryImpl
extends BaseDataQuery
implements DataQuery {
    private static final long serialVersionUID = 1L;
    private Set<DataProviderBean> dataProviders = new HashSet<DataProviderBean>();
    private List<DataQuerySelectionGroup> dataQuerySelectionGroups = new ArrayList<DataQuerySelectionGroup>();
    private SdmxDate lastUpdated;
    private DATA_QUERY_DETAIL dataQueryDetail = DATA_QUERY_DETAIL.FULL;

    public DataQueryImpl(RESTDataQuery dataQuery, SdmxBeanRetrievalManager retrievalManager) {
        this.lastUpdated = dataQuery.getUpdatedAfter();
        if (dataQuery.getQueryDetail() != null) {
            this.dataQueryDetail = dataQuery.getQueryDetail();
        }
        this.firstNObs = dataQuery.getFirstNObservations();
        this.lastNObs = dataQuery.getlastNObsertations();
        if (ObjectUtil.validString((String[])new String[]{dataQuery.getDimensionAtObservation()})) {
            this.dimensionAtObservation = dataQuery.getDimensionAtObservation();
        }
        this.dataflowBean = (DataflowBean)retrievalManager.getMaintainableBean(DataflowBean.class, dataQuery.getFlowRef().getMaintainableReference());
        if (this.dataflowBean == null) {
            throw new SdmxSemmanticException("Data Flow could not be found for query : " + dataQuery.getFlowRef());
        }
        this.dataStructureBean = (DataStructureBean)retrievalManager.getMaintainableBean(DataStructureBean.class, this.dataflowBean.getDataStructureRef().getMaintainableReference());
        if (this.dataStructureBean == null) {
            throw new SdmxSemmanticException("DSD could not be found for query : " + this.dataflowBean.getDataStructureRef());
        }
        if (dataQuery.getProviderRef() != null) {
            Set dataProviderSchemes = retrievalManager.getMaintainableBeans(DataProviderSchemeBean.class, dataQuery.getProviderRef().getMaintainableReference());
            for (DataProviderSchemeBean currentDpScheme : dataProviderSchemes) {
                for (DataProviderBean dataProvider : currentDpScheme.getItems()) {
                    if (!dataProvider.getId().equals(dataQuery.getProviderRef().getChildReference().getId())) continue;
                    this.dataProviders.add(dataProvider);
                }
            }
        }
        HashSet<DataQuerySelection> selections = new HashSet<DataQuerySelection>();
        if (dataQuery.getQueryList().size() > 0) {
            int i = 0;
            for (DimensionBean dimension : this.dataStructureBean.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
                if (dataQuery.getQueryList().size() <= i) {
                    throw new SdmxSemmanticException("Not enough key values in query, expecting " + this.dataStructureBean.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION}).size() + " got " + dataQuery.getQueryList().size());
                }
                Set queriesForDimension = (Set)dataQuery.getQueryList().get(i);
                if (queriesForDimension != null && queriesForDimension.size() > 0) {
                    DataQueryDimensionSelectionImpl selectionsForDimension = new DataQueryDimensionSelectionImpl(dimension.getId(), new HashSet<String>(queriesForDimension));
                    selections.add(selectionsForDimension);
                }
                ++i;
            }
        }
        if (ObjectUtil.validCollection(selections) || dataQuery.getStartPeriod() != null || dataQuery.getEndPeriod() != null) {
            this.dataQuerySelectionGroups.add(new DataQuerySelectionGroupImpl(selections, dataQuery.getStartPeriod(), dataQuery.getEndPeriod()));
        }
        this.validateQuery();
    }

    private DataQueryImpl(DataStructureBean dataStructureBean, DataflowBean dataflowBean, DATA_QUERY_DETAIL dataQueryDetail) {
        this.dataStructureBean = dataStructureBean;
        this.dataQueryDetail = dataQueryDetail;
        this.dataflowBean = dataflowBean;
        this.validateQuery();
    }

    public static DataQuery buildEmptyQuery(DataStructureBean dataStructureBean, DataflowBean dataflowBean, DATA_QUERY_DETAIL dataQueryDetail) {
        return new DataQueryImpl(dataStructureBean, dataflowBean, dataQueryDetail);
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer firstNObs, Integer lastNObs, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, Set<DataQuerySelection> selections, Date dateFrom, Date dateTo) {
        this.dataStructureBean = dataStructureBean;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        if (ObjectUtil.validCollection(selections) || dateFrom != null || dateTo != null) {
            SdmxDateImpl sdmxDateFrom = null;
            if (dateFrom != null) {
                sdmxDateFrom = new SdmxDateImpl(dateFrom, TIME_FORMAT.DATE);
            }
            SdmxDateImpl sdmxDateTo = null;
            if (dateTo != null) {
                sdmxDateTo = new SdmxDateImpl(dateTo, TIME_FORMAT.DATE);
            }
            this.dataQuerySelectionGroups.add(new DataQuerySelectionGroupImpl(selections, sdmxDateFrom, sdmxDateTo));
        }
        this.dataflowBean = dataflowBean;
        this.lastUpdated = lastUpdated;
        this.dataQueryDetail = dataQueryDetail;
        this.dimensionAtObservation = dimensionAtObservation;
        this.firstNObs = firstNObs;
        this.lastNObs = lastNObs;
        this.validateQuery();
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, Set<DataQuerySelection> selections, Date dateFrom, Date dateTo) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        this.dimensionAtObservation = dimensionAtObservation;
        if (ObjectUtil.validCollection(selections) || dateFrom != null || dateTo != null) {
            SdmxDateImpl sdmxDateFrom = null;
            if (dateFrom != null) {
                sdmxDateFrom = new SdmxDateImpl(dateFrom, TIME_FORMAT.DATE);
            }
            SdmxDateImpl sdmxDateTo = null;
            if (dateTo != null) {
                sdmxDateTo = new SdmxDateImpl(dateTo, TIME_FORMAT.DATE);
            }
            this.dataQuerySelectionGroups.add(new DataQuerySelectionGroupImpl(selections, sdmxDateFrom, sdmxDateTo));
        }
        this.validateQuery();
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, Collection<DataQuerySelectionGroup> selectionGroup) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        this.dimensionAtObservation = dimensionAtObservation;
        if (selectionGroup != null) {
            for (DataQuerySelectionGroup dqsg : selectionGroup) {
                if (dqsg == null) continue;
                this.dataQuerySelectionGroups.add(dqsg);
            }
        }
        this.validateQuery();
    }

    public DataQueryImpl(DataStructureBean dataStructureBean, SdmxDate lastUpdated, DATA_QUERY_DETAIL dataQueryDetail, Integer maxObs, boolean orderAsc, Set<DataProviderBean> dataProviders, DataflowBean dataflowBean, String dimensionAtObservation, DataQuerySelectionGroup ... selectionGroup) {
        this.dataStructureBean = dataStructureBean;
        this.lastUpdated = lastUpdated;
        if (dataQueryDetail != null) {
            this.dataQueryDetail = dataQueryDetail;
        }
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataflowBean = dataflowBean;
        this.dimensionAtObservation = dimensionAtObservation;
        if (selectionGroup != null) {
            for (DataQuerySelectionGroup dqsg : selectionGroup) {
                if (dqsg == null) continue;
                this.dataQuerySelectionGroups.add(dqsg);
            }
        }
        this.validateQuery();
    }

    @Override
    protected Set<String> getQueryComponentIds() {
        HashSet<String> returnSet = new HashSet<String>();
        for (DataQuerySelectionGroup dqsg : this.getSelectionGroups()) {
            for (DataQuerySelection dqs : dqsg.getSelections()) {
                returnSet.add(dqs.getComponentId());
            }
        }
        return returnSet;
    }

    public String dimensionAtObservation() {
        return this.dimensionAtObservation;
    }

    public DataflowBean getDataflow() {
        return this.dataflowBean;
    }

    public Set<DataProviderBean> getDataProvider() {
        return new HashSet<DataProviderBean>(this.dataProviders);
    }

    public boolean hasSelections() {
        return this.dataQuerySelectionGroups.size() > 0;
    }

    public List<DataQuerySelectionGroup> getSelectionGroups() {
        return new ArrayList<DataQuerySelectionGroup>(this.dataQuerySelectionGroups);
    }

    public DataStructureBean getDataStructure() {
        return this.dataStructureBean;
    }

    public DATA_QUERY_DETAIL getDataQueryDetail() {
        return this.dataQueryDetail;
    }

    public SdmxDate getLastUpdatedDate() {
        return this.lastUpdated;
    }

    public Integer getLastNObservations() {
        return this.lastNObs;
    }

    public Integer getFirstNObservations() {
        return this.firstNObs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (this.dataStructureBean != null) {
            sb.append(newLine + "Data Structure : " + this.dataStructureBean.getUrn());
        }
        if (this.dataflowBean != null) {
            sb.append(newLine + "Dataflow : " + this.dataflowBean.getUrn());
        }
        if (this.dataProviders != null) {
            for (DataProviderBean dataProvider : this.dataProviders) {
                sb.append(newLine + "Data Provider  : " + dataProvider.getUrn());
            }
        }
        if (this.hasSelections()) {
            String concat = "";
            for (DataQuerySelectionGroup selectionGroup : this.dataQuerySelectionGroups) {
                sb.append(concat + "(" + selectionGroup.toString() + ")");
                concat = "OR";
            }
        }
        return sb.toString();
    }
}

