/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.springframework.stereotype.Service;

@Service(value="ConceptXmlBeanBuilderV2")
public class ConceptXmlBeanBuilder
extends AbstractBuilder
implements Builder<ConceptType, ConceptBean> {
    public ConceptType build(ConceptBean buildFrom) throws SdmxException {
        ConceptType builtObj = ConceptType.Factory.newInstance();
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations((AnnotableBean)buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType((AnnotableBean)buildFrom));
        }
        if (this.validString(buildFrom.getParentConcept())) {
            builtObj.setParent(buildFrom.getParentConcept());
        }
        if (this.validString(buildFrom.getParentAgency())) {
            builtObj.setParentAgency(buildFrom.getParentAgency());
        }
        if (buildFrom.getCoreRepresentation() != null) {
            if (buildFrom.getCoreRepresentation().getRepresentation() != null) {
                MaintainableRefBean maintRef = buildFrom.getCoreRepresentation().getRepresentation().getMaintainableReference();
                builtObj.setCoreRepresentation(maintRef.getMaintainableId());
                builtObj.setCoreRepresentationAgency(maintRef.getAgencyId());
            }
            if (buildFrom.getCoreRepresentation().getTextFormat() != null) {
                TextFormatType textFormatType = TextFormatType.Factory.newInstance();
                this.populateTextFormatType(textFormatType, buildFrom.getCoreRepresentation().getTextFormat());
                builtObj.setTextFormat(textFormatType);
            }
        }
        return builtObj;
    }
}

