/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.manager.parse.StructureVersionIncrementManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureVersionRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencingRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.structureparser.engine.CrossReferenceReversionEngine;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.VersionableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class StructureVersionIncrementManagerImpl
implements StructureVersionIncrementManager {
    private Logger LOG = Logger.getLogger(StructureVersionIncrementManagerImpl.class);
    @Autowired
    private CrossReferenceReversionEngine crossReferenceReversionEngine;
    @Autowired
    private StructureVersionRetrievalManager structureVersionRetrievalManager;
    private CrossReferencingRetrievalManager crossReferencingRetrievalManager;
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public void incrementVersions(SdmxBeans beans) {
        MaintainableBean updatedMaintainable;
        this.LOG.info((Object)"Update Versions of Structures if existing structures found");
        HashMap<StructureReferenceBean, StructureReferenceBean> oldVsNew = new HashMap<StructureReferenceBean, StructureReferenceBean>();
        HashMap<MaintainableBean, MaintainableBean> oldMaintVsNew = new HashMap<MaintainableBean, MaintainableBean>();
        HashSet<MaintainableBean> updatedMaintainables = new HashSet<MaintainableBean>();
        HashSet<MaintainableBean> oldMaintainables = new HashSet<MaintainableBean>();
        for (MaintainableBean currentMaint : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            Set allIdentifiables2;
            boolean containsAll;
            this.LOG.debug((Object)("Auto Version - check latest version for maintainable: " + currentMaint));
            MaintainableBean persistedMaintainable = this.structureVersionRetrievalManager.getLatest(currentMaint);
            if (persistedMaintainable == null) {
                persistedMaintainable = this.beanRetrievalManager.getMaintainableBean(currentMaint.asReference());
            }
            if (persistedMaintainable == null) continue;
            if (VersionableUtil.isHigherVersion((String)persistedMaintainable.getVersion(), (String)currentMaint.getVersion())) {
                MaintainableMutableBean mutableInstance = currentMaint.getMutableInstance();
                mutableInstance.setVersion(persistedMaintainable.getVersion());
                beans.removeMaintainable(currentMaint);
                currentMaint = mutableInstance.getImmutableInstance();
            }
            if (!persistedMaintainable.getVersion().equals(currentMaint.getVersion())) continue;
            this.LOG.debug((Object)("Latest version is '" + persistedMaintainable.getVersion() + "' perform update checks"));
            if (currentMaint.deepEquals((SDMXBean)persistedMaintainable, true)) continue;
            Set allIdentifiables1 = currentMaint.getIdentifiableComposites();
            boolean bl = containsAll = allIdentifiables1.containsAll(allIdentifiables2 = persistedMaintainable.getIdentifiableComposites()) && allIdentifiables2.containsAll(allIdentifiables1);
            if (this.LOG.isInfoEnabled()) {
                String increment = containsAll ? "Minor" : "Major";
                this.LOG.info((Object)("Perform " + increment + " Version Increment for structure:" + currentMaint.getUrn()));
            }
            MaintainableBean newVersion = this.incrmentVersion(currentMaint, persistedMaintainable.getVersion(), !containsAll);
            beans.removeMaintainable(currentMaint);
            updatedMaintainables.add(newVersion);
            oldMaintainables.add(currentMaint);
            oldMaintVsNew.put(currentMaint, newVersion);
            oldVsNew.put(currentMaint.asReference(), newVersion.asReference());
            String oldVersionNumber = currentMaint.getVersion();
            this.addOldVsNewReferences(oldVersionNumber, newVersion, oldVsNew);
        }
        HashSet<MaintainableBean> filterSet = new HashSet<MaintainableBean>(updatedMaintainables);
        filterSet.addAll(beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]));
        List<MaintainableBean> referencingStructures = this.recurseUpTree(oldMaintainables, new HashSet<MaintainableBean>(), filterSet);
        for (MaintainableBean currentReferencingStructure : referencingStructures) {
            String newVersionNumber;
            this.LOG.info((Object)("Perform Minor Version Increment on referencing structure:" + currentReferencingStructure));
            if (oldMaintVsNew.containsKey(currentReferencingStructure)) {
                currentReferencingStructure = (MaintainableBean)oldMaintVsNew.get(currentReferencingStructure);
                updatedMaintainables.remove(currentReferencingStructure);
                newVersionNumber = currentReferencingStructure.getVersion();
            } else {
                newVersionNumber = VersionableUtil.incrementVersion((String)currentReferencingStructure.getVersion(), (boolean)false);
            }
            MaintainableBean updatedMaintainable2 = this.crossReferenceReversionEngine.udpateReferences(currentReferencingStructure, oldVsNew, newVersionNumber);
            this.addOldVsNewReferences(currentReferencingStructure.getVersion(), updatedMaintainable2, oldVsNew);
            updatedMaintainables.add(updatedMaintainable2);
        }
        for (MaintainableBean currentReferencingStructure : updatedMaintainables) {
            updatedMaintainable = this.crossReferenceReversionEngine.udpateReferences(currentReferencingStructure, oldVsNew, currentReferencingStructure.getVersion());
            beans.addIdentifiable((IdentifiableBean)updatedMaintainable);
        }
        for (MaintainableBean currentReferencingStructure : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            updatedMaintainable = this.crossReferenceReversionEngine.udpateReferences(currentReferencingStructure, oldVsNew, currentReferencingStructure.getVersion());
            beans.addIdentifiable((IdentifiableBean)updatedMaintainable);
        }
    }

    private List<MaintainableBean> recurseUpTree(Collection<MaintainableBean> getParentsFor, Set<MaintainableBean> ignoreParents, Set<MaintainableBean> filterSet) {
        ArrayList<MaintainableBean> crossReferencingStructures = new ArrayList<MaintainableBean>();
        for (MaintainableBean oldBean : getParentsFor) {
            crossReferencingStructures.addAll(this.crossReferencingRetrievalManager.getCrossReferencingStructures(oldBean.asReference(), false, new SDMX_STRUCTURE_TYPE[0]));
        }
        crossReferencingStructures.removeAll(ignoreParents);
        this.filterReferencingStructures(crossReferencingStructures, filterSet);
        ignoreParents.addAll(crossReferencingStructures);
        if (crossReferencingStructures.size() > 0) {
            List<MaintainableBean> ancestors = this.recurseUpTree(crossReferencingStructures, ignoreParents, filterSet);
            for (MaintainableBean currentAncestor : ancestors) {
                if (crossReferencingStructures.contains(currentAncestor)) continue;
                crossReferencingStructures.addAll(ancestors);
            }
        }
        return crossReferencingStructures;
    }

    private void filterReferencingStructures(Collection<MaintainableBean> refereningStructures, Set<MaintainableBean> alreadyReversionedMaintainables) {
        HashSet<MaintainableBean> removeSet = new HashSet<MaintainableBean>();
        for (MaintainableBean currentReference : refereningStructures) {
            for (MaintainableBean alreadyReversionedReference : alreadyReversionedMaintainables) {
                if (currentReference.getStructureType() != alreadyReversionedReference.getStructureType() || !currentReference.getAgencyId().equals(alreadyReversionedReference.getAgencyId()) || !currentReference.getId().equals(alreadyReversionedReference.getId())) continue;
                removeSet.add(currentReference);
            }
        }
        refereningStructures.removeAll(removeSet);
    }

    private void addOldVsNewReferences(String oldVersionNumber, MaintainableBean newVersion, Map<StructureReferenceBean, StructureReferenceBean> oldVsNew) {
        this.addOldVsNewReferencesToMap(oldVersionNumber, (IdentifiableBean)newVersion, oldVsNew);
        for (IdentifiableBean composite : newVersion.getIdentifiableComposites()) {
            this.addOldVsNewReferencesToMap(oldVersionNumber, composite, oldVsNew);
        }
    }

    private void addOldVsNewReferencesToMap(String oldVersionNumber, IdentifiableBean newVersion, Map<StructureReferenceBean, StructureReferenceBean> oldVsNew) {
        StructureReferenceBean asReference = newVersion.asReference();
        MaintainableRefBean mRef = asReference.getMaintainableReference();
        StructureReferenceBeanImpl oldReference = new StructureReferenceBeanImpl(mRef.getAgencyId(), mRef.getMaintainableId(), oldVersionNumber, asReference.getTargetReference(), asReference.getIdentifiableIds());
        oldVsNew.put((StructureReferenceBean)oldReference, asReference);
    }

    private MaintainableBean incrmentVersion(MaintainableBean currentMaint, String incrementFromVersion, boolean majorIncrement) {
        MaintainableMutableBean mutable = currentMaint.getMutableInstance();
        String newVersion = VersionableUtil.incrementVersion((String)incrementFromVersion, (boolean)majorIncrement);
        mutable.setVersion(newVersion);
        MaintainableBean newMaint = mutable.getImmutableInstance();
        return newMaint;
    }

    @Required
    public void setBeanRetrievalManager(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
    }

    @Required
    public void setCrossReferencingRetrievalManager(CrossReferencingRetrievalManager crossReferencingRetrievalManager) {
        this.crossReferencingRetrievalManager = crossReferencingRetrievalManager;
    }
}

