/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LocalizedTextChoiceParameter
extends LeafParameter<LocalizedText> {
    private List<ImmutableLocalizedText> labelChoices;
    private boolean caseSensitive = true;

    private LocalizedTextChoiceParameter() {
    }

    public LocalizedTextChoiceParameter(String identifier, String name, String description, Cardinality cardinality, List<ImmutableLocalizedText> labelChoices) {
        super(identifier, name, description, cardinality);
        this.labelChoices = labelChoices;
    }

    public LocalizedTextChoiceParameter(String identifier, String name, String description, Cardinality cardinality, List<ImmutableLocalizedText> labelChoices, boolean caseSensitive) {
        super(identifier, name, description, cardinality);
        this.labelChoices = labelChoices;
        this.caseSensitive = caseSensitive;
    }

    public List<ImmutableLocalizedText> getLabelChoices() {
        return this.labelChoices;
    }

    @Override
    public Class<LocalizedText> getParameterType() {
        return LocalizedText.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.labelChoices == null ? 0 : this.labelChoices.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalizedTextChoiceParameter other = (LocalizedTextChoiceParameter)obj;
        return !(this.labelChoices == null ? other.labelChoices != null : !this.labelChoices.equals(other.labelChoices));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalizedTextChoiceParameter [labelChoices=");
        builder.append(this.labelChoices);
        builder.append(", caseSensitive=");
        builder.append(this.caseSensitive);
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object valueObj) throws Exception {
        super.validateValue(valueObj);
        LocalizedText value = (LocalizedText)valueObj;
        if (this.caseSensitive) {
            if (!this.labelChoices.contains(value)) {
                throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getLabelChoices()));
            }
        } else {
            boolean ok = false;
            for (LocalizedText localizedText : this.labelChoices) {
                if (!localizedText.getValue().equalsIgnoreCase(value.getValue()) || !localizedText.getLocale().equals(value.getLocale())) continue;
                ok = true;
            }
            if (!ok) {
                throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getLabelChoices()));
            }
        }
    }
}

