/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.Event;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.HttpProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.event.StoreUpdateEvent;
import com.sencha.gxt.data.shared.loader.DataProxy;
import com.sencha.gxt.data.shared.loader.DataReader;
import com.sencha.gxt.data.shared.loader.FilterPagingLoadConfig;
import com.sencha.gxt.data.shared.loader.FilterPagingLoadConfigBean;
import com.sencha.gxt.data.shared.loader.LoadHandler;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.data.shared.loader.Loader;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.data.shared.writer.DataWriter;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.HeaderContextMenuEvent;
import com.sencha.gxt.widget.core.client.event.HeaderMouseDownEvent;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridViewConfig;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.menu.Item;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.menu.SeparatorMenuItem;
import com.sencha.gxt.widget.core.client.selection.CellSelection;
import com.sencha.gxt.widget.core.client.toolbar.PagingToolBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridHeaderColumnMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.GridHeaderColumnMenuItemType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;
import org.gcube.portlets.user.tdwx.client.config.GridAndCellSelectionModel;
import org.gcube.portlets.user.tdwx.client.config.Row;
import org.gcube.portlets.user.tdwx.client.config.TableViewConfig;
import org.gcube.portlets.user.tdwx.client.config.TabularDataGridViewConfig;
import org.gcube.portlets.user.tdwx.client.event.CloseTableEvent;
import org.gcube.portlets.user.tdwx.client.event.GridReadyEvent;
import org.gcube.portlets.user.tdwx.client.event.OpenTableEvent;
import org.gcube.portlets.user.tdwx.client.event.TableReadyEvent;
import org.gcube.portlets.user.tdwx.client.filter.ExtendedGridFilters;
import org.gcube.portlets.user.tdwx.client.filter.FiltersGenerator;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowColumnConfig;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowModelKeyProvider;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowPagingReader;
import org.gcube.portlets.user.tdwx.client.model.util.ColumnConfigGenerator;
import org.gcube.portlets.user.tdwx.client.style.DefaultRowStyle;
import org.gcube.portlets.user.tdwx.client.util.ColumnPositionComparator;
import org.gcube.portlets.user.tdwx.client.util.PagingLoadUrlEncoder;
import org.gcube.portlets.user.tdwx.shared.StaticFilterInformation;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;

public class TabularDataXGridPanel
extends ContentPanel {
    private static final int PAGINGDIMENSION = 300;
    private int tdSessionId;
    private EventBus eventBus;
    private List<MenuItem> headerColumnMenuItems;
    private com.google.web.bindery.event.shared.EventBus externalBus;
    private ListStore<DataRow> store;
    private Grid<DataRow> grid;
    private TableDefinition tableDefinition;
    private VerticalLayoutContainer container;
    private DataRowPagingReader reader;
    private PagingLoader<FilterPagingLoadConfig, PagingLoadResult<DataRow>> loader;
    private ExtendedGridFilters<DataRow> gridFilters;
    private ArrayList<StaticFilterInformation> staticFilters;
    private TableViewConfig tableViewConfig;
    private Menu contextMenu;
    private Map<String, ColumnKey> keys;
    private String visibleOnlyColumn;
    private boolean errorNotColored = false;
    private ColumnModel<DataRow> columnModel;
    private GridAndCellSelectionModel<DataRow> sm;
    private PagingToolBar pagingToolBar;

    protected TabularDataXGridPanel(int tdSessionId, EventBus eventBus) {
        this.tdSessionId = tdSessionId;
        this.eventBus = eventBus;
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setHeaderVisible(false);
        this.forceLayoutOnResize = true;
        this.setResize(true);
        this.bindEventBus();
        this.container = new VerticalLayoutContainer();
        this.container.setBorders(false);
        this.add((Widget)this.container, new MarginData(0));
    }

    public TableViewConfig getTableViewConfig() {
        return this.tableViewConfig;
    }

    public void setTableViewConfig(TableViewConfig tableViewConfig) {
        this.tableViewConfig = tableViewConfig;
    }

    public Grid<DataRow> getGrid() {
        return this.grid;
    }

    public Menu getGridContextMenu() {
        return this.contextMenu;
    }

    public void setGridContextMenu(Menu contextMenu) {
        this.contextMenu = contextMenu;
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public ArrayList<StaticFilterInformation> getStaticFilters() {
        return this.staticFilters;
    }

    public void setStaticFilters(ArrayList<StaticFilterInformation> staticFilters) {
        this.staticFilters = staticFilters;
    }

    public Row getSelectedRow() {
        DataRow dataRow;
        if (this.grid != null && (dataRow = (DataRow)this.grid.getSelectionModel().getSelectedItem()) != null) {
            return new Row(dataRow, this.keys);
        }
        return null;
    }

    public void setSelectionModel(Style.SelectionMode mode) {
        if (this.grid != null && this.grid.getSelectionModel() != null) {
            this.grid.getSelectionModel().setSelectionMode(mode);
        }
    }

    public List<Row> getSelectedRows() {
        if (this.grid != null && this.grid.getSelectionModel() != null) {
            List dataRows = this.grid.getSelectionModel().getSelectedItems();
            ArrayList<Row> rows = new ArrayList<Row>();
            for (DataRow dataRow : dataRows) {
                if (dataRow == null) continue;
                rows.add(new Row(dataRow, this.keys));
            }
            return rows;
        }
        return null;
    }

    public ArrayList<RowRaw> getSelectedRowsAsRaw() {
        if (this.grid != null && this.grid.getSelectionModel() != null) {
            ArrayList<RowRaw> listRowRaw = new ArrayList<RowRaw>();
            List dataRows = this.grid.getSelectionModel().getSelectedItems();
            ArrayList<Row> rows = new ArrayList<Row>();
            for (DataRow dataRow : dataRows) {
                if (dataRow == null) continue;
                rows.add(new Row(dataRow, this.keys));
            }
            for (Row row : rows) {
                HashMap<String, String> map = new HashMap<String, String>();
                ColumnModel columnModel = this.grid.getColumnModel();
                List columns = columnModel.getColumns();
                DataRowColumnConfig columnDataRow = null;
                String rowId = null;
                for (ColumnConfig col : columns) {
                    columnDataRow = (DataRowColumnConfig)col;
                    ColumnDefinition colDef = columnDataRow.getDefinition();
                    if (colDef == null) continue;
                    String value = colDef.getColumnDataType().compareTo("Date") == 0 ? row.getFieldAsDate(colDef.getColumnLocalId()) : row.getFieldAsText(colDef.getColumnLocalId());
                    map.put(colDef.getColumnLocalId(), value);
                    ColumnType ctype = colDef.getType();
                    if (ctype != ColumnType.COLUMNID) continue;
                    rowId = value;
                }
                if (rowId == null || rowId.isEmpty() || map.size() <= 0) continue;
                RowRaw rr = new RowRaw(rowId, map);
                listRowRaw.add(rr);
            }
            return listRowRaw;
        }
        return null;
    }

    public CellData getSelectedCell() {
        if (this.grid != null && this.grid.getSelectionModel() != null) {
            CellSelection cell = ((GridAndCellSelectionModel)this.grid.getSelectionModel()).getCellSelected();
            if (cell != null) {
                DataRow dataRow = (DataRow)cell.getModel();
                Row row = new Row(dataRow, this.keys);
                ColumnModel columnModel = this.grid.getColumnModel();
                List columns = columnModel.getColumns();
                DataRowColumnConfig columnId = null;
                boolean columnIdRetrieved = false;
                for (ColumnConfig col : columns) {
                    columnId = (DataRowColumnConfig)col;
                    ColumnType ctype = columnId.getDefinition().getType();
                    if (ctype != ColumnType.COLUMNID) continue;
                    columnIdRetrieved = true;
                    break;
                }
                if (columnIdRetrieved) {
                    Log.debug((String)"ColumnId Retrieved");
                    ColumnDefinition columnIdSelected = columnId.getDefinition();
                    ColumnConfig colSelected = (ColumnConfig)columns.get(cell.getCell());
                    DataRowColumnConfig cSelected = (DataRowColumnConfig)colSelected;
                    ColumnDefinition cdSelected = cSelected.getDefinition();
                    String cellValue = cdSelected.getColumnDataType().compareTo("Date") == 0 ? row.getFieldAsDate(cdSelected.getColumnLocalId()) : row.getFieldAsText(cdSelected.getColumnLocalId());
                    String columnIdValue = row.getFieldAsText(columnIdSelected.getColumnLocalId());
                    CellData tdCell = new CellData(cellValue, cdSelected.getId(), cdSelected.getColumnLocalId(), cdSelected.getLabel(), columnIdValue, cell.getRow(), cell.getCell());
                    Log.debug((String)("Selected Cell: " + tdCell));
                    return tdCell;
                }
                Log.debug((String)"No ColumnId Retrieved");
                return null;
            }
            Log.debug((String)"No cell selected");
        } else {
            Log.debug((String)"No gridSelectionModel set");
        }
        return null;
    }

    public void setVisibleOnlyColumn(String columnLocalId) {
        Log.debug((String)("setVisibleOnlyColumn: " + columnLocalId));
        this.visibleOnlyColumn = columnLocalId;
    }

    public boolean isErrorNotColored() {
        return this.errorNotColored;
    }

    public void setErrorNotColored(boolean errorNotColored) {
        Log.debug((String)("ErrorNotColored set :" + errorNotColored));
        this.errorNotColored = errorNotColored;
    }

    protected ColumnModel<DataRow> checkOnlyColumn(ColumnModel<DataRow> columnModel) {
        if (this.visibleOnlyColumn != null && !this.visibleOnlyColumn.isEmpty()) {
            Log.debug((String)"setVisibleOnlyColumn: Grid not null");
            List columns = columnModel.getColumns();
            ArrayList<DataRowColumnConfig> columnsNew = new ArrayList<DataRowColumnConfig>();
            DataRowColumnConfig columnTarget = null;
            for (ColumnConfig col : columns) {
                columnTarget = (DataRowColumnConfig)col;
                String columnLocal = columnTarget.getDefinition().getColumnLocalId();
                if (this.visibleOnlyColumn.compareTo(columnLocal) == 0) {
                    columnTarget.setHidden(false);
                    columnsNew.add(columnTarget);
                    continue;
                }
                columnTarget.setHidden(true);
                columnsNew.add(columnTarget);
            }
            columnModel = new ColumnModel(columnsNew);
        } else {
            Log.debug((String)"visibleOnlyColumn null");
        }
        return columnModel;
    }

    public ArrayList<String> getCellValue(String columnLocalId) {
        ArrayList<String> value = null;
        if (this.grid != null) {
            ColumnModel columnModel = this.grid.getColumnModel();
            List columns = columnModel.getColumns();
            DataRowColumnConfig columnTarget = null;
            boolean columnTargetRetrieved = false;
            for (ColumnConfig col : columns) {
                columnTarget = (DataRowColumnConfig)col;
                String columnLocal = columnTarget.getDefinition().getColumnLocalId();
                if (columnLocalId.compareTo(columnLocal) != 0) continue;
                columnTargetRetrieved = true;
                break;
            }
            if (columnTargetRetrieved) {
                ColumnDefinition cd = columnTarget.getDefinition();
                Log.debug((String)("CD - Definition:" + cd.getId() + " ColumnLocalId:" + cd.getColumnLocalId() + " Label:" + cd.getLabel() + " Key:" + cd.getKey()));
                List<Row> rowsSelected = this.getSelectedRows();
                Log.debug((String)"Retriving rows selected");
                String rowS = "";
                ArrayList<String> rows = new ArrayList<String>();
                if (rowsSelected != null) {
                    for (Row row : rowsSelected) {
                        rowS = row.getFieldAsText(cd.getColumnLocalId());
                        Log.debug((String)("Selected Row:" + rowS));
                        rows.add(rowS);
                    }
                } else {
                    Log.debug((String)"no selected rows retrieved");
                }
                return rows;
            }
            Log.debug((String)"no column target retrieved");
        }
        return value;
    }

    public ArrayList<String> getSelectedRowsId() {
        if (this.grid != null) {
            ColumnModel columnModel = this.grid.getColumnModel();
            List columns = columnModel.getColumns();
            DataRowColumnConfig c = null;
            boolean columnIdRetrieved = false;
            for (ColumnConfig col : columns) {
                c = (DataRowColumnConfig)col;
                ColumnType ctype = c.getDefinition().getType();
                if (ctype != ColumnType.COLUMNID) continue;
                columnIdRetrieved = true;
                break;
            }
            if (columnIdRetrieved) {
                ColumnDefinition cd = c.getDefinition();
                Log.debug((String)("CD - Definition:" + cd.getId() + " ColumnLocalId:" + cd.getColumnLocalId() + " Label:" + cd.getLabel() + " Key:" + cd.getKey()));
                List<Row> rowsSelected = this.getSelectedRows();
                Log.debug((String)"Retriving rows selected");
                String rowS = "";
                ArrayList<String> rows = new ArrayList<String>();
                if (rowsSelected != null) {
                    for (Row row : rowsSelected) {
                        rowS = row.getFieldAsText(cd.getColumnLocalId());
                        Log.debug((String)("Selected Row:" + rowS));
                        rows.add(rowS);
                    }
                } else {
                    Log.debug((String)"no selected rows retrieved");
                }
                return rows;
            }
            Log.debug((String)"no COLUMNID retrieved");
            return null;
        }
        return null;
    }

    protected void bindEventBus() {
        this.eventBus.addHandler(OpenTableEvent.TYPE, (EventHandler)new OpenTableEvent.OpenTableEventHandler(){

            @Override
            public void onOpenTable(OpenTableEvent event) {
                TabularDataXGridPanel.this.doOpenTable();
            }
        });
        this.eventBus.addHandler(TableReadyEvent.TYPE, (EventHandler)new TableReadyEvent.TableReadyEventHandler(){

            @Override
            public void onTableReady(TableReadyEvent event) {
                TabularDataXGridPanel.this.doTableReady(event.getTableDefinition());
            }
        });
        this.eventBus.addHandler(CloseTableEvent.TYPE, (EventHandler)new CloseTableEvent.CloseTableEventHandler(){

            @Override
            public void onCloseTable(CloseTableEvent event) {
                TabularDataXGridPanel.this.doCloseTable();
            }
        });
    }

    protected void doOpenTable() {
        this.mask();
    }

    protected void doTableReady(TableDefinition definition) {
        Log.trace((String)"table ready, setting grid up");
        this.mask("Loading table " + definition.getName() + "... ");
        this.setupGrid(definition);
        this.keys = new HashMap<String, ColumnKey>();
        for (ColumnDefinition column : definition.getColumnsAsList()) {
            this.keys.put(column.getColumnLocalId(), column.getKey());
        }
        this.unmask();
    }

    protected void doCloseTable() {
        this.mask();
        this.grid = null;
        this.keys.clear();
        this.container.clear();
        this.unmask();
    }

    protected void addHeaderMouseDownHandler(HeaderMouseDownEvent.HeaderMouseDownHandler handler) {
        if (this.grid != null) {
            if (handler == null) {
                handler = new HeaderMouseDownEvent.HeaderMouseDownHandler(){

                    public void onHeaderMouseDown(HeaderMouseDownEvent event) {
                        Log.debug((String)("HeaderMouseDownEvent :" + event.toDebugString()));
                        if (event.getEvent().getButton() == 2) {
                            event.getEvent().stopPropagation();
                        }
                    }
                };
            }
            this.grid.addHeaderMouseDownHandler(handler);
        }
    }

    protected void setupGrid(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
        ColumnDefinition modelKeyColumn = tableDefinition.getModelKeyColumn();
        this.store = new ListStore((ModelKeyProvider)new DataRowModelKeyProvider(modelKeyColumn.getKey()));
        this.store.addStoreUpdateHandler((StoreUpdateEvent.StoreUpdateHandler)new StoreUpdateEvent.StoreUpdateHandler<DataRow>(){

            public void onUpdate(StoreUpdateEvent<DataRow> event) {
                Log.debug((String)"UPDATE ROWS");
                Log.debug((String)event.getItems().toString());
            }
        });
        ArrayList columnsConfig = new ArrayList();
        List<ColumnDefinition> columns = tableDefinition.getColumnsAsList();
        Collections.sort(columns, new ColumnPositionComparator(false));
        for (ColumnDefinition columnDefinition : columns) {
            if (columnDefinition.getType() == ColumnType.SYSTEM) continue;
            columnsConfig.add(ColumnConfigGenerator.generateConfiguration(columnDefinition));
        }
        this.columnModel = new ColumnModel(columnsConfig);
        this.columnModel = this.checkOnlyColumn(this.columnModel);
        if (this.grid == null) {
            Log.debug((String)"Setup reader");
            this.reader = new DataRowPagingReader(tableDefinition);
            String path = String.valueOf(GWT.getModuleBaseURL()) + "tdwxdata";
            RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, path);
            builder.setHeader("tdSessionId", String.valueOf(this.tdSessionId));
            HttpProxy proxy = new HttpProxy(builder);
            proxy.setWriter((DataWriter)new PagingLoadUrlEncoder(this.staticFilters));
            this.loader = new PagingLoader<FilterPagingLoadConfig, PagingLoadResult<DataRow>>((DataProxy)proxy, (DataReader)this.reader){

                protected FilterPagingLoadConfig newLoadConfig() {
                    return new FilterPagingLoadConfigBean();
                }
            };
            this.loader.setRemoteSort(true);
            this.loader.addLoadHandler((LoadHandler)new LoadResultListStoreBinding(this.store));
            this.pagingToolBar = new PagingToolBar(300);
            this.pagingToolBar.getElement().getStyle().setProperty("borderBottom", "none");
            this.pagingToolBar.bind(this.loader);
            this.grid = new Grid<DataRow>(this.store, this.columnModel){

                protected void onAfterFirstAttach() {
                    super.onAfterFirstAttach();
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            TabularDataXGridPanel.this.loader.load();
                        }
                    });
                }
            };
            this.sm = new GridAndCellSelectionModel();
            this.grid.setSelectionModel(this.sm);
            this.grid.setLoadMask(true);
            this.grid.setLoader(this.loader);
            this.grid.setBorders(false);
            this.grid.setColumnReordering(false);
            ArrayList<Filter<DataRow, ?>> filters = FiltersGenerator.generate(this.columnModel);
            this.gridFilters = new ExtendedGridFilters((Loader<FilterPagingLoadConfig, ?>)this.loader);
            this.gridFilters.initPlugin(this.grid);
            this.gridFilters.setLocal(false);
            Log.debug((String)("Filters: " + filters.size()));
            for (Filter<DataRow, ?> filterGeneric : filters) {
                this.gridFilters.addFilter(filterGeneric);
            }
            this.container.add(this.grid, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
            this.container.add((IsWidget)this.pagingToolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0));
            if (this.contextMenu != null) {
                this.grid.setContextMenu(this.contextMenu);
            } else {
                this.grid.setContextMenu(null);
            }
            if (this.headerColumnMenuItems != null) {
                this.setHeaderContextMenuHandler();
            }
        } else {
            Log.debug((String)"Setup grid not null");
            this.reader.setDefinition(tableDefinition);
            this.loader.clearSortInfo();
            this.loader.addLoadHandler((LoadHandler)new LoadResultListStoreBinding(this.store));
            this.grid.reconfigure(this.store, this.columnModel);
            ArrayList<Filter<DataRow, ?>> filters = FiltersGenerator.generate(this.columnModel);
            Log.debug((String)("Filters: " + filters.size()));
            for (Filter<DataRow, ?> filterGeneric : filters) {
                this.gridFilters.addFilter(filterGeneric);
            }
            this.loader.load();
        }
        if (this.tableViewConfig != null) {
            Log.debug((String)"Use specific grid View");
            if (this.tableViewConfig.getRowStyleProvider() != null) {
                this.grid.getView().setViewConfig((GridViewConfig)new TabularDataGridViewConfig(this.tableViewConfig, tableDefinition));
            }
        } else {
            Log.debug((String)"Use default grid View");
            this.tableViewConfig = new TableViewConfig();
            Log.debug((String)("Error Not Colored: " + this.errorNotColored));
            DefaultRowStyle rowStyle = new DefaultRowStyle(this.errorNotColored);
            this.tableViewConfig.setRowStyleProvider(rowStyle);
            this.grid.getView().setViewConfig((GridViewConfig)new TabularDataGridViewConfig(this.tableViewConfig, tableDefinition));
        }
        this.container.forceLayout();
        this.eventBus.fireEvent((GwtEvent)new GridReadyEvent());
    }

    public void addGridHeaderContextMenuItems(List<MenuItem> items, com.google.web.bindery.event.shared.EventBus externalBus) {
        this.headerColumnMenuItems = items;
        this.externalBus = externalBus;
    }

    protected void setHeaderContextMenuHandler() {
        HeaderContextMenuEvent.HeaderContextMenuHandler headerContextMenuHandler = new HeaderContextMenuEvent.HeaderContextMenuHandler(){

            public void onHeaderContextMenu(HeaderContextMenuEvent event) {
                Log.debug((String)"Header Menu");
                final Menu menu = event.getMenu();
                final int colIndex = event.getColumnIndex();
                SelectionHandler<Item> handlerHeaderContextMenu = new SelectionHandler<Item>(){

                    public void onSelection(SelectionEvent<Item> event) {
                        Log.debug((String)("Selected: " + ((Item)event.getSelectedItem()).getId()));
                        if (event.getSelectedItem() instanceof MenuItem) {
                            Log.debug((String)"Event instanceof MenuItem");
                            MenuItem menuItem = (MenuItem)event.getSelectedItem();
                            if (TabularDataXGridPanel.this.headerColumnMenuItems.contains(menuItem)) {
                                Log.debug((String)"Event Fire on EventBus");
                                TabularDataXGridPanel.this.externalBus.fireEvent((Event)new GridHeaderColumnMenuItemEvent(GridHeaderColumnMenuItemType.SELECTED, menuItem.getId(), colIndex));
                                menu.hide();
                            }
                        }
                    }
                };
                menu.addSelectionHandler((SelectionHandler)handlerHeaderContextMenu);
                Log.debug((String)"Adding Items to menu");
                SeparatorMenuItem separatorItem = new SeparatorMenuItem();
                menu.add((Widget)separatorItem);
                for (MenuItem m : TabularDataXGridPanel.this.headerColumnMenuItems) {
                    menu.add((Widget)m);
                }
                menu.show();
            }
        };
        Log.debug((String)"Created Handler");
        this.grid.addHeaderContextMenuHandler(headerContextMenuHandler);
        Log.debug((String)"Header Column Menu Added");
    }

    public String getColumnName(int i) {
        Log.debug((String)("Retrive Column Id of column:" + i));
        String columnName = null;
        if (this.grid != null) {
            ColumnModel columnModel = this.grid.getColumnModel();
            List columns = columnModel.getColumns();
            DataRowColumnConfig dc = (DataRowColumnConfig)((Object)columns.get(i));
            columnName = dc.getDefinition().getId();
            Log.debug((String)("Column - Definition: Id: " + columnName));
        }
        return columnName;
    }

    public String getColumnLocalId(int i) {
        Log.debug((String)("Retrive Column Local Id of column:" + i));
        String columnLocalId = null;
        if (this.grid != null) {
            ColumnModel columnModel = this.grid.getColumnModel();
            List columns = columnModel.getColumns();
            DataRowColumnConfig dc = (DataRowColumnConfig)((Object)columns.get(i));
            columnLocalId = dc.getDefinition().getColumnLocalId();
            Log.debug((String)("Column - Definition: Column Local Id: " + columnLocalId));
        }
        return columnLocalId;
    }
}

