/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.filter;

import com.allen_sauer.gwt.log.client.Log;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.filters.DateFilter;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.grid.filters.NumericFilter;
import java.util.ArrayList;
import org.gcube.portlets.user.tdwx.client.filter.ExtendedBooleanFilter;
import org.gcube.portlets.user.tdwx.client.filter.text.TextFilter;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowColumnConfig;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;

public class FiltersGenerator {
    public static ArrayList<Filter<DataRow, ?>> generate(ColumnModel<DataRow> columnModel) {
        ArrayList filters = new ArrayList();
        for (ColumnConfig columnConfig : columnModel.getColumns()) {
            DataRowColumnConfig dataRowColConfig = (DataRowColumnConfig)columnConfig;
            if (dataRowColConfig != null) {
                if (dataRowColConfig.getDefinition() != null && dataRowColConfig.getDefinition().getValueType() != null) {
                    ValueType vt = dataRowColConfig.getDefinition().getValueType();
                    switch (vt) {
                        case BOOLEAN: {
                            ExtendedBooleanFilter bFilt = new ExtendedBooleanFilter(dataRowColConfig.getValueProvider());
                            filters.add(bFilt);
                            break;
                        }
                        case DATE: {
                            DateFilter dateFilt = new DateFilter(dataRowColConfig.getValueProvider());
                            filters.add((Filter<DataRow, ?>)dateFilt);
                            break;
                        }
                        case DOUBLE: {
                            NumericFilter doubleFilt = new NumericFilter(dataRowColConfig.getValueProvider(), (NumberPropertyEditor)new NumberPropertyEditor.DoublePropertyEditor());
                            filters.add((Filter<DataRow, ?>)doubleFilt);
                            break;
                        }
                        case INTEGER: {
                            NumericFilter integerFilt = new NumericFilter(dataRowColConfig.getValueProvider(), (NumberPropertyEditor)new NumberPropertyEditor.IntegerPropertyEditor());
                            filters.add((Filter<DataRow, ?>)integerFilt);
                            break;
                        }
                        case LONG: {
                            NumericFilter longFilt = new NumericFilter(dataRowColConfig.getValueProvider(), (NumberPropertyEditor)new NumberPropertyEditor.LongPropertyEditor());
                            filters.add((Filter<DataRow, ?>)longFilt);
                            break;
                        }
                        case STRING: {
                            TextFilter stringFilt = new TextFilter(dataRowColConfig.getValueProvider());
                            filters.add(stringFilt);
                        }
                        case GEOMETRY: {
                            break;
                        }
                    }
                    continue;
                }
                Log.debug((String)"DataRowColConfig: ValueType NULL");
                continue;
            }
            Log.debug((String)"DataRowColConfig: NULL");
        }
        return filters;
    }
}

