/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.factory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.sdmxsource.sdmx.api.factory.ReadableDataLocationFactory;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.util.io.FileUtil;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.io.URIUtil;
import org.sdmxsource.util.io.URLUtil;

public class SdmxSourceReadableDataLocationFactory
implements ReadableDataLocationFactory {
    private Long maxMemory = 0x1E00000L;
    private Long memoryUseage = 0L;

    public ReadableDataLocation getReadableDataLocation(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        try {
            URI uri = new URI(uriStr);
            if (uri.isAbsolute() && !uri.getScheme().equals("file")) {
                URL url = uri.toURL();
                InputStream is = URLUtil.getInputStream(url);
                return this.getReadableDataLocation(is);
            }
            return new OverflowReadableDataLocation(uri, false);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocation getReadableDataLocation(byte[] bytes) {
        return new OverflowReadableDataLocation(bytes);
    }

    public ReadableDataLocation getReadableDataLocation(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - file can not be null");
        }
        if (FileUtil.getFileSize(file) > this.maxMemory - this.memoryUseage) {
            return new OverflowReadableDataLocation(file.toURI(), false);
        }
        try {
            return this.getReadableDataLocation(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocation getReadableDataLocation(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - url can not be null");
        }
        try {
            return this.getReadableDataLocation(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not connect to URL: " + url, e);
        }
    }

    public ReadableDataLocation getReadableDataLocation(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uri can not be null");
        }
        return this.getReadableDataLocation(URIUtil.getInputStream(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableDataLocation getReadableDataLocation(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        boolean completedRead = false;
        if (this.memoryUseage < this.maxMemory) {
            completedRead = true;
            try {
                int i;
                byte[] bytes = new byte[1024];
                while ((i = is.read(bytes)) > 0) {
                    bos.write(bytes, 0, i);
                    this.memoryUseage = this.memoryUseage + (long)i;
                    if (this.memoryUseage <= this.maxMemory) continue;
                    completedRead = false;
                    break;
                }
                bos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (completedRead) {
            StreamUtil.closeStream(is);
            return new OverflowReadableDataLocation(out.toByteArray());
        }
        URI uri = URIUtil.getTemporaryURI();
        OutputStream tmpOut = URIUtil.getOutputStream(uri);
        bos = new BufferedOutputStream(tmpOut);
        if (out.size() > 0) {
            StreamUtil.copyStream(new ByteArrayInputStream(out.toByteArray()), bos, false);
            this.memoryUseage = this.memoryUseage - (long)out.size();
            out = null;
        }
        try {
            StreamUtil.copyStream(is, bos, false);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(is);
            StreamUtil.closeStream(bos);
            throw throwable;
        }
        StreamUtil.closeStream(is);
        StreamUtil.closeStream(bos);
        return new OverflowReadableDataLocation(uri, true);
    }

    public Long getMemoryUseageBytes() {
        return this.memoryUseage;
    }

    public void setMaxMemoryKb(int maxMemory) {
        this.maxMemory = Long.valueOf(maxMemory) * 1024L;
    }

    class OverflowReadableDataLocation
    implements ReadableDataLocation {
        private static final long serialVersionUID = -8299140445772552916L;
        private byte[] bytes;
        private URI uri;
        private boolean deleteOnClose;
        private String name;

        private OverflowReadableDataLocation(byte[] bytes) {
            this.bytes = bytes;
        }

        private OverflowReadableDataLocation(URI uri, boolean deleteOnClose) {
            this.uri = uri;
            this.deleteOnClose = deleteOnClose;
        }

        public InputStream getInputStream() {
            if (this.bytes != null) {
                return new BufferedInputStream(new ByteArrayInputStream(this.bytes));
            }
            return URIUtil.getInputStream(this.uri);
        }

        public String getName() {
            return this.name;
        }

        public void close() {
            if (this.bytes != null) {
                SdmxSourceReadableDataLocationFactory.this.memoryUseage = SdmxSourceReadableDataLocationFactory.this.memoryUseage - (long)this.bytes.length;
                this.bytes = null;
            } else if (this.uri != null) {
                URIUtil.closeUri(this.uri);
                if (this.deleteOnClose) {
                    URIUtil.deleteUri(this.uri);
                }
            }
        }
    }
}

