/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.TemplateColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.AggregationPair;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.TemplateActionColumnReference;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.model.ValueFormat;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TimeAggregationAction
extends TemplateAction<Long>
implements TemplateColumnAction {
    private static final long serialVersionUID = 5255728286366763755L;
    private static final long TIMEAGGREGATION_OP_ID = 3009L;
    private static final String FUNCTION_PARAMETER_ID = "functionParameter";
    private static final String TO_AGGREGATE_COLUMN_ID = "functionMember";
    private static final String COMPOSITE_AGGREGATION_ID = "aggregationFunctions";
    private static final String GROUP_COLUMN_PARAMETER_ID = "keyColumns";
    private static final String PERIOD_AGGREGGATION_PARAMETER_ID = "timeDimensionAggr";
    private TemplateColumn<?> column;
    private PeriodType periodType;
    private List<AggregationPair> aggregationPairs = Collections.emptyList();
    private List<TemplateColumn<?>> groupColumns = Collections.emptyList();

    private TimeAggregationAction() {
    }

    public TimeAggregationAction(TemplateColumn<?> column, PeriodType periodType, List<TemplateColumn<?>> groupColumns, AggregationPair ... aggregationPairs) {
        this.column = column;
        if (!column.getColumnType().equals((Object)ColumnCategory.TIMEDIMENSION)) {
            throw new IllegalArgumentException("timeAggregationAction is apllicable only to TimeDimension columns");
        }
        if (groupColumns == null || groupColumns.isEmpty()) {
            throw new IllegalArgumentException("at least one column for grouping has to be selected");
        }
        PeriodType columnPeriod = ((TimeDimensionReference)column.getReference()).getPeriod();
        if (!((List)PeriodType.getHierarchicalRelation().get(columnPeriod)).contains(periodType)) {
            throw new IllegalArgumentException(String.format("%s period type cannot be aggregated for %s", columnPeriod, periodType));
        }
        this.periodType = periodType;
        if (aggregationPairs != null && aggregationPairs.length > 0) {
            this.aggregationPairs = Arrays.asList(aggregationPairs);
        }
        this.groupColumns = groupColumns;
    }

    @Override
    public boolean usesExpression() {
        return false;
    }

    @Override
    public Long getIdentifier() {
        return 3009L;
    }

    @Override
    public String getColumnId() {
        return this.column.getId();
    }

    @Override
    public Map<String, Object> getParameters() {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (!this.aggregationPairs.isEmpty()) {
                ArrayList compositeList = new ArrayList();
                for (AggregationPair aggregationPair : this.aggregationPairs) {
                    HashMap<String, Object> composite = new HashMap<String, Object>();
                    composite.put(FUNCTION_PARAMETER_ID, new ImmutableLocalizedText(aggregationPair.getFunction().name()));
                    composite.put(TO_AGGREGATE_COLUMN_ID, new TemplateActionColumnReference(aggregationPair.getColumn().getId()));
                    compositeList.add(composite);
                }
                parameters.put(COMPOSITE_AGGREGATION_ID, compositeList);
            }
            ArrayList<TemplateActionColumnReference> groupColumnReference = new ArrayList<TemplateActionColumnReference>();
            for (TemplateColumn templateColumn : this.groupColumns) {
                groupColumnReference.add(new TemplateActionColumnReference(templateColumn.getId()));
            }
            parameters.put(GROUP_COLUMN_PARAMETER_ID, groupColumnReference);
            parameters.put(PERIOD_AGGREGGATION_PARAMETER_ID, this.periodType.name());
            return parameters;
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public TemplateColumn<?> getColumn() {
        return this.column;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public List<AggregationPair> getAggregationPairs() {
        return this.aggregationPairs;
    }

    public List<TemplateColumn<?>> getGroupColumns() {
        return this.groupColumns;
    }

    @Override
    public List<TemplateColumn<?>> getPostOperationStructure(List<TemplateColumn<?>> columns) {
        ArrayList newStructureColumn = new ArrayList();
        for (TemplateColumn<?> templateColumn : columns) {
            if (templateColumn.equals(this.column)) {
                TemplateColumn<IntegerType> col = new TemplateColumn<IntegerType>(ColumnCategory.TIMEDIMENSION, IntegerType.class, new TimeDimensionReference(this.periodType, ((ValueFormat)this.periodType.getAcceptedFormats().get(0)).getId()));
                col.setId(templateColumn.getId());
                newStructureColumn.add(col);
                continue;
            }
            if (!this.groupColumns.contains(templateColumn) && !this.aggregationPairs.contains(templateColumn)) continue;
            newStructureColumn.add(templateColumn);
        }
        return newStructureColumn;
    }
}

