/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import java.util.HashMap;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.conceptscheme.ConceptSchemeSuperBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemorySdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConceptSchemeSuperBeanBuilder
extends StructureBuilderImpl<ConceptSchemeSuperBean, ConceptSchemeBean> {
    @Autowired
    private CodelistSuperBeanBuilder codelistSuperBeanBuilder;

    public ConceptSchemeSuperBean build(ConceptSchemeBean buildFrom, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        HashMap<ConceptBean, CodelistSuperBean> codelistMap = new HashMap<ConceptBean, CodelistSuperBean>();
        for (ConceptBean conceptBean : buildFrom.getItems()) {
            if (conceptBean.getCoreRepresentation() == null || conceptBean.getCoreRepresentation().getRepresentation() == null) continue;
            MaintainableRefBean codelistRef = conceptBean.getCoreRepresentation().getRepresentation().getMaintainableReference();
            CodelistSuperBean codelistSuperBean = superBeanRetrievalManager.getCodelistSuperBean(codelistRef);
            if (codelistSuperBean == null) {
                CodelistBean codelist = (CodelistBean)retrievalManager.getMaintainableBean(CodelistBean.class, codelistRef);
                codelistSuperBean = this.codelistSuperBeanBuilder.build(codelist);
                existingBeans.addCodelist(codelistSuperBean);
                if (codelistSuperBean == null) {
                    throw new CrossReferenceException(conceptBean.getCoreRepresentation().getRepresentation());
                }
            }
            codelistMap.put(conceptBean, codelistSuperBean);
        }
        return new ConceptSchemeSuperBeanImpl(buildFrom, codelistMap);
    }

    public void setCodelistSuperBeanBuilder(CodelistSuperBeanBuilder codelistSuperBeanBuilder) {
        this.codelistSuperBeanBuilder = codelistSuperBeanBuilder;
    }
}

