/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.gcube.portlets.user.tdwx.client.event.CloseTableEvent;
import org.gcube.portlets.user.tdwx.client.event.ColumnsReorderingEvent;
import org.gcube.portlets.user.tdwx.client.event.FailureEvent;
import org.gcube.portlets.user.tdwx.client.event.OpenTableEvent;
import org.gcube.portlets.user.tdwx.client.event.TableReadyEvent;
import org.gcube.portlets.user.tdwx.client.rpc.TabularDataXService;
import org.gcube.portlets.user.tdwx.client.rpc.TabularDataXServiceAsync;
import org.gcube.portlets.user.tdwx.shared.ColumnsReorderingConfig;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableId;

public class TabularDataXController {
    private int tdSessionId;
    private EventBus eventBus;
    private TabularDataXServiceAsync service;
    private TableDefinition currentTable;

    protected TabularDataXController(int tdSessionId, EventBus eventBus) {
        this.tdSessionId = tdSessionId;
        this.eventBus = eventBus;
        this.service = (TabularDataXServiceAsync)GWT.create(TabularDataXService.class);
        this.bindEventBus();
    }

    protected void bindEventBus() {
        this.eventBus.addHandler(OpenTableEvent.TYPE, (EventHandler)new OpenTableEvent.OpenTableEventHandler(){

            @Override
            public void onOpenTable(OpenTableEvent event) {
                TabularDataXController.this.doOpenTable(event.getTableId());
            }
        });
        this.eventBus.addHandler(CloseTableEvent.TYPE, (EventHandler)new CloseTableEvent.CloseTableEventHandler(){

            @Override
            public void onCloseTable(CloseTableEvent event) {
                TabularDataXController.this.doCloseTable();
            }
        });
        this.eventBus.addHandler(ColumnsReorderingEvent.TYPE, (EventHandler)new ColumnsReorderingEvent.ColumnsReorderingEventHandler(){

            @Override
            public void onColumnsReordering(ColumnsReorderingEvent event) {
                TabularDataXController.this.doSetCurrentTableColumnsReordering(event);
            }
        });
    }

    protected void doCloseTable() {
        this.service.closeTable(this.tdSessionId, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                TabularDataXController.this.eventBus.fireEvent((GwtEvent)new FailureEvent(caught, "Table closing failed."));
            }

            public void onSuccess(Void result) {
                Log.trace((String)"table closed");
                TabularDataXController.this.currentTable = null;
            }
        });
    }

    protected void doOpenTable(TableId tableId) {
        this.service.openTable(this.tdSessionId, tableId, new AsyncCallback<TableDefinition>(){

            public void onFailure(Throwable caught) {
                TabularDataXController.this.eventBus.fireEvent((GwtEvent)new FailureEvent(caught, "Tabledefinition loading failed."));
            }

            public void onSuccess(TableDefinition result) {
                Log.trace((String)("table definition: " + result));
                TabularDataXController.this.currentTable = result;
                TabularDataXController.this.eventBus.fireEvent((GwtEvent)new TableReadyEvent(result));
            }
        });
    }

    protected void doSetCurrentTableColumnsReordering(ColumnsReorderingEvent event) {
        ColumnsReorderingConfig columnReorderingConfig = event.getColumnsReorderingConfig();
        this.service.setCurrentTableColumnsReordering(this.tdSessionId, columnReorderingConfig, new AsyncCallback<TableDefinition>(){

            public void onFailure(Throwable caught) {
                TabularDataXController.this.eventBus.fireEvent((GwtEvent)new FailureEvent(caught, "Column Reordering failed."));
            }

            public void onSuccess(TableDefinition result) {
                Log.trace((String)("table definition: " + result));
                TabularDataXController.this.currentTable = result;
                TabularDataXController.this.eventBus.fireEvent((GwtEvent)new TableReadyEvent(result));
            }
        });
    }

    protected TableDefinition getCurrentTable() {
        return this.currentTable;
    }

    protected void getTableDefinition(TableId tableId, AsyncCallback<TableDefinition> callback) {
        this.service.getTableDefinition(tableId, callback);
    }
}

