/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.config;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.widget.core.client.event.LiveGridViewUpdateEvent;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.LiveToolItem;
import com.sencha.gxt.widget.core.client.selection.SelectionChangedEvent;
import java.util.List;
import org.gcube.portlets.user.tdwx.client.config.ExtendedLiveGridView;

public class TDXLiveToolItem
extends LiveToolItem {
    private HandlerRegistration handlerRegistration;
    private TDXLiveToolItemMessages messages;
    private List<?> lastSelected;

    public TDXLiveToolItem(Grid<?> grid) {
        super(grid);
    }

    public TDXLiveToolItemMessages getMessages() {
        if (this.messages == null) {
            this.messages = new DefaultTDXLiveToolItemMessages();
        }
        return this.messages;
    }

    public void setMessages(TDXLiveToolItemMessages messages) {
        this.messages = messages;
    }

    protected void onUpdate(LiveGridViewUpdateEvent be) {
        int totalCount;
        int viewIndex;
        int pageSize = be.getRowCount();
        int i = pageSize + (viewIndex = be.getViewIndex());
        if (i > (totalCount = be.getTotalCount())) {
            i = totalCount;
        }
        this.setLabel(this.getMessages().displayMessage(totalCount == 0 ? 0 : viewIndex + 1, i, totalCount));
    }

    public void setNoSelected() {
        this.setLabel(this.getMessages().displayNoSelectedMessage());
    }

    public void bindGrid(Grid<?> grid) {
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
        if (grid != null) {
            ExtendedLiveGridView view = (ExtendedLiveGridView)grid.getView();
            view.addLiveGridViewUpdateHandler(new LiveGridViewUpdateEvent.LiveGridViewUpdateHandler(){

                public void onUpdate(LiveGridViewUpdateEvent event) {
                    ExtendedLiveGridView source = (ExtendedLiveGridView)((Object)event.getSource());
                    Log.debug((String)("CacheStore List Items: " + source.getCacheSize()));
                    TDXLiveToolItem.this.onUpdate(event);
                }
            });
            GridSelectionModel selectionModel = grid.getSelectionModel();
            selectionModel.addSelectionChangedHandler(new SelectionChangedEvent.SelectionChangedHandler(){

                public void onSelectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() != null) {
                        Log.debug((String)("Selected List Items: " + event.getSelection().size()));
                        TDXLiveToolItem.this.lastSelected = event.getSelection();
                        TDXLiveToolItem.this.setLabel(TDXLiveToolItem.this.getMessages().displayMessage(TDXLiveToolItem.this.lastSelected.size()));
                    } else {
                        TDXLiveToolItem.this.lastSelected = null;
                        TDXLiveToolItem.this.setLabel(TDXLiveToolItem.this.getMessages().displayMessage(0));
                    }
                }
            });
        }
    }

    protected static class DefaultTDXLiveToolItemMessages
    implements TDXLiveToolItemMessages {
        private int end;
        private int start;
        private int total;
        private int totalSelected;

        protected DefaultTDXLiveToolItemMessages() {
        }

        @Override
        public String displayMessage(int totalSelected) {
            this.totalSelected = totalSelected;
            return this.buildMessage();
        }

        public String displayMessage(int start, int end, int total) {
            this.start = start;
            this.end = end;
            this.total = total;
            return this.buildMessage();
        }

        protected String buildMessage() {
            String msg = "";
            msg = this.totalSelected > 0 ? (this.totalSelected > 1 ? new String("<span>Displaying " + this.start + " - " + this.end + " of " + this.total + "</span><span style='margin-left:10px;color:red;'>[ " + this.totalSelected + " rows selected ]</span>") : new String("<span>Displaying " + this.start + " - " + this.end + " of " + this.total + "</span><span style='margin-left:10px;color:red;'>[ " + this.totalSelected + " row selected ]</span>")) : new String("<span>Displaying " + this.start + " - " + this.end + " of " + this.total + "</span>");
            return msg;
        }

        @Override
        public String displayNoSelectedMessage() {
            this.totalSelected = 0;
            String msg = new String("<span>Displaying " + this.start + " - " + this.end + " of " + this.total + "</span>");
            return msg;
        }
    }

    public static interface TDXLiveToolItemMessages
    extends LiveToolItem.LiveToolItemMessages {
        public String displayMessage(int var1);

        public String displayNoSelectedMessage();
    }
}

