/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.model.util;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.sencha.gxt.widget.core.client.form.CheckBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.IsField;
import com.sencha.gxt.widget.core.client.form.NumberField;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.editing.GridInlineEditing;
import java.util.Date;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowColumnConfig;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;

public class ColumnConfigGenerator {
    public static DataRowColumnConfig<?> generateConfiguration(ColumnDefinition columnDefinition) {
        DataRowColumnConfig columnConfig = null;
        SafeStylesBuilder ssb = new SafeStylesBuilder();
        switch (columnDefinition.getValueType()) {
            case BOOLEAN: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                if (columnDefinition.getType() == ColumnType.VALIDATION) {
                    columnConfig.setCellBoolean(new AbstractCell<Boolean>(new String[0]){

                        public void render(Cell.Context context, Boolean value, SafeHtmlBuilder sb) {
                            String style = "style='color: " + (value != false ? "green" : "black") + "'";
                            sb.appendHtmlConstant("<span " + style + " title='" + new SafeHtmlBuilder().append(value.booleanValue()).toSafeHtml().asString() + "'>" + new SafeHtmlBuilder().append(value.booleanValue()).toSafeHtml().asString() + "</span>");
                        }
                    });
                }
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                ssb.textAlign(Style.TextAlign.CENTER);
                break;
            }
            case DATE: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                columnConfig.setCellDate(new AbstractCell<Date>(new String[0]){

                    public void render(Cell.Context context, Date value, SafeHtmlBuilder sb) {
                        DateTimeFormat sdf = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
                        String v = String.valueOf(sdf.format(value));
                        sb.appendEscaped(v);
                    }
                });
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                ssb.textAlign(Style.TextAlign.CENTER);
                break;
            }
            case DOUBLE: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                ssb.textAlign(Style.TextAlign.RIGHT);
                break;
            }
            case INTEGER: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                ssb.textAlign(Style.TextAlign.RIGHT);
                break;
            }
            case LONG: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                ssb.textAlign(Style.TextAlign.RIGHT);
                break;
            }
            case GEOMETRY: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                break;
            }
            case STRING: {
                columnConfig = ColumnConfigGenerator.create(columnDefinition);
                SafeStyles safeStyle = columnConfig.getColumnStyle();
                ssb.append(safeStyle);
                break;
            }
            default: {
                return null;
            }
        }
        if (columnDefinition.getType() == ColumnType.VIEWCOLUMN) {
            ssb.trustedBackgroundColor("#c3e1fc");
        }
        columnConfig.setColumnStyle(ssb.toSafeStyles());
        columnConfig.setHidden(!columnDefinition.isVisible());
        SafeHtmlBuilder tooltipMessage = new SafeHtmlBuilder();
        String local = "";
        if (columnDefinition.getLocale() != null && !columnDefinition.getLocale().isEmpty()) {
            local = " [" + columnDefinition.getLocale() + "] ";
        }
        tooltipMessage.appendHtmlConstant("<p align='Left'><bold style='font-weight:bold;'>" + SafeHtmlUtils.htmlEscape((String)columnDefinition.getLabel()) + "</bold><BR>" + "<em style='text-decoration:underline;'>" + SafeHtmlUtils.htmlEscape((String)columnDefinition.getColumnTypeName()) + "</em><bold>" + SafeHtmlUtils.htmlEscape((String)local) + "</bold><BR>" + "<em>" + SafeHtmlUtils.htmlEscape((String)columnDefinition.getColumnDataType()) + "</em><BR>" + SafeHtmlUtils.htmlEscape((String)columnDefinition.getTooltipMessage()) + "</p>");
        columnConfig.setToolTip(tooltipMessage.toSafeHtml());
        return columnConfig;
    }

    protected static <T> DataRowColumnConfig<T> create(ColumnDefinition columnDefinition) {
        return new DataRowColumnConfig(columnDefinition);
    }

    public static void setEditor(GridInlineEditing<DataRow> editableGrid, ColumnConfig<DataRow, ?> columnConfig) {
        if (!(columnConfig instanceof DataRowColumnConfig)) {
            throw new IllegalArgumentException("Expected ColumnConfig type JSonValueColumnConfig");
        }
        ColumnConfigGenerator.setEditor(editableGrid, (DataRowColumnConfig)columnConfig);
    }

    public static void setEditor(GridInlineEditing<DataRow> editableGrid, DataRowColumnConfig<?> columnConfig) {
        if (columnConfig.getDefinition().isEditable()) {
            switch (columnConfig.getDefinition().getValueType()) {
                case BOOLEAN: {
                    editableGrid.addEditor(columnConfig, (IsField)new CheckBox());
                    break;
                }
                case DATE: {
                    editableGrid.addEditor(columnConfig, (IsField)new DateField());
                    break;
                }
                case DOUBLE: {
                    editableGrid.addEditor(columnConfig, (IsField)new NumberField((NumberPropertyEditor)new NumberPropertyEditor.DoublePropertyEditor()));
                    break;
                }
                case INTEGER: {
                    editableGrid.addEditor(columnConfig, (IsField)new NumberField((NumberPropertyEditor)new NumberPropertyEditor.IntegerPropertyEditor()));
                    break;
                }
                case LONG: {
                    editableGrid.addEditor(columnConfig, (IsField)new NumberField((NumberPropertyEditor)new NumberPropertyEditor.LongPropertyEditor()));
                    break;
                }
                case GEOMETRY: {
                    editableGrid.addEditor(columnConfig, (IsField)new TextField());
                    break;
                }
                case STRING: {
                    editableGrid.addEditor(columnConfig, (IsField)new TextField());
                    break;
                }
            }
        }
    }
}

