/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.server.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceXFactoryRegistry {
    protected static DataSourceXFactoryRegistry instance;
    private static final Logger log;
    protected Map<String, DataSourceXFactory> instancesRegistry = new HashMap<String, DataSourceXFactory>();

    static {
        log = LoggerFactory.getLogger(DataSourceXFactoryRegistry.class);
    }

    public static DataSourceXFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceXFactoryRegistry();
        }
        return instance;
    }

    protected DataSourceXFactoryRegistry() {
        this.addInstancesInEnv();
    }

    protected void addInstancesInEnv() {
        ServiceLoader<DataSourceXFactory> loader = ServiceLoader.load(DataSourceXFactory.class);
        for (DataSourceXFactory factory : loader) {
            this.add(factory);
        }
    }

    public void add(DataSourceXFactory factory) {
        log.trace("add factory: " + factory.getId());
        DataSourceXFactory old = this.instancesRegistry.put(factory.getId(), factory);
        if (old != null) {
            log.warn("A DataSourceFactory instance with id " + old.getId() + " and class " + old.getClass().getCanonicalName() + " was already registered. The old one has been replaced by the new one with class " + factory.getClass().getCanonicalName() + ".");
        }
    }

    public DataSourceXFactory get(String factoryId) {
        return this.instancesRegistry.get(factoryId);
    }

    public boolean exists(String factoryId) {
        return this.instancesRegistry.containsKey(factoryId);
    }

    public void remove(String factoryId) {
        log.trace("remove factoryId: " + factoryId);
        this.instancesRegistry.remove(factoryId);
    }
}

