/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MultivaluedStringParameter
extends LeafParameter<String> {
    private List<String> admittedValues = null;
    private boolean caseSensitive = true;

    private MultivaluedStringParameter() {
    }

    public MultivaluedStringParameter(String identifier, String name, String description, Cardinality cardinality, List<String> admittedValues) {
        super(identifier, name, description, cardinality);
        if (admittedValues == null || admittedValues.isEmpty()) {
            throw new IllegalArgumentException("Must provide a non empty list of admitted values");
        }
        this.admittedValues = admittedValues;
    }

    public MultivaluedStringParameter(String identifier, String name, String description, Cardinality cardinality, List<String> admittedValues, boolean caseSensitive) {
        super(identifier, name, description, cardinality);
        this.admittedValues = admittedValues;
        this.caseSensitive = caseSensitive;
    }

    public boolean validate(String value) {
        return this.getAdmittedValues().contains(value);
    }

    public List<String> getAdmittedValues() {
        return this.admittedValues;
    }

    @Override
    public Class<String> getParameterType() {
        return String.class;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.admittedValues == null ? 0 : this.admittedValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultivaluedStringParameter other = (MultivaluedStringParameter)obj;
        return !(this.admittedValues == null ? other.admittedValues != null : !this.admittedValues.equals(other.admittedValues));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultivaluedStringParameter [admittedValues=");
        builder.append(this.admittedValues);
        builder.append(", caseSensitive=");
        builder.append(this.caseSensitive);
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object valueObj) throws Exception {
        super.validateValue(valueObj);
        String value = (String)valueObj;
        if (this.caseSensitive) {
            if (!this.admittedValues.contains(value)) {
                throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getAdmittedValues()));
            }
        } else {
            boolean ok = false;
            for (String admitted : this.admittedValues) {
                if (!admitted.equalsIgnoreCase(value)) continue;
                ok = true;
            }
            if (!ok) {
                throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getAdmittedValues()));
            }
        }
    }
}

