/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.dataparser.engine.writer.SdmxDataWriterEngine;
import org.sdmxsource.util.ObjectUtil;

public class CrossSectionDataWriterEngine
extends SdmxDataWriterEngine {
    private Logger LOG = Logger.getLogger(CrossSectionDataWriterEngine.class);
    private List<String> datasetComponents = new ArrayList<String>();
    private List<String> groupComponents = new ArrayList<String>();
    private List<String> sectionComponents = new ArrayList<String>();
    private List<String> obsComponents = new ArrayList<String>();
    private String currentGroupKey;
    private String currentSectionKey;
    private Map<String, String> componentVals = new HashMap<String, String>();
    private String obsValue;
    boolean flushObsRequired = false;
    private String timeConcept;

    public CrossSectionDataWriterEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        super(schemaVersion, BASE_DATA_FORMAT.CROSS_SECTIONAL, out);
        if (schemaVersion != SDMX_SCHEMA.VERSION_ONE && schemaVersion != SDMX_SCHEMA.VERSION_TWO) {
            throw new SdmxException("Can not create a cross sectional writer in version '" + schemaVersion + "', only SDMX version 1.0 & 2.0 supported");
        }
    }

    @Override
    public void startDataset(DataflowBean dataflowBean, DataStructureBean dsd, DatasetHeaderBean header, AnnotationBean ... annotations) {
        super.startDataset(dataflowBean, dsd, header, new AnnotationBean[0]);
        this.timeConcept = this.getComponentId((ComponentBean)dsd.getTimeDimension());
        if (dsd instanceof CrossSectionalDataStructureBean) {
            this.LOG.debug((Object)"Create Cross Sectional Data Writer with Cross Sectional DataStructure");
            CrossSectionalDataStructureBean xsDsd = (CrossSectionalDataStructureBean)dsd;
            this.LOG.debug((Object)"Populate Dataset Components");
            this.populateGroupingComponents(xsDsd.getCrossSectionalAttachDataSet(true, new SDMX_STRUCTURE_TYPE[0]), this.datasetComponents);
            this.LOG.debug((Object)"Populate Group Components");
            this.populateGroupingComponents(xsDsd.getCrossSectionalAttachGroup(true, new SDMX_STRUCTURE_TYPE[0]), this.groupComponents);
            this.LOG.debug((Object)"Populate Section Components");
            this.populateGroupingComponents(xsDsd.getCrossSectionalAttachSection(true, new SDMX_STRUCTURE_TYPE[0]), this.sectionComponents);
            this.LOG.debug((Object)"Populate Observation Components");
            this.populateGroupingComponents(xsDsd.getCrossSectionalAttachObservation(new SDMX_STRUCTURE_TYPE[0]), this.obsComponents);
        } else {
            this.LOG.debug((Object)"Create Cross Sectional Data Writer with Standard DataStructure");
            this.LOG.debug((Object)"Populate Observation Components");
            this.populateGroupingComponents(dsd.getComponents(), this.obsComponents);
        }
        this.datasetAnnotations = annotations;
    }

    private void populateGroupingComponents(List<ComponentBean> components, List<String> setToPopulate) {
        for (ComponentBean currentComponent : components) {
            this.LOG.debug((Object)("Component: " + this.getComponentId(currentComponent.getId())));
            setToPopulate.add(this.getComponentId(currentComponent.getId()));
        }
    }

    @Override
    public void startGroup(String groupId, AnnotationBean ... annotations) {
    }

    @Override
    protected void closeGroupWriter() throws Exception {
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
    }

    @Override
    public void startSeries(AnnotationBean ... annotations) {
        super.startSeries(new AnnotationBean[0]);
        this.flushObservation();
        this.componentVals = new HashMap<String, String>();
        this.seriesAnnotations = annotations;
    }

    @Override
    public void writeSeriesKeyValue(String dimensionId, String dimensionValue) {
        dimensionId = this.getComponentId(dimensionId);
        super.writeSeriesKeyValue(dimensionId, dimensionValue);
        this.componentVals.put(dimensionId, dimensionValue);
    }

    @Override
    public void writeObservation(String obsConceptId, String obsIdValue, String obsValue, AnnotationBean ... annotations) {
        this.flushObservation();
        obsConceptId = this.getComponentId(obsConceptId);
        super.writeObservation(obsConceptId, obsIdValue, obsValue, new AnnotationBean[0]);
        if (!ObjectUtil.validString((String[])new String[]{obsValue})) {
            obsValue = "NaN";
        }
        this.obsValue = obsValue;
        this.componentVals.put(obsConceptId, obsIdValue);
        this.obsAnnotations = annotations;
        this.flushObsRequired = true;
    }

    public void writeObservation(String obsConceptValue, String obsValue, AnnotationBean ... annotations) {
        if (this.isCrossSectional) {
            this.writeObservation(this.crossSectionConcept, obsConceptValue, obsValue, annotations);
        } else {
            this.writeObservation(this.timeConcept, obsConceptValue, obsValue, annotations);
        }
    }

    private boolean startNewCrossSectionalGroupIfRequired() throws XMLStreamException {
        String newGroupKey;
        if (this.currentPosition != SdmxDataWriterEngine.POSITION.OBSERVATION) {
            this.currentGroupKey = this.startNewCrossSection("Group", this.groupComponents);
            this.currentSectionKey = this.startNewCrossSection("Section", this.sectionComponents);
            return true;
        }
        if (this.groupComponents.size() > 0 && !this.currentGroupKey.equals(newGroupKey = this.getUniqueKey(this.groupComponents))) {
            this.seriesWriter.writeEndElement();
            this.seriesWriter.writeEndElement();
            this.currentGroupKey = this.startNewCrossSection("Group", this.groupComponents);
            this.currentSectionKey = this.startNewCrossSection("Section", this.sectionComponents);
            return true;
        }
        return false;
    }

    private void startNewCrossSectionalSectionfRequired() throws XMLStreamException {
        String newSectionKey;
        if (this.currentPosition != SdmxDataWriterEngine.POSITION.OBSERVATION) {
            this.currentSectionKey = this.startNewCrossSection("Section", this.sectionComponents);
        } else if (this.groupComponents.size() > 0 && !this.currentSectionKey.equals(newSectionKey = this.getUniqueKey(this.sectionComponents))) {
            this.seriesWriter.writeEndElement();
            this.currentSectionKey = this.startNewCrossSection("Section", this.sectionComponents);
        }
    }

    private String startNewCrossSection(String sectionName, List<String> crossSectionComponentIds) throws XMLStreamException {
        this.startElement(this.seriesWriter, this.CROSS_NS, sectionName);
        for (String currentComponent : crossSectionComponentIds) {
            if (!this.componentVals.containsKey(currentComponent)) continue;
            this.seriesWriter.writeAttribute(currentComponent, this.componentVals.get(currentComponent));
        }
        return this.getUniqueKey(crossSectionComponentIds);
    }

    private String getUniqueKey(List<String> crossSectionComponentIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        for (String currentComponent : crossSectionComponentIds) {
            sb.append(currentComponent);
            sb.append(":");
            sb.append(this.componentVals.get(currentComponent));
        }
        return sb.toString();
    }

    private void flushObservation() {
        if (!this.flushObsRequired) {
            return;
        }
        try {
            if (!this.startNewCrossSectionalGroupIfRequired()) {
                this.startNewCrossSectionalSectionfRequired();
            }
            this.currentPosition = SdmxDataWriterEngine.POSITION.OBSERVATION;
            this.startElement(this.seriesWriter, this.CROSS_NS, "OBS_VALUE");
            for (String currentComponent : this.obsComponents) {
                if (!this.componentVals.containsKey(currentComponent)) continue;
                this.seriesWriter.writeAttribute(currentComponent, this.componentVals.get(currentComponent));
            }
            this.seriesWriter.writeAttribute("value", this.obsValue);
            this.writeAnnotations(this.seriesWriter, this.obsAnnotations);
            this.obsAnnotations = null;
            this.seriesWriter.writeEndElement();
            this.flushObsRequired = false;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeAttributeValue(String attributeId, String attributeValue) {
        attributeId = this.getComponentId(attributeId);
        super.writeAttributeValue(attributeId, attributeValue);
        if (attributeValue == null) {
            attributeValue = "";
        }
        this.componentVals.put(attributeId, attributeValue);
    }

    @Override
    public void close(DataWriterEngine.FooterMessage ... footer) {
        this.flushObservation();
        super.close(footer);
    }
}

