/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.SchemaGenerator;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreator;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreatorSdmx;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreatorSdmx2_1;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.resourceBundle.PropertiesToMap;
import org.springframework.beans.factory.annotation.Required;

public class SchemaGeneratorCompact
implements SchemaGenerator {
    private Map<SDMX_SCHEMA, String> schemaLocationMap = new HashMap<SDMX_SCHEMA, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, Map<String, Set<String>> validCodes) {
        String schemaLocation = this.obtainSchemaLocation(targetSchemaVersion);
        CompactSchemaCreator creator = targetSchemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE) ? new CompactSchemaCreatorSdmx2_1(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes) : new CompactSchemaCreatorSdmx(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes);
        try {
            creator.createSchema();
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
            throw throwable;
        }
        StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformCrossSectional(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String crossSectionDimensionId, Map<String, Set<String>> validCodes) {
        String schemaLocation = this.obtainSchemaLocation(targetSchemaVersion);
        if (keyFamily == null) {
            throw new SdmxException("Can not create Schema, no Data Structure provided");
        }
        CompactSchemaCreator creator = targetSchemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE) ? new CompactSchemaCreatorSdmx2_1(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes) : new CompactSchemaCreatorSdmx(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes);
        try {
            creator.createSchema();
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
            throw throwable;
        }
        StreamUtil.closeStream((OutputStream[])new OutputStream[]{out});
    }

    private String obtainSchemaLocation(SDMX_SCHEMA targetSchemaVersion) {
        return this.schemaLocationMap.get(targetSchemaVersion);
    }

    @Required
    public void setSchemaLocationProperties(Properties properties) {
        Map propsMap = PropertiesToMap.createMap((Properties)properties);
        for (String schemaVersion : propsMap.keySet()) {
            this.schemaLocationMap.put(SDMX_SCHEMA.valueOf((String)schemaVersion), (String)propsMap.get(schemaVersion));
        }
    }

    public void addSchemaLocation(SDMX_SCHEMA version, String schemaLocation) {
        this.schemaLocationMap.put(version, schemaLocation);
    }
}

