/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.datastructure;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.HierarchicalCodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.ComponentSuperBeanImpl;

public class DimensionSuperBeanImpl
extends ComponentSuperBeanImpl
implements DimensionSuperBean {
    private static final long serialVersionUID = 1L;
    private Set<HierarchicalCodelistSuperBean> hcls;
    private boolean isFrequenyDimension;
    private boolean isMeasureDimension;
    private boolean isTimeDimension;
    private DimensionBean dimensionBean;

    public DimensionSuperBeanImpl(DimensionBean dimension, CodelistSuperBean codelist, ConceptSuperBean concept) {
        this(dimension, codelist, concept, null);
        this.dimensionBean = dimension;
    }

    public DimensionSuperBeanImpl(DimensionBean dimension, CodelistSuperBean codelist, ConceptSuperBean concept, Set<HierarchicalCodelistSuperBean> hcls) {
        super((ComponentBean)dimension, codelist, concept);
        this.dimensionBean = dimension;
        this.isFrequenyDimension = dimension.isFrequencyDimension();
        this.isMeasureDimension = dimension.isMeasureDimension();
        this.isTimeDimension = dimension.isTimeDimension();
        this.hcls = hcls;
        if (hcls == null) {
            this.hcls = new HashSet<HierarchicalCodelistSuperBean>();
        }
        if (concept == null) {
            throw new SdmxSemmanticException(ExceptionCode.JAVA_REQUIRED_OBJECT_NULL, new Object[]{ConceptSuperBean.class.getCanonicalName()});
        }
    }

    public Set<HierarchicalCodelistSuperBean> getHierarchicalCodelists() {
        return new HashSet<HierarchicalCodelistSuperBean>(this.hcls);
    }

    public boolean isFrequency() {
        return this.isFrequenyDimension;
    }

    public boolean isFrequencyDimension() {
        return this.isFrequenyDimension;
    }

    public boolean isMeasureDimension() {
        return this.isMeasureDimension;
    }

    public boolean isTimeDimension() {
        return this.isTimeDimension;
    }

    public DimensionBean getBuiltFrom() {
        return this.dimensionBean;
    }
}

