/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td.filters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterThan;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessThan;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Soundex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextBeginsWith;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextContains;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextEndsWith;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.portlets.user.tdwx.datasource.td.TDXDataSource;
import org.gcube.portlets.user.tdwx.datasource.td.map.DataTypeMap;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.shared.FilterInformation;
import org.gcube.portlets.user.tdwx.shared.StaticFilterInformation;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersBuilder {
    protected ArrayList<FilterInformation> filters;
    protected ArrayList<StaticFilterInformation> staticFilters;
    protected TableDefinition tableDefinition;
    protected Table serviceTable;
    protected Logger logger = LoggerFactory.getLogger(TDXDataSource.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public FiltersBuilder(ArrayList<FilterInformation> filters, ArrayList<StaticFilterInformation> staticFilters, TableDefinition tableDefinition, Table serviceTable) {
        this.filters = filters;
        this.staticFilters = staticFilters;
        this.tableDefinition = tableDefinition;
        this.serviceTable = serviceTable;
    }

    protected Expression createExpression() throws DataSourceXException {
        try {
            ArrayList<Object> andExp;
            Expression exp;
            block29: {
                exp = null;
                andExp = new ArrayList<Object>();
                if (this.filters == null) break block29;
                for (FilterInformation filter : this.filters) {
                    switch (filter.getFilterType()) {
                        case "string": {
                            if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                                this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                                throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                            }
                            ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                            Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                            Expression ex = this.getExpressionText(column, filter);
                            if (ex == null) break;
                            andExp.add(ex);
                            break;
                        }
                        case "numeric": {
                            if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                                this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                                throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                            }
                            ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                            Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                            Expression ex = this.getExpressionNumeric(column, filter);
                            if (ex == null) break;
                            andExp.add(ex);
                            break;
                        }
                        case "boolean": {
                            if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                                this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                                throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                            }
                            ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                            Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                            Equals contains = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDBoolean(new Boolean(filter.getFilterValue()).booleanValue()));
                            andExp.add(contains);
                            break;
                        }
                        case "date": {
                            if (this.tableDefinition.getColumns().get(filter.getFilterField()) == null) {
                                this.logger.error("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                                throw new DataSourceXException("The specified filter column \"" + filter.getFilterField() + "\" don't exists");
                            }
                            ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(filter.getFilterField());
                            Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
                            Expression ex = this.getExpressionDate(column, filter);
                            if (ex == null) break;
                            andExp.add(ex);
                            break;
                        }
                    }
                }
            }
            if (this.staticFilters != null) {
                for (StaticFilterInformation staticFilter : this.staticFilters) {
                    if (this.tableDefinition.getColumns().get(staticFilter.getColumnName()) == null) {
                        this.logger.error("Static Filter not applicable, the specified column \"" + staticFilter.getColumnName() + "\" don't exists");
                        throw new DataSourceXException("Static Filter not applicable, the specified column \"" + staticFilter.getColumnName() + "\" don't exists");
                    }
                    ColumnDefinition columnDefinition = (ColumnDefinition)this.tableDefinition.getColumns().get(staticFilter.getColumnName());
                    Column column = this.serviceTable.getColumnById(new ColumnLocalId(columnDefinition.getColumnLocalId()));
                    Expression e = this.createStaticExpression(staticFilter, this.serviceTable.getId(), column);
                    if (e == null) continue;
                    andExp.add(e);
                }
            }
            if (andExp.size() > 0) {
                if (andExp.size() == 1) {
                    exp = (Expression)andExp.get(0);
                } else {
                    And andE = new And(andExp);
                    exp = andE;
                }
            }
            this.logger.debug("Filter Expression created: " + exp);
            return exp;
        }
        catch (Throwable e) {
            this.logger.error("Create expression failed. " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new DataSourceXException("Create expression failed. " + e.getLocalizedMessage());
        }
    }

    private Expression createStaticExpression(StaticFilterInformation staticFilter, TableId id, Column column) throws DataSourceXException {
        try {
            TextContains exp = null;
            DataType dataType = column.getDataType();
            ValueType valueType = DataTypeMap.getValueType(dataType);
            switch (valueType) {
                case BOOLEAN: {
                    TDBoolean bool = new TDBoolean(new Boolean(staticFilter.getFilterValue()).booleanValue());
                    exp = new Equals((Expression)new ColumnReference(id, column.getLocalId()), (Expression)bool);
                    break;
                }
                case DATE: {
                    try {
                        Date dd = this.sdf.parse(staticFilter.getFilterValue());
                        TDDate tdDate = new TDDate(dd);
                        exp = new Equals((Expression)new ColumnReference(id, column.getLocalId()), (Expression)tdDate);
                    }
                    catch (ParseException e) {
                        this.logger.error("Static Filter has not valid value type: " + staticFilter);
                        e.printStackTrace();
                    }
                    break;
                }
                case DOUBLE: {
                    TDNumeric doublenum = new TDNumeric(new Double(staticFilter.getFilterValue()));
                    exp = new Equals((Expression)new ColumnReference(id, column.getLocalId()), (Expression)doublenum);
                    break;
                }
                case INTEGER: {
                    TDInteger intnum = new TDInteger(new Integer(staticFilter.getFilterValue()));
                    exp = new Equals((Expression)new ColumnReference(id, column.getLocalId()), (Expression)intnum);
                    break;
                }
                case LONG: {
                    TDInteger longnum = new TDInteger(new Integer(staticFilter.getFilterValue()));
                    exp = new Equals((Expression)new ColumnReference(id, column.getLocalId()), (Expression)longnum);
                    break;
                }
                case STRING: {
                    exp = new TextContains((Expression)new ColumnReference(id, column.getLocalId()), (Expression)new TDText(staticFilter.getFilterValue()));
                    break;
                }
                case GEOMETRY: {
                    exp = new TextContains((Expression)new ColumnReference(id, column.getLocalId()), (Expression)new TDText(staticFilter.getFilterValue()));
                    break;
                }
            }
            return exp;
        }
        catch (Throwable e) {
            this.logger.error("Create Static Filter expression failed :" + e.getLocalizedMessage());
            e.printStackTrace();
            throw new DataSourceXException("Create Static Filter expression failed :" + e.getLocalizedMessage());
        }
    }

    protected Expression getExpressionDate(Column column, FilterInformation filter) throws DataSourceXException {
        LessThan exp = null;
        Date dd = new Date();
        Long day = null;
        try {
            day = new Long(filter.getFilterValue());
        }
        catch (NumberFormatException e) {
            this.logger.error("No valid filterValue for date: " + filter.getFilterValue());
            throw new DataSourceXException("No valid filter value");
        }
        dd.setTime(day);
        TDDate tdDate = new TDDate(dd);
        switch (filter.getFilterComparison()) {
            case "on": {
                exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
            case "after": {
                exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
            case "before": {
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)tdDate);
                break;
            }
        }
        return exp;
    }

    protected Expression getExpressionText(Column column, FilterInformation filter) {
        TextBeginsWith exp = null;
        String comparison = filter.getFilterComparison();
        if (comparison != null && comparison.isEmpty()) {
            return exp;
        }
        switch (comparison) {
            case "contains": {
                TextContains contains = new TextContains((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDText(filter.getFilterValue()));
                exp = contains;
                break;
            }
            case "begins": {
                TextBeginsWith begins;
                exp = begins = new TextBeginsWith((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDText(filter.getFilterValue()));
                break;
            }
            case "ends": {
                TextEndsWith ends = new TextEndsWith((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)new TDText(filter.getFilterValue()));
                exp = ends;
                break;
            }
            case "soundex": {
                Soundex soundexCol = new Soundex((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()));
                Soundex soundexVal = new Soundex((Expression)new TDText(filter.getFilterValue()));
                Equals eq = new Equals((Expression)soundexCol, (Expression)soundexVal);
                exp = eq;
            }
        }
        return exp;
    }

    protected Expression getExpressionNumeric(Column column, FilterInformation filter) {
        Equals exp = null;
        ValueType vt = DataTypeMap.getValueType(column.getDataType());
        switch (vt) {
            case DOUBLE: {
                TDNumeric floatnum = new TDNumeric(new Double(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)floatnum);
                break;
            }
            case INTEGER: {
                TDInteger intnum = new TDInteger(new Integer(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)intnum);
                break;
            }
            case LONG: {
                TDInteger longnum = new TDInteger(new Integer(filter.getFilterValue()));
                if (filter.getFilterComparison().compareTo("eq") == 0) {
                    exp = new Equals((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("gt") == 0) {
                    exp = new GreaterThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                    break;
                }
                if (filter.getFilterComparison().compareTo("lt") != 0) break;
                exp = new LessThan((Expression)new ColumnReference(this.serviceTable.getId(), column.getLocalId()), (Expression)longnum);
                break;
            }
        }
        return exp;
    }

    public QueryFilter createQueryFilter() throws DataSourceXException {
        QueryFilter queryFilter = null;
        Expression exp = this.createExpression();
        if (exp != null) {
            queryFilter = new QueryFilter(exp);
        }
        this.logger.debug("QueryFilter: " + queryFilter);
        return queryFilter;
    }
}

