/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ExceptionHandler;
import org.sdmxsource.sdmx.api.manager.retrieval.ConstraintRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.validation.DataValidationManager;
import org.sdmxsource.sdmx.dataparser.manager.impl.ConstraintValidationManager;
import org.sdmxsource.sdmx.dataparser.manager.impl.DeepDataValidationManager;
import org.sdmxsource.sdmx.structureretrieval.manager.SdmxSuperBeanRetrievalManagerImpl;
import org.springframework.beans.factory.annotation.Required;

public class ChainedValidationManager
implements DataValidationManager {
    private ConstraintRetrievalManager constraintRetrievalManager;
    private SdmxSuperBeanRetrievalManager superBeanRetrievalManager;
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public void validateData(DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        this.validateDataAgainstDataStructure(dre, exceptionHandler);
        this.validateDataAgainstConstraint(dre, exceptionHandler);
    }

    protected void validateDataAgainstDataStructure(DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        this.validate(new DeepDataValidationManager(this.getSuperBeanRetrievalManager()), dre, exceptionHandler);
    }

    protected void validateDataAgainstConstraint(DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        this.validate(new ConstraintValidationManager(this.constraintRetrievalManager, this.beanRetrievalManager), dre, exceptionHandler);
    }

    protected void validate(DataValidationManager dvm, DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        dvm.validateData(dre, exceptionHandler);
    }

    private SdmxSuperBeanRetrievalManager getSuperBeanRetrievalManager() {
        if (this.superBeanRetrievalManager == null) {
            this.superBeanRetrievalManager = new SdmxSuperBeanRetrievalManagerImpl(this.beanRetrievalManager);
        }
        return this.superBeanRetrievalManager;
    }

    @Required
    public void setBeanRetrievalManager(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
    }

    @Required
    public void setConstraintRetrievalManager(ConstraintRetrievalManager constraintRetrievalManager) {
        this.constraintRetrievalManager = constraintRetrievalManager;
    }
}

