/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.util.Calendar;
import java.util.Date;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.util.date.DateUtil;

public class SdmxDateImpl
implements SdmxDate {
    private static final long serialVersionUID = 889352854909061494L;
    private Date date;
    private TIME_FORMAT timeFormat;
    private String dateInSdmx;

    public SdmxDateImpl(Date date, TIME_FORMAT timeFormat) {
        this.date = date;
        this.timeFormat = timeFormat;
        this.dateInSdmx = DateUtil.formatDate((Date)date, (TIME_FORMAT)timeFormat);
    }

    public SdmxDateImpl(String dateInSdmx) {
        this.date = DateUtil.formatDate((Object)dateInSdmx, (boolean)true);
        this.timeFormat = DateUtil.getTimeFormatOfDate((String)dateInSdmx);
        this.dateInSdmx = dateInSdmx;
    }

    public boolean isLater(SdmxDate date) {
        return this.getDate().getTime() > date.getDate().getTime();
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public TIME_FORMAT getTimeFormatOfDate() {
        return this.timeFormat;
    }

    public String getDateInSdmxFormat() {
        return this.dateInSdmx;
    }

    public Calendar getDateAsCalendar() {
        return DateUtil.createCalendar((Date)this.date);
    }

    public int hashCode() {
        return this.dateInSdmx.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SdmxDate) {
            SdmxDate that = (SdmxDate)obj;
            return that.getDateInSdmxFormat().equals(this.getDateInSdmxFormat());
        }
        return false;
    }
}

