/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IncludedCodelistReferenceType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistRefBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchyBean;
import org.sdmxsource.sdmx.api.model.mutable.base.HierarchyMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.HierarchicalCodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.reference.CodelistRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistRefBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.HierarchicalCodelistMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class HierarchicalCodelistBeanImpl
extends MaintainableBeanImpl
implements HierarchicalCodelistBean {
    private static final long serialVersionUID = 1L;
    private List<HierarchyBean> hierarchies = new ArrayList<HierarchyBean>();
    private List<CodelistRefBean> codelistRef = new ArrayList<CodelistRefBean>();

    private HierarchicalCodelistBeanImpl(HierarchicalCodelistBean bean, URL actualLocation, boolean isServiceUrl) {
        super((MaintainableBean)bean, actualLocation, isServiceUrl);
    }

    public HierarchicalCodelistBeanImpl(HierarchicalCodelistMutableBean bean) {
        super((MaintainableMutableBean)bean);
        try {
            if (bean.getCodelistRef() != null) {
                for (CodelistRefMutableBean currentRef : bean.getCodelistRef()) {
                    this.codelistRef.add(new CodelistRefBeanImpl(currentRef, (SdmxStructureBean)this));
                }
            }
            if (bean.getHierarchies() != null) {
                for (HierarchyMutableBean currentHierarchy : bean.getHierarchies()) {
                    this.hierarchies.add(new HierarchyBeanImpl((HierarchicalCodelistBean)this, currentHierarchy));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
    }

    public HierarchicalCodelistBeanImpl(HierarchicalCodelistType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
        try {
            if (bean.getIncludedCodelistList() != null) {
                for (IncludedCodelistReferenceType currentRef : bean.getIncludedCodelistList()) {
                    if (currentRef.getRef() == null) {
                        this.codelistRef.add(new CodelistRefBeanImpl(currentRef.getURN(), currentRef.getAlias(), this));
                        continue;
                    }
                    this.codelistRef.add(new CodelistRefBeanImpl(currentRef.getRef().getAgencyID(), currentRef.getRef().getId(), currentRef.getRef().getVersion(), currentRef.getAlias(), this));
                }
            }
            if (bean.getHierarchyList() != null) {
                for (org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchyType currentValueHierarchy : bean.getHierarchyList()) {
                    this.hierarchies.add(new HierarchyBeanImpl((HierarchicalCodelistBean)this, currentValueHierarchy));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
    }

    public HierarchicalCodelistBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), HierarchicalCodelistBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), HierarchicalCodelistBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        try {
            if (bean.getCodelistRefList() != null) {
                for (CodelistRefType currentRef : bean.getCodelistRefList()) {
                    if (currentRef.getURN() != null) {
                        try {
                            this.codelistRef.add(new CodelistRefBeanImpl(currentRef.getURN(), currentRef.getAlias(), this));
                            continue;
                        }
                        catch (Throwable th) {
                            throw new SdmxSemmanticException(th, "Error while trying to parse CodelistRef for " + SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
                        }
                    }
                    try {
                        this.codelistRef.add(new CodelistRefBeanImpl(currentRef.getAgencyID(), currentRef.getCodelistID(), currentRef.getVersion(), currentRef.getAlias(), this));
                    }
                    catch (Throwable th) {
                        throw new SdmxSemmanticException(th, "Error while trying to parse CodelistRef for " + SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
                    }
                }
            }
            if (bean.getHierarchyList() != null) {
                for (HierarchyType currentHierarchy : bean.getHierarchyList()) {
                    this.hierarchies.add(new HierarchyBeanImpl((HierarchicalCodelistBean)this, currentHierarchy));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            HierarchicalCodelistBean that = (HierarchicalCodelistBean)bean;
            if (!super.equivalent(this.hierarchies, that.getHierarchies(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.codelistRef, that.getCodelistRef(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((MaintainableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.codelistRef != null) {
            HashSet<String> codelisAlias = new HashSet<String>();
            for (CodelistRefBean currentRef : this.codelistRef) {
                if (!ObjectUtil.validString((String[])new String[]{currentRef.getAlias()})) continue;
                if (codelisAlias.contains(currentRef.getAlias())) {
                    throw new SdmxSemmanticException(ExceptionCode.DUPLICATE_ALIAS, new Object[]{currentRef.getAlias()});
                }
                codelisAlias.add(currentRef.getAlias());
            }
        }
        if (this.hierarchies != null) {
            HashSet<String> hierarchyUrns = new HashSet<String>();
            for (HierarchyBean currentHierarhy : this.hierarchies) {
                try {
                    if (hierarchyUrns.contains(currentHierarhy.getUrn())) {
                        throw new SdmxSemmanticException(ExceptionCode.DUPLICATE_URN, new Object[]{currentHierarhy});
                    }
                    hierarchyUrns.add(currentHierarhy.getUrn());
                }
                catch (SdmxSemmanticException ex) {
                    throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
                }
                catch (Throwable th) {
                    throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
                }
            }
        }
    }

    public HierarchicalCodelistBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new HierarchicalCodelistBeanImpl(this, actualLocation, isServiceUrl);
    }

    public HierarchicalCodelistMutableBean getMutableInstance() {
        return new HierarchicalCodelistMutableBeanImpl(this);
    }

    public List<HierarchyBean> getHierarchies() {
        return new ArrayList<HierarchyBean>(this.hierarchies);
    }

    public List<CodelistRefBean> getCodelistRef() {
        return new ArrayList<CodelistRefBean>(this.codelistRef);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.hierarchies, composites);
        super.addToCompositeSet(this.codelistRef, composites);
        return composites;
    }
}

