/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.ReportedAttributeSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class ReportedAttributeSuperBeanImpl
extends SuperBeanImpl
implements ReportedAttributeSuperBean {
    private static final long serialVersionUID = -1884960818440120857L;
    private List<ReportedAttributeSuperBean> reportedAttributes = new ArrayList<ReportedAttributeSuperBean>();
    private ReportedAttributeBean builtFrom;
    private ConceptBean concept;
    private CodelistBean codelist;

    public ReportedAttributeSuperBeanImpl(MetadataAttributeBean correspondingMA, ReportedAttributeBean builtFrom, IdentifiableRetrievalManager retrievalManager) {
        super((SDMXBean)builtFrom);
        this.builtFrom = builtFrom;
        this.concept = (ConceptBean)retrievalManager.getIdentifiableBean(correspondingMA.getConceptRef(), ConceptBean.class);
        if (correspondingMA.hasCodedRepresentation()) {
            this.codelist = (CodelistBean)retrievalManager.getIdentifiableBean(correspondingMA.getRepresentation().getRepresentation(), CodelistBean.class);
        }
        if (builtFrom.getReportedAttributes() != null) {
            for (ReportedAttributeBean currentRA : builtFrom.getReportedAttributes()) {
                MetadataAttributeBean maBean = this.getMetadataAttributeForRepotedAttribute(currentRA, correspondingMA.getMetadataAttributes());
                this.reportedAttributes.add(new ReportedAttributeSuperBeanImpl(maBean, currentRA, retrievalManager));
            }
        }
    }

    private MetadataAttributeBean getMetadataAttributeForRepotedAttribute(ReportedAttributeBean reportedAttribute, List<MetadataAttributeBean> mAttributeBeans) {
        for (MetadataAttributeBean currentMAttribute : mAttributeBeans) {
            if (!currentMAttribute.getId().equals(reportedAttribute.getId())) continue;
            return currentMAttribute;
        }
        MaintainableBean maint = (MaintainableBean)reportedAttribute.getParent(MaintainableBean.class, false);
        StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(maint, SDMX_STRUCTURE_TYPE.METADATA_ATTRIBUTE, new String[]{reportedAttribute.getId()});
        throw new SdmxReferenceException((IdentifiableBean)maint, (StructureReferenceBean)sRef);
    }

    public ConceptBean getConcept() {
        return this.concept;
    }

    public CodelistBean getCodelist() {
        return this.codelist;
    }

    public boolean hasCodedRepresentation() {
        return this.codelist != null;
    }

    public String getId() {
        return this.builtFrom.getId();
    }

    public String getSimpleValue() {
        return this.builtFrom.getSimpleValue();
    }

    public List<TextTypeWrapper> getMetadataText() {
        return this.builtFrom.getMetadataText();
    }

    public boolean isPresentational() {
        return this.builtFrom.isPresentational();
    }

    public boolean hasSimpleValue() {
        return this.builtFrom.hasSimpleValue();
    }

    public List<ReportedAttributeSuperBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeSuperBean>(this.reportedAttributes);
    }

    public ReportedAttributeBean getBuiltFrom() {
        return this.builtFrom;
    }

    @Override
    public Set<MaintainableBean> getCompositeBeans() {
        Set<MaintainableBean> returnSet = super.getCompositeBeans();
        if (this.concept != null) {
            returnSet.add(this.concept.getMaintainableParent());
        }
        if (this.codelist != null) {
            returnSet.add((MaintainableBean)this.codelist);
        }
        if (this.reportedAttributes != null) {
            for (ReportedAttributeSuperBean reportedAttribute : this.reportedAttributes) {
                returnSet.addAll(reportedAttribute.getCompositeBeans());
            }
        }
        return returnSet;
    }
}

