/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.portlets.user.td.gwtservice.server.SDMXClient;
import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.CodelistMappingFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TRTasksManager;
import org.gcube.portlets.user.td.gwtservice.shared.chart.ChartTopRatingSession;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.geometry.GeometryCreatePointSession;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialCreateCoordinatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialDownscaleCSquareSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.json.JSONExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.map.MapCreationSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.statistical.StatisticalOperationSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskWrapper;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ChangeColumnsPositionSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupBySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.TimeAggregationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.DenormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.NormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.replacebyexternal.ReplaceByExternalSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.SaveResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    protected static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ASLSession getAslSession(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession session;
        String username = (String)httpSession.getAttribute("username");
        if (username == null) {
            logger.warn("no user found in session, using test one");
            username = "test.user";
            String scope = "/gcube/devsec/devVRE";
            httpSession.setAttribute("username", (Object)username);
            session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
            session.setScope(scope);
        } else {
            session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        }
        logger.info("SessionUtil: aslSession " + session.getUsername() + " " + session.getScope());
        return session;
    }

    public static void setTabularResources(HttpSession httpSession, List<TabularResource> trs) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap<String, List<TabularResource>> scopeToTabularResourcesMap = (HashMap<String, List<TabularResource>>)httpSession.getAttribute("SCOPE_TO_TABULAR_RESOURCE_LIST_MAP");
        if (scopeToTabularResourcesMap == null) {
            scopeToTabularResourcesMap = new HashMap<String, List<TabularResource>>();
            scopeToTabularResourcesMap.put(aslSession.getScope(), trs);
        } else {
            scopeToTabularResourcesMap.put(aslSession.getScope(), trs);
            httpSession.removeAttribute("SCOPE_TO_TABULAR_RESOURCE_LIST_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_TABULAR_RESOURCE_LIST_MAP", scopeToTabularResourcesMap);
    }

    public static TRId getTRId(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTRIdMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TRID_MAP");
        TRId id = null;
        if (scopeToTRIdMap == null) {
            logger.error("TR_ID was not acquired");
        } else {
            id = (TRId)scopeToTRIdMap.get(aslSession.getScope());
            if (id == null) {
                logger.error("TR_ID was not acquired");
            }
        }
        return id;
    }

    public static void setTRId(HttpSession httpSession, TRId trId) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap<String, TRId> scopeToTRIdMap = (HashMap<String, TRId>)httpSession.getAttribute("SCOPE_TO_CURRENT_TRID_MAP");
        if (scopeToTRIdMap == null) {
            scopeToTRIdMap = new HashMap<String, TRId>();
            scopeToTRIdMap.put(aslSession.getScope(), trId);
        } else {
            scopeToTRIdMap.put(aslSession.getScope(), trId);
            httpSession.removeAttribute("SCOPE_TO_CURRENT_TRID_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_CURRENT_TRID_MAP", scopeToTRIdMap);
    }

    public static TabResource getTabResource(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTabResourceMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCE_MAP");
        TabResource tabResource = null;
        if (scopeToTabResourceMap == null) {
            logger.error("CURRENT_TABULAR_RESOURCE was not acquired");
        } else {
            tabResource = (TabResource)scopeToTabResourceMap.get(aslSession.getScope());
            if (tabResource == null) {
                logger.error("CURRENT_TABULAR_RESOURCE was not acquired");
            }
        }
        return tabResource;
    }

    public static void setTabResource(HttpSession httpSession, TabResource tabResource) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap<String, TabResource> scopeToTabResourceMap = (HashMap<String, TabResource>)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCE_MAP");
        if (scopeToTabResourceMap == null) {
            scopeToTabResourceMap = new HashMap<String, TabResource>();
            scopeToTabResourceMap.put(aslSession.getScope(), tabResource);
        } else {
            scopeToTabResourceMap.put(aslSession.getScope(), tabResource);
            httpSession.removeAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCE_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCE_MAP", scopeToTabResourceMap);
    }

    public static ArrayList<TabResource> getCurrentTabularResourcesOpen(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        ArrayList currentTROpen = null;
        if (scopeToTabResourceOpenMap == null) {
            logger.error("CURRENT_TABULAR_RESOURCES_OPEN was not acquired");
        } else {
            currentTROpen = (ArrayList)scopeToTabResourceOpenMap.get(aslSession.getScope());
            if (currentTROpen == null) {
                logger.error("CURRENT_TABULAR_RESOURCES_OPEN was not acquired");
            }
        }
        return currentTROpen;
    }

    public static void setCurrentTabularResourcesOpen(HttpSession httpSession, ArrayList<TabResource> currentTROpen) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap<String, ArrayList<TabResource>> scopeToTabResourceOpenMap = (HashMap<String, ArrayList<TabResource>>)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        if (scopeToTabResourceOpenMap == null) {
            scopeToTabResourceOpenMap = new HashMap<String, ArrayList<TabResource>>();
            scopeToTabResourceOpenMap.put(aslSession.getScope(), currentTROpen);
        } else {
            scopeToTabResourceOpenMap.put(aslSession.getScope(), currentTROpen);
            httpSession.removeAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP", scopeToTabResourceOpenMap);
    }

    public static void addToCurrentTabularResourcesOpen(HttpSession httpSession, TabResource tabResource) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (tabResource.getTrId() != null && tabResource.getTrId().getId() != null & !tabResource.getTrId().getId().isEmpty()) {
            HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
            if (scopeToTabResourceOpenMap == null) {
                scopeToTabResourceOpenMap = new HashMap();
                ArrayList<TabResource> openList = new ArrayList<TabResource>();
                openList.add(tabResource);
                scopeToTabResourceOpenMap.put(aslSession.getScope(), openList);
            } else {
                ArrayList<TabResource> openList = (ArrayList<TabResource>)scopeToTabResourceOpenMap.get(aslSession.getScope());
                if (openList != null) {
                    for (TabResource tr : openList) {
                        if (tr.getTrId().getId().compareTo(tabResource.getTrId().getId()) != 0) continue;
                        openList.remove(tr);
                        break;
                    }
                    openList.add(tabResource);
                } else {
                    openList = new ArrayList<TabResource>();
                    openList.add(tabResource);
                }
                scopeToTabResourceOpenMap.put(aslSession.getScope(), openList);
                httpSession.removeAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
            }
            httpSession.setAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP", scopeToTabResourceOpenMap);
        } else {
            logger.error("Tabular Resource has invalid id");
        }
    }

    public static void removeFromCurrentTabularResourcesOpen(HttpSession httpSession, TRId trId) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (trId != null && trId.getId() != null & !trId.getId().isEmpty()) {
            HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
            if (scopeToTabResourceOpenMap == null) {
                scopeToTabResourceOpenMap = new HashMap();
                ArrayList openList = new ArrayList();
                scopeToTabResourceOpenMap.put(aslSession.getScope(), openList);
                logger.debug("No open tr list in session");
            } else {
                ArrayList openList = (ArrayList)scopeToTabResourceOpenMap.get(aslSession.getScope());
                if (openList != null) {
                    for (TabResource tr : openList) {
                        if (tr.getTrId().getId().compareTo(trId.getId()) != 0) continue;
                        openList.remove(tr);
                        break;
                    }
                } else {
                    openList = new ArrayList();
                }
                scopeToTabResourceOpenMap.put(aslSession.getScope(), openList);
                httpSession.removeAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
            }
            httpSession.setAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP", scopeToTabResourceOpenMap);
        } else {
            logger.error("TRId request has invalid id");
        }
    }

    public static void removeAllFromCurrentTabularResourcesOpen(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        if (scopeToTabResourceOpenMap == null) {
            logger.debug("No open tr list in session");
        } else {
            scopeToTabResourceOpenMap.remove(aslSession.getScope());
            httpSession.removeAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
            httpSession.setAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP", (Object)scopeToTabResourceOpenMap);
        }
    }

    public static TabResource getFirstFromCurrentTabularResourcesOpen(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        if (scopeToTabResourceOpenMap == null) {
            logger.info("No open tr in session");
            return null;
        }
        ArrayList openList = (ArrayList)scopeToTabResourceOpenMap.get(aslSession.getScope());
        if (openList == null || openList.isEmpty()) {
            logger.info("No open tr in session");
            return null;
        }
        return (TabResource)openList.get(0);
    }

    public static TabResource getFromCurrentTabularResourcesOpen(HttpSession httpSession, TRId trId) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTabResourceOpenMap = (HashMap)httpSession.getAttribute("SCOPE_TO_CURRENT_TABULAR_RESOURCES_OPEN_MAP");
        if (scopeToTabResourceOpenMap == null) {
            logger.info("No open tr in session");
            return null;
        }
        ArrayList openList = (ArrayList)scopeToTabResourceOpenMap.get(aslSession.getScope());
        if (openList == null || openList.isEmpty()) {
            logger.info("No open tr in session");
        } else {
            logger.debug("Current Tabular Open In session: " + aslSession.getScope() + ", trList: " + openList);
            for (TabResource tabResource : openList) {
                if (tabResource == null || tabResource.getTrId() == null || tabResource.getTrId().getId().compareTo(trId.getId()) != 0) continue;
                return tabResource;
            }
        }
        return null;
    }

    public static void setTDOpenSession(HttpSession httpSession, TDOpenSession s) throws TDGWTSessionExpiredException {
        TDOpenSession session = (TDOpenSession)httpSession.getAttribute("TDOPEN_SESSION");
        if (session != null) {
            httpSession.removeAttribute("TDOPEN_SESSION");
        }
        httpSession.setAttribute("TDOPEN_SESSION", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static void retrieveResources(HttpSession httpSession) throws Exception {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static TabResource getSDMXImportTabResource(HttpSession httpSession) {
        TabResource tabResource = (TabResource)httpSession.getAttribute("SDMX_IMPORT_TABULAR_RESOURCE");
        if (tabResource == null) {
            logger.error("SDMX_IMPORT_TABULAR_RESOURCE was not acquired");
        }
        return tabResource;
    }

    public static void setSDMXImportTabResource(HttpSession httpSession, TabResource tabResource) throws TDGWTSessionExpiredException {
        TabResource t = (TabResource)httpSession.getAttribute("SDMX_IMPORT_TABULAR_RESOURCE");
        if (t != null) {
            httpSession.removeAttribute("SDMX_IMPORT_TABULAR_RESOURCE");
        }
        httpSession.setAttribute("SDMX_IMPORT_TABULAR_RESOURCE", (Object)tabResource);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static TabResource getCSVImportTabResource(HttpSession httpSession) {
        TabResource tabResource = (TabResource)httpSession.getAttribute("CSV_IMPORT_TABULAR_RESOURCE");
        if (tabResource == null) {
            logger.error("CSV_IMPORT_TABULAR_RESOURCE was not acquired");
        }
        return tabResource;
    }

    public static void setCSVImportTabResource(HttpSession httpSession, TabResource tabResource) throws TDGWTSessionExpiredException {
        TabResource t = (TabResource)httpSession.getAttribute("CSV_IMPORT_TABULAR_RESOURCE");
        if (t != null) {
            httpSession.removeAttribute("CSV_IMPORT_TABULAR_RESOURCE");
        }
        httpSession.setAttribute("CSV_IMPORT_TABULAR_RESOURCE", (Object)tabResource);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static void setSDMXImportSession(HttpSession httpSession, SDMXImportSession s) throws TDGWTSessionExpiredException {
        SDMXImportSession session = (SDMXImportSession)httpSession.getAttribute("SDMX_IMPORT");
        if (session != null) {
            httpSession.removeAttribute("SDMX_IMPORT");
        }
        httpSession.setAttribute("SDMX_IMPORT", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static SDMXImportSession getSDMXImportSession(HttpSession httpSession) {
        SDMXImportSession importSession = (SDMXImportSession)httpSession.getAttribute("SDMX_IMPORT");
        if (importSession == null) {
            logger.error("SDMXImportSession was not acquired");
        }
        return importSession;
    }

    public static void setCSVImportSession(HttpSession httpSession, CSVImportSession s) throws TDGWTSessionExpiredException {
        CSVImportSession session = (CSVImportSession)httpSession.getAttribute("CSV_IMPORT");
        if (session != null) {
            httpSession.removeAttribute("CSV_IMPORT");
        }
        httpSession.setAttribute("CSV_IMPORT", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static CSVImportSession getCSVImportSession(HttpSession httpSession) {
        CSVImportSession importSession = (CSVImportSession)httpSession.getAttribute("CSV_IMPORT");
        if (importSession == null) {
            logger.error("CSVImportSession was not acquired");
        }
        return importSession;
    }

    public static void setCSVExportSession(HttpSession httpSession, CSVExportSession s) throws TDGWTSessionExpiredException {
        CSVExportSession session = (CSVExportSession)httpSession.getAttribute("CSV_EXPORT_SESSION");
        if (session != null) {
            httpSession.removeAttribute("CSV_EXPORT_SESSION");
        }
        httpSession.setAttribute("CSV_EXPORT_SESSION", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static CSVExportSession getCSVExportSession(HttpSession httpSession) {
        CSVExportSession exportSession = (CSVExportSession)httpSession.getAttribute("CSV_EXPORT_SESSION");
        if (exportSession == null) {
            logger.error("CSVExportSession was not acquired");
        }
        return exportSession;
    }

    public static void setSDMXExportSession(HttpSession httpSession, SDMXExportSession s) throws TDGWTSessionExpiredException {
        SDMXExportSession session = (SDMXExportSession)httpSession.getAttribute("SDMX_EXPORT_SESSION");
        if (session != null) {
            httpSession.removeAttribute("SDMX_EXPORT_SESSION");
        }
        httpSession.setAttribute("SDMX_EXPORT_SESSION", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static SDMXExportSession getSDMXExportSession(HttpSession httpSession) {
        SDMXExportSession exportSession = (SDMXExportSession)httpSession.getAttribute("SDMX_EXPORT_SESSION");
        if (exportSession == null) {
            logger.error("SDMXExportSession was not acquired");
        }
        return exportSession;
    }

    public static void setJSONExportSession(HttpSession httpSession, JSONExportSession s) throws TDGWTSessionExpiredException {
        JSONExportSession session = (JSONExportSession)httpSession.getAttribute("JSON_EXPORT_SESSION");
        if (session != null) {
            httpSession.removeAttribute("JSON_EXPORT_SESSION");
        }
        httpSession.setAttribute("JSON_EXPORT_SESSION", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static JSONExportSession getJSONExportSession(HttpSession httpSession) {
        JSONExportSession exportSession = (JSONExportSession)httpSession.getAttribute("JSON_EXPORT_SESSION");
        if (exportSession == null) {
            logger.error("JSONExportSession was not acquired");
        }
        return exportSession;
    }

    public static void setCSVFileUploadSession(HttpSession httpSession, CSVFileUploadSession s) throws TDGWTSessionExpiredException {
        CSVFileUploadSession session = (CSVFileUploadSession)httpSession.getAttribute("CSV_IMPORT_FILE_UPLOAD");
        if (session != null) {
            httpSession.removeAttribute("CSV_IMPORT_FILE_UPLOAD");
        }
        httpSession.setAttribute("CSV_IMPORT_FILE_UPLOAD", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static CSVFileUploadSession getCSVFileUploadSession(HttpSession httpSession) {
        CSVFileUploadSession fileUploadSession = (CSVFileUploadSession)httpSession.getAttribute("CSV_IMPORT_FILE_UPLOAD");
        if (fileUploadSession == null) {
            logger.error("CSVFileUploadSession was not acquired");
        }
        return fileUploadSession;
    }

    public static void setCodelistMappingFileUploadSession(HttpSession httpSession, CodelistMappingFileUploadSession s) throws TDGWTSessionExpiredException {
        CodelistMappingFileUploadSession session = (CodelistMappingFileUploadSession)httpSession.getAttribute("CODELIST_MAPPING_FILE_UPLOAD_SESSION");
        if (session != null) {
            httpSession.removeAttribute("CODELIST_MAPPING_FILE_UPLOAD_SESSION");
        }
        httpSession.setAttribute("CODELIST_MAPPING_FILE_UPLOAD_SESSION", (Object)s);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static CodelistMappingFileUploadSession getCodelistMappingFileUploadSession(HttpSession httpSession) {
        CodelistMappingFileUploadSession fileUploadSession = (CodelistMappingFileUploadSession)httpSession.getAttribute("CODELIST_MAPPING_FILE_UPLOAD_SESSION");
        if (fileUploadSession == null) {
            logger.error("CodelistMappingFileUploadSession was not acquired");
        }
        return fileUploadSession;
    }

    public static ArrayList<Codelist> retrieveCodelists(HttpSession httpSession) throws Exception {
        logger.info("SessionUtil retriveCodelists");
        SDMXClient client = SessionUtil.getSdmxClient(httpSession);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
        return client.getAllCodelists();
    }

    public static ArrayList<Dataset> retrieveDatasets(HttpSession httpSession) throws Exception {
        logger.info("SessionUtil retriveDatasets");
        SDMXClient client = SessionUtil.getSdmxClient(httpSession);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
        return client.getAllDatasets();
    }

    public static ArrayList<Agencies> retrieveAgencies(HttpSession httpSession) throws Exception {
        logger.info("SessionUtil retriveAgencies");
        SDMXClient client = SessionUtil.getSdmxClient(httpSession);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
        return client.getAllAgencies();
    }

    public static void setSDMXRegistrySource(HttpSession httpSession, SDMXRegistrySource sdmxRegistrySource) throws TDGWTSessionExpiredException {
        SDMXRegistrySource source = (SDMXRegistrySource)httpSession.getAttribute("SDMX_REGISTRY_SOURCE");
        if (source != null) {
            httpSession.removeAttribute("SDMX_REGISTRY_SOURCE");
        }
        httpSession.setAttribute("SDMX_REGISTRY_SOURCE", (Object)sdmxRegistrySource);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static SDMXRegistrySource getSDMXRegistrySource(HttpSession httpSession) {
        SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource)httpSession.getAttribute("SDMX_REGISTRY_SOURCE");
        if (sdmxRegistrySource == null) {
            logger.error("SDMXRegistrySource was not acquired");
        }
        return sdmxRegistrySource;
    }

    public static SDMXClient getSdmxClient(HttpSession httpSession) {
        SDMXClient sdmxClient = (SDMXClient)httpSession.getAttribute("SDMX_CLIENT");
        SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource)httpSession.getAttribute("SDMX_REGISTRY_SOURCE");
        if (sdmxRegistrySource == null) {
            logger.error("SDMXRegistrySource was not acquired");
        } else {
            String url = sdmxRegistrySource.getUrl();
            if (url == null || url.isEmpty()) {
                if (sdmxClient == null) {
                    sdmxClient = new SDMXClient();
                } else if (sdmxClient.type.compareTo(SDMXClient.TYPE.ANOTHER) == 0) {
                    sdmxClient = new SDMXClient();
                }
            } else if (sdmxClient == null) {
                sdmxClient = new SDMXClient(url);
            } else if (sdmxClient.type.compareTo(SDMXClient.TYPE.INTERNAL) == 0) {
                sdmxClient = new SDMXClient(url);
            } else if (sdmxClient.url.compareTo(url) != 0) {
                sdmxClient = new SDMXClient(url);
            }
            httpSession.setAttribute("SDMX_CLIENT", (Object)sdmxClient);
        }
        return sdmxClient;
    }

    public static void setCSVExportEnd(HttpSession httpSession, Boolean end) {
        Boolean fin = (Boolean)httpSession.getAttribute("CSV_EXPORT_END");
        if (fin != null) {
            httpSession.removeAttribute("CSV_EXPORT_END");
        }
        httpSession.setAttribute("CSV_EXPORT_END", (Object)end);
    }

    public static Boolean getCSVExportEnd(HttpSession httpSession) {
        Boolean end = (Boolean)httpSession.getAttribute("CSV_EXPORT_END");
        logger.debug("getCSVExportEnd(): " + end);
        if (end == null) {
            logger.error("CSV_EXPORT_END was not acquired");
            end = false;
        }
        return end;
    }

    public static void setJSONExportEnd(HttpSession httpSession, Boolean end) {
        Boolean fin = (Boolean)httpSession.getAttribute("JSON_EXPORT_END");
        if (fin != null) {
            httpSession.removeAttribute("JSON_EXPORT_END");
        }
        httpSession.setAttribute("JSON_EXPORT_END", (Object)end);
    }

    public static Boolean getJSONExportEnd(HttpSession httpSession) {
        Boolean end = (Boolean)httpSession.getAttribute("JSON_EXPORT_END");
        logger.debug("getJSONExportEnd(): " + end);
        if (end == null) {
            logger.error("JSON_EXPORT_END was not acquired");
            end = false;
        }
        return end;
    }

    public static TRTasksManager getTRTasksManager(HttpSession httpSession) {
        TRTasksManager tasksManager = (TRTasksManager)httpSession.getAttribute("TR_TASK_MANAGER");
        if (tasksManager != null) {
            return tasksManager;
        }
        tasksManager = new TRTasksManager();
        httpSession.setAttribute("TR_TASK_MANAGER", (Object)tasksManager);
        return tasksManager;
    }

    public static void setTRTasksManager(HttpSession httpSession, TRTasksManager trTasksManager) {
        TRTasksManager tm = (TRTasksManager)httpSession.getAttribute("TR_TASK_MANAGER");
        if (tm != null) {
            httpSession.removeAttribute("TR_TASK_MANAGER");
        }
        httpSession.setAttribute("TR_TASK_MANAGER", (Object)trTasksManager);
    }

    public static ChangeColumnTypeSession getChangeColumnTypeSession(HttpSession httpSession) {
        ChangeColumnTypeSession changeColumnTypeSession = (ChangeColumnTypeSession)httpSession.getAttribute("CHANGE_COLUMN_TYPE_SESSION");
        if (changeColumnTypeSession != null) {
            return changeColumnTypeSession;
        }
        changeColumnTypeSession = new ChangeColumnTypeSession();
        httpSession.setAttribute("CHANGE_COLUMN_TYPE_SESSION", (Object)changeColumnTypeSession);
        return changeColumnTypeSession;
    }

    public static void setChangeColumnTypeSession(HttpSession httpSession, ChangeColumnTypeSession changeColumnTypeSession) {
        ChangeColumnTypeSession ct = (ChangeColumnTypeSession)httpSession.getAttribute("CHANGE_COLUMN_TYPE_SESSION");
        if (ct != null) {
            httpSession.removeAttribute("CHANGE_COLUMN_TYPE_SESSION");
        }
        httpSession.setAttribute("CHANGE_COLUMN_TYPE_SESSION", (Object)changeColumnTypeSession);
    }

    public static LabelColumnSession getLabelColumnSession(HttpSession httpSession) {
        LabelColumnSession labelColumnSession = (LabelColumnSession)httpSession.getAttribute("CHANGE_THE_COLUMN_LABEL_SESSION");
        if (labelColumnSession != null) {
            return labelColumnSession;
        }
        labelColumnSession = new LabelColumnSession();
        httpSession.setAttribute("CHANGE_THE_COLUMN_LABEL_SESSION", (Object)labelColumnSession);
        return labelColumnSession;
    }

    public static void setLabelColumnSession(HttpSession httpSession, LabelColumnSession labelColumnSession) {
        LabelColumnSession lc = (LabelColumnSession)httpSession.getAttribute("CHANGE_THE_COLUMN_LABEL_SESSION");
        if (lc != null) {
            httpSession.removeAttribute("CHANGE_THE_COLUMN_LABEL_SESSION");
        }
        httpSession.setAttribute("CHANGE_THE_COLUMN_LABEL_SESSION", (Object)labelColumnSession);
    }

    public static AddColumnSession getAddColumnSession(HttpSession httpSession) {
        AddColumnSession addColumnSession = (AddColumnSession)httpSession.getAttribute("ADD_COLUMN_SESSION");
        if (addColumnSession != null) {
            return addColumnSession;
        }
        addColumnSession = new AddColumnSession();
        httpSession.setAttribute("ADD_COLUMN_SESSION", (Object)addColumnSession);
        return addColumnSession;
    }

    public static void setAddColumnSession(HttpSession httpSession, AddColumnSession addColumnSession) {
        AddColumnSession ac = (AddColumnSession)httpSession.getAttribute("ADD_COLUMN_SESSION");
        if (ac != null) {
            httpSession.removeAttribute("ADD_COLUMN_SESSION");
        }
        httpSession.setAttribute("ADD_COLUMN_SESSION", (Object)addColumnSession);
    }

    public static DeleteColumnSession getDeleteColumnSession(HttpSession httpSession) {
        DeleteColumnSession deleteColumnSession = (DeleteColumnSession)httpSession.getAttribute("DELETE_COLUMN_SESSION");
        if (deleteColumnSession != null) {
            return deleteColumnSession;
        }
        deleteColumnSession = new DeleteColumnSession();
        httpSession.setAttribute("DELETE_COLUMN_SESSION", (Object)deleteColumnSession);
        return deleteColumnSession;
    }

    public static void setDeleteColumnSession(HttpSession httpSession, DeleteColumnSession deleteColumnSession) {
        DeleteColumnSession dc = (DeleteColumnSession)httpSession.getAttribute("DELETE_COLUMN_SESSION");
        if (dc != null) {
            httpSession.removeAttribute("DELETE_COLUMN_SESSION");
        }
        httpSession.setAttribute("DELETE_COLUMN_SESSION", (Object)deleteColumnSession);
    }

    public static FilterColumnSession getFilterColumnSession(HttpSession httpSession) {
        FilterColumnSession filterColumnSession = (FilterColumnSession)httpSession.getAttribute("FILTER_COLUMN_SESSION");
        if (filterColumnSession != null) {
            return filterColumnSession;
        }
        filterColumnSession = new FilterColumnSession();
        httpSession.setAttribute("FILTER_COLUMN_SESSION", (Object)filterColumnSession);
        return filterColumnSession;
    }

    public static void setFilterColumnSession(HttpSession httpSession, FilterColumnSession filterColumnSession) {
        FilterColumnSession fc = (FilterColumnSession)httpSession.getAttribute("FILTER_COLUMN_SESSION");
        if (fc != null) {
            httpSession.removeAttribute("FILTER_COLUMN_SESSION");
        }
        httpSession.setAttribute("FILTER_COLUMN_SESSION", (Object)filterColumnSession);
    }

    public static ReplaceColumnByExpressionSession getReplaceColumnByExpressionSession(HttpSession httpSession) {
        ReplaceColumnByExpressionSession replaceColumnByExpressionSession = (ReplaceColumnByExpressionSession)httpSession.getAttribute("REPLACE_COLUMN_BY_EXPRESSION_SESSION");
        if (replaceColumnByExpressionSession != null) {
            return replaceColumnByExpressionSession;
        }
        replaceColumnByExpressionSession = new ReplaceColumnByExpressionSession();
        httpSession.setAttribute("REPLACE_COLUMN_BY_EXPRESSION_SESSION", (Object)replaceColumnByExpressionSession);
        return replaceColumnByExpressionSession;
    }

    public static void setReplaceColumnByExpressionSession(HttpSession httpSession, ReplaceColumnByExpressionSession replaceColumnByExpressionSession) {
        ReplaceColumnByExpressionSession rce = (ReplaceColumnByExpressionSession)httpSession.getAttribute("REPLACE_COLUMN_BY_EXPRESSION_SESSION");
        if (rce != null) {
            httpSession.removeAttribute("REPLACE_COLUMN_BY_EXPRESSION_SESSION");
        }
        httpSession.setAttribute("REPLACE_COLUMN_BY_EXPRESSION_SESSION", (Object)replaceColumnByExpressionSession);
    }

    public static TaskResubmitSession getTaskResubmitSession(HttpSession httpSession) {
        TaskResubmitSession taskResubmitSession = (TaskResubmitSession)httpSession.getAttribute("TASK_RESUBMIT_SESSION");
        if (taskResubmitSession != null) {
            return taskResubmitSession;
        }
        taskResubmitSession = new TaskResubmitSession();
        httpSession.setAttribute("TASK_RESUBMIT_SESSION", (Object)taskResubmitSession);
        return taskResubmitSession;
    }

    public static void setTaskResubmitSession(HttpSession httpSession, TaskResubmitSession taskResubmitSession) {
        TaskResubmitSession tr = (TaskResubmitSession)httpSession.getAttribute("TASK_RESUBMIT_SESSION");
        if (tr != null) {
            httpSession.removeAttribute("TASK_RESUBMIT_SESSION");
        }
        httpSession.setAttribute("TASK_RESUBMIT_SESSION", (Object)taskResubmitSession);
    }

    public static TaskResumeSession getTaskResumeSession(HttpSession httpSession) {
        TaskResumeSession taskResumeSession = (TaskResumeSession)httpSession.getAttribute("TASK_RESUME_SESSION");
        if (taskResumeSession != null) {
            return taskResumeSession;
        }
        taskResumeSession = new TaskResumeSession();
        httpSession.setAttribute("TASK_RESUME_SESSION", (Object)taskResumeSession);
        return taskResumeSession;
    }

    public static void setTaskResumeSession(HttpSession httpSession, TaskResumeSession taskResumeSession) {
        TaskResumeSession tr = (TaskResumeSession)httpSession.getAttribute("TASK_RESUME_SESSION");
        if (tr != null) {
            httpSession.removeAttribute("TASK_RESUME_SESSION");
        }
        httpSession.setAttribute("TASK_RESUME_SESSION", (Object)taskResumeSession);
    }

    public static EditRowSession getEditRowSession(HttpSession httpSession) {
        EditRowSession editRowSession = (EditRowSession)httpSession.getAttribute("EDIT_ROW_SESSION");
        if (editRowSession != null) {
            return editRowSession;
        }
        editRowSession = new EditRowSession();
        httpSession.setAttribute("EDIT_ROW_SESSION", (Object)editRowSession);
        return editRowSession;
    }

    public static void setEditRowSession(HttpSession httpSession, EditRowSession editRowSession) {
        EditRowSession er = (EditRowSession)httpSession.getAttribute("EDIT_ROW_SESSION");
        if (er != null) {
            httpSession.removeAttribute("EDIT_ROW_SESSION");
        }
        httpSession.setAttribute("EDIT_ROW_SESSION", (Object)editRowSession);
    }

    public static ReplaceColumnSession getReplaceColumnSession(HttpSession httpSession) {
        ReplaceColumnSession replaceColumnSession = (ReplaceColumnSession)httpSession.getAttribute("REPLACE_COLUMN_SESSION");
        if (replaceColumnSession != null) {
            return replaceColumnSession;
        }
        replaceColumnSession = new ReplaceColumnSession();
        httpSession.setAttribute("REPLACE_COLUMN_SESSION", (Object)replaceColumnSession);
        return replaceColumnSession;
    }

    public static void setReplaceColumnSession(HttpSession httpSession, ReplaceColumnSession replaceColumnSession) {
        ReplaceColumnSession rc = (ReplaceColumnSession)httpSession.getAttribute("REPLACE_COLUMN_SESSION");
        if (rc != null) {
            httpSession.removeAttribute("REPLACE_COLUMN_SESSION");
        }
        httpSession.setAttribute("REPLACE_COLUMN_SESSION", (Object)replaceColumnSession);
    }

    public static ReplaceBatchColumnSession getReplaceBatchColumnSession(HttpSession httpSession) {
        ReplaceBatchColumnSession replaceBatchColumnSession = (ReplaceBatchColumnSession)httpSession.getAttribute("REPLACE_BATCH_COLUMN_SESSION");
        if (replaceBatchColumnSession != null) {
            return replaceBatchColumnSession;
        }
        replaceBatchColumnSession = new ReplaceBatchColumnSession();
        httpSession.setAttribute("REPLACE_BATCH_COLUMN_SESSION", (Object)replaceBatchColumnSession);
        return replaceBatchColumnSession;
    }

    public static void setReplaceBatchColumnSession(HttpSession httpSession, ReplaceBatchColumnSession replaceBatchColumnSession) {
        ReplaceBatchColumnSession rbc = (ReplaceBatchColumnSession)httpSession.getAttribute("REPLACE_BATCH_COLUMN_SESSION");
        if (rbc != null) {
            httpSession.removeAttribute("REPLACE_BATCH_COLUMN_SESSION");
        }
        httpSession.setAttribute("REPLACE_BATCH_COLUMN_SESSION", (Object)replaceBatchColumnSession);
    }

    public static ChangeTableTypeSession getChangeTableTypeSession(HttpSession httpSession) {
        ChangeTableTypeSession changeTableTypeSession = (ChangeTableTypeSession)httpSession.getAttribute("CHANGE_TABLE_TYPE_SESSION");
        if (changeTableTypeSession != null) {
            return changeTableTypeSession;
        }
        changeTableTypeSession = new ChangeTableTypeSession();
        httpSession.setAttribute("CHANGE_TABLE_TYPE_SESSION", (Object)changeTableTypeSession);
        return changeTableTypeSession;
    }

    public static void setChangeTableTypeSession(HttpSession httpSession, ChangeTableTypeSession changeTableTypeSession) {
        ChangeTableTypeSession ctts = (ChangeTableTypeSession)httpSession.getAttribute("CHANGE_TABLE_TYPE_SESSION");
        if (ctts != null) {
            httpSession.removeAttribute("CHANGE_TABLE_TYPE_SESSION");
        }
        httpSession.setAttribute("CHANGE_TABLE_TYPE_SESSION", (Object)changeTableTypeSession);
    }

    public static CloneTabularResourceSession getCloneTabularResourceSession(HttpSession httpSession) {
        CloneTabularResourceSession cloneTabularResourceSession = (CloneTabularResourceSession)httpSession.getAttribute("CLONE_TABULAR_RESOURCE_SESSION");
        if (cloneTabularResourceSession != null) {
            return cloneTabularResourceSession;
        }
        cloneTabularResourceSession = new CloneTabularResourceSession();
        httpSession.setAttribute("CLONE_TABULAR_RESOURCE_SESSION", (Object)cloneTabularResourceSession);
        return cloneTabularResourceSession;
    }

    public static void setCloneTabularResourceSession(HttpSession httpSession, CloneTabularResourceSession cloneTabularResourceSession) {
        CloneTabularResourceSession c = (CloneTabularResourceSession)httpSession.getAttribute("CLONE_TABULAR_RESOURCE_SESSION");
        if (c != null) {
            httpSession.removeAttribute("CLONE_TABULAR_RESOURCE_SESSION");
        }
        httpSession.setAttribute("CLONE_TABULAR_RESOURCE_SESSION", (Object)cloneTabularResourceSession);
    }

    public static DeleteRowsSession getDeleteRowsSession(HttpSession httpSession) {
        DeleteRowsSession deleteRowsSession = (DeleteRowsSession)httpSession.getAttribute("DELETE_ROWS_SESSION");
        if (deleteRowsSession != null) {
            return deleteRowsSession;
        }
        deleteRowsSession = new DeleteRowsSession();
        httpSession.setAttribute("DELETE_ROWS_SESSION", (Object)deleteRowsSession);
        return deleteRowsSession;
    }

    public static void setDeleteRowsSession(HttpSession httpSession, DeleteRowsSession deleteRowsSession) {
        DeleteRowsSession dr = (DeleteRowsSession)httpSession.getAttribute("DELETE_ROWS_SESSION");
        if (dr != null) {
            httpSession.removeAttribute("DELETE_ROWS_SESSION");
        }
        httpSession.setAttribute("DELETE_ROWS_SESSION", (Object)deleteRowsSession);
    }

    public static TemplateApplySession getTemplateApplySession(HttpSession httpSession) {
        TemplateApplySession templateApplySession = (TemplateApplySession)httpSession.getAttribute("TEMPLATE_APPLY_SESSION");
        if (templateApplySession != null) {
            return templateApplySession;
        }
        templateApplySession = new TemplateApplySession();
        httpSession.setAttribute("TEMPLATE_APPLY_SESSION", (Object)templateApplySession);
        return templateApplySession;
    }

    public static void setTemplateApplySession(HttpSession httpSession, TemplateApplySession templateApplySession) {
        TemplateApplySession dr = (TemplateApplySession)httpSession.getAttribute("TEMPLATE_APPLY_SESSION");
        if (dr != null) {
            httpSession.removeAttribute("TEMPLATE_APPLY_SESSION");
        }
        httpSession.setAttribute("TEMPLATE_APPLY_SESSION", (Object)templateApplySession);
    }

    public static DuplicatesSession getDuplicatesSession(HttpSession httpSession) {
        DuplicatesSession duplicatesSession = (DuplicatesSession)httpSession.getAttribute("DUPLICATES_ROWS_SESSION");
        if (duplicatesSession != null) {
            return duplicatesSession;
        }
        duplicatesSession = new DuplicatesSession();
        httpSession.setAttribute("DUPLICATES_ROWS_SESSION", (Object)duplicatesSession);
        return duplicatesSession;
    }

    public static void setDuplicatesSession(HttpSession httpSession, DuplicatesSession duplicatesSession) {
        DuplicatesSession dr = (DuplicatesSession)httpSession.getAttribute("DUPLICATES_ROWS_SESSION");
        if (dr != null) {
            httpSession.removeAttribute("DUPLICATES_ROWS_SESSION");
        }
        httpSession.setAttribute("DUPLICATES_ROWS_SESSION", (Object)duplicatesSession);
    }

    public static ArrayList<TabResource> getCodelistsPagingLoaded(HttpSession httpSession) {
        ArrayList ltr = (ArrayList)httpSession.getAttribute("CODELISTS_PAGING_LOADED");
        if (ltr == null) {
            logger.error("CODELISTS_PAGING_LOADED was not acquired");
        }
        return ltr;
    }

    public static void setCodelistsPagingLoaded(HttpSession httpSession, ArrayList<TabResource> listCodelists) {
        ArrayList ltr = (ArrayList)httpSession.getAttribute("CODELISTS_PAGING_LOADED");
        if (ltr != null) {
            httpSession.removeAttribute("CODELISTS_PAGING_LOADED");
        }
        httpSession.setAttribute("CODELISTS_PAGING_LOADED", listCodelists);
    }

    public static ArrayList<TabResource> getCodelistsPagingLoadedFilteredCopy(HttpSession httpSession) {
        ArrayList ltrFilteredCopy = (ArrayList)httpSession.getAttribute("CODELISTS_PAGING_LOADED_FILTERED_COPY");
        if (ltrFilteredCopy == null) {
            logger.error("CODELISTS_PAGING_LOADED_FILTERED_COPY was not acquired");
        }
        return ltrFilteredCopy;
    }

    public static void setCodelistsPagingLoadedFilteredCopy(HttpSession httpSession, ArrayList<TabResource> listCodelistsFilteredCopy) {
        ArrayList ltrFilteredCopy = (ArrayList)httpSession.getAttribute("CODELISTS_PAGING_LOADED_FILTERED_COPY");
        if (ltrFilteredCopy != null) {
            httpSession.removeAttribute("CODELISTS_PAGING_LOADED_FILTERED_COPY");
        }
        httpSession.setAttribute("CODELISTS_PAGING_LOADED_FILTERED_COPY", listCodelistsFilteredCopy);
    }

    public static String getCodelistsPagingLoadedFilter(HttpSession httpSession) {
        String filter = (String)httpSession.getAttribute("CODELISTS_PAGING_LOADED_FILTER");
        if (filter == null) {
            logger.error("CODELISTS_PAGING_LOADED_FILTER was not acquired");
        }
        return filter;
    }

    public static void setCodelistsPagingLoadedFilter(HttpSession httpSession, String filter) {
        String fil = (String)httpSession.getAttribute("CODELISTS_PAGING_LOADED_FILTER");
        if (fil != null) {
            httpSession.removeAttribute("CODELISTS_PAGING_LOADED_FILTER");
        }
        httpSession.setAttribute("CODELISTS_PAGING_LOADED_FILTER", (Object)filter);
    }

    public static RollBackSession getRollBackSession(HttpSession httpSession) {
        RollBackSession rollBackSession = (RollBackSession)httpSession.getAttribute("ROLLBACK_SESSION");
        if (rollBackSession != null) {
            return rollBackSession;
        }
        rollBackSession = new RollBackSession();
        httpSession.setAttribute("ROLLBACK_SESSION", (Object)rollBackSession);
        return rollBackSession;
    }

    public static void setRollBackSession(HttpSession httpSession, RollBackSession rollBackSession) {
        RollBackSession rb = (RollBackSession)httpSession.getAttribute("ROLLBACK_SESSION");
        if (rb != null) {
            httpSession.removeAttribute("ROLLBACK_SESSION");
        }
        httpSession.setAttribute("ROLLBACK_SESSION", (Object)rollBackSession);
    }

    public static ExtractCodelistSession getExtractCodelistSession(HttpSession httpSession) {
        ExtractCodelistSession extractCodelistSession = (ExtractCodelistSession)httpSession.getAttribute("EXTRACT_CODELIST_SESSION");
        if (extractCodelistSession != null) {
            return extractCodelistSession;
        }
        extractCodelistSession = new ExtractCodelistSession();
        httpSession.setAttribute("EXTRACT_CODELIST_SESSION", (Object)extractCodelistSession);
        return extractCodelistSession;
    }

    public static void setExtractCodelistSession(HttpSession httpSession, ExtractCodelistSession extractCodelistSession) {
        ExtractCodelistSession ec = (ExtractCodelistSession)httpSession.getAttribute("EXTRACT_CODELIST_SESSION");
        if (ec != null) {
            httpSession.removeAttribute("EXTRACT_CODELIST_SESSION");
        }
        httpSession.setAttribute("EXTRACT_CODELIST_SESSION", (Object)extractCodelistSession);
    }

    public static SplitColumnSession getSplitColumnSession(HttpSession httpSession) {
        SplitColumnSession splitColumnSession = (SplitColumnSession)httpSession.getAttribute("SPLIT_COLUMN_SESSION");
        if (splitColumnSession != null) {
            return splitColumnSession;
        }
        splitColumnSession = new SplitColumnSession();
        httpSession.setAttribute("SPLIT_COLUMN_SESSION", (Object)splitColumnSession);
        return splitColumnSession;
    }

    public static void setSplitColumnSession(HttpSession httpSession, SplitColumnSession splitColumnSession) {
        SplitColumnSession sc = (SplitColumnSession)httpSession.getAttribute("SPLIT_COLUMN_SESSION");
        if (sc != null) {
            httpSession.removeAttribute("SPLIT_COLUMN_SESSION");
        }
        httpSession.setAttribute("SPLIT_COLUMN_SESSION", (Object)splitColumnSession);
    }

    public static MergeColumnSession getMergeColumnSession(HttpSession httpSession) {
        MergeColumnSession mergeColumnSession = (MergeColumnSession)httpSession.getAttribute("MERGE_COLUMN_SESSION");
        if (mergeColumnSession != null) {
            return mergeColumnSession;
        }
        mergeColumnSession = new MergeColumnSession();
        httpSession.setAttribute("MERGE_COLUMN_SESSION", (Object)mergeColumnSession);
        return mergeColumnSession;
    }

    public static void setMergeColumnSession(HttpSession httpSession, MergeColumnSession splitColumnSession) {
        MergeColumnSession mc = (MergeColumnSession)httpSession.getAttribute("MERGE_COLUMN_SESSION");
        if (mc != null) {
            httpSession.removeAttribute("MERGE_COLUMN_SESSION");
        }
        httpSession.setAttribute("MERGE_COLUMN_SESSION", (Object)splitColumnSession);
    }

    public static GroupBySession getGroupBySession(HttpSession httpSession) {
        GroupBySession groupBySession = (GroupBySession)httpSession.getAttribute("GROUPBY_SESSION");
        if (groupBySession != null) {
            return groupBySession;
        }
        groupBySession = new GroupBySession();
        httpSession.setAttribute("GROUPBY_SESSION", (Object)groupBySession);
        return groupBySession;
    }

    public static void setGroupBySession(HttpSession httpSession, GroupBySession groupBySession) {
        GroupBySession gb = (GroupBySession)httpSession.getAttribute("GROUPBY_SESSION");
        if (gb != null) {
            httpSession.removeAttribute("GROUPBY_SESSION");
        }
        httpSession.setAttribute("GROUPBY_SESSION", (Object)groupBySession);
    }

    public static TimeAggregationSession getTimeAggregationSession(HttpSession httpSession) {
        TimeAggregationSession timeAggregationSession = (TimeAggregationSession)httpSession.getAttribute("TIME_AGGREGATION_SESSION");
        if (timeAggregationSession != null) {
            return timeAggregationSession;
        }
        timeAggregationSession = new TimeAggregationSession();
        httpSession.setAttribute("TIME_AGGREGATION_SESSION", (Object)timeAggregationSession);
        return timeAggregationSession;
    }

    public static void setTimeAggregationSession(HttpSession httpSession, TimeAggregationSession timeAggregationSession) {
        TimeAggregationSession timeAggr = (TimeAggregationSession)httpSession.getAttribute("TIME_AGGREGATION_SESSION");
        if (timeAggr != null) {
            httpSession.removeAttribute("TIME_AGGREGATION_SESSION");
        }
        httpSession.setAttribute("TIME_AGGREGATION_SESSION", (Object)timeAggregationSession);
    }

    public static CodelistMappingSession getCodelistMappingSession(HttpSession httpSession) {
        CodelistMappingSession importSession = (CodelistMappingSession)httpSession.getAttribute("CODELIST_MAPPING_SESSION");
        if (importSession == null) {
            logger.error("CSVImportSession was not acquired");
        }
        return importSession;
    }

    public static void setCodelistMappingSession(HttpSession httpSession, CodelistMappingSession codelistMappingSession) throws TDGWTSessionExpiredException {
        CodelistMappingSession session = (CodelistMappingSession)httpSession.getAttribute("CODELIST_MAPPING_SESSION");
        if (session != null) {
            httpSession.removeAttribute("CODELIST_MAPPING_SESSION");
        }
        httpSession.setAttribute("CODELIST_MAPPING_SESSION", (Object)codelistMappingSession);
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope().toString());
    }

    public static NormalizationSession getNormalizationSession(HttpSession httpSession) {
        NormalizationSession normalizationSession = (NormalizationSession)httpSession.getAttribute("NORMALIZATION_SESSION");
        if (normalizationSession != null) {
            return normalizationSession;
        }
        normalizationSession = new NormalizationSession();
        httpSession.setAttribute("NORMALIZATION_SESSION", (Object)normalizationSession);
        return normalizationSession;
    }

    public static void setNormalizationSession(HttpSession httpSession, NormalizationSession normalizationSession) {
        NormalizationSession gb = (NormalizationSession)httpSession.getAttribute("NORMALIZATION_SESSION");
        if (gb != null) {
            httpSession.removeAttribute("NORMALIZATION_SESSION");
        }
        httpSession.setAttribute("NORMALIZATION_SESSION", (Object)normalizationSession);
    }

    public static DenormalizationSession getDenormalizationSession(HttpSession httpSession) {
        DenormalizationSession denormalizationSession = (DenormalizationSession)httpSession.getAttribute("DENORMALIZATION_SESSION");
        if (denormalizationSession != null) {
            return denormalizationSession;
        }
        denormalizationSession = new DenormalizationSession();
        httpSession.setAttribute("DENORMALIZATION_SESSION", (Object)denormalizationSession);
        return denormalizationSession;
    }

    public static void setDenormalizationSession(HttpSession httpSession, DenormalizationSession denormalizationSession) {
        DenormalizationSession dn = (DenormalizationSession)httpSession.getAttribute("DENORMALIZATION_SESSION");
        if (dn != null) {
            httpSession.removeAttribute("DENORMALIZATION_SESSION");
        }
        httpSession.setAttribute("DENORMALIZATION_SESSION", (Object)denormalizationSession);
    }

    public static UnionSession getUnionSession(HttpSession httpSession) {
        UnionSession unionSession = (UnionSession)httpSession.getAttribute("UNION_SESSION");
        if (unionSession != null) {
            return unionSession;
        }
        unionSession = new UnionSession();
        httpSession.setAttribute("UNION_SESSION", (Object)unionSession);
        return unionSession;
    }

    public static void setUnionSession(HttpSession httpSession, UnionSession unionSession) {
        UnionSession us = (UnionSession)httpSession.getAttribute("UNION_SESSION");
        if (us != null) {
            httpSession.removeAttribute("UNION_SESSION");
        }
        httpSession.setAttribute("UNION_SESSION", (Object)unionSession);
    }

    public static ChangeColumnsPositionSession getChangeColumnsPositionSession(HttpSession httpSession) {
        ChangeColumnsPositionSession changeColumnsPositionSession = (ChangeColumnsPositionSession)httpSession.getAttribute("CHANGE_COLUMNS_POSITION_SESSION");
        if (changeColumnsPositionSession != null) {
            return changeColumnsPositionSession;
        }
        changeColumnsPositionSession = new ChangeColumnsPositionSession();
        httpSession.setAttribute("CHANGE_COLUMNS_POSITION_SESSION", (Object)changeColumnsPositionSession);
        return changeColumnsPositionSession;
    }

    public static void setChangeColumnsPositionSession(HttpSession httpSession, ChangeColumnsPositionSession changeColumnsPositionSession) {
        ChangeColumnsPositionSession ccps = (ChangeColumnsPositionSession)httpSession.getAttribute("CHANGE_COLUMNS_POSITION_SESSION");
        if (ccps != null) {
            httpSession.removeAttribute("CHANGE_COLUMNS_POSITION_SESSION");
        }
        httpSession.setAttribute("CHANGE_COLUMNS_POSITION_SESSION", (Object)changeColumnsPositionSession);
    }

    public static ReplaceByExternalSession getReplaceByExternalSession(HttpSession httpSession) {
        ReplaceByExternalSession replaceByExternalSession = (ReplaceByExternalSession)httpSession.getAttribute("REPLACE_BY_EXTERNAL_SESSION");
        if (replaceByExternalSession != null) {
            return replaceByExternalSession;
        }
        replaceByExternalSession = new ReplaceByExternalSession();
        httpSession.setAttribute("REPLACE_BY_EXTERNAL_SESSION", (Object)replaceByExternalSession);
        return replaceByExternalSession;
    }

    public static void setReplaceByExternalSession(HttpSession httpSession, ReplaceByExternalSession replaceByExternalSession) {
        ReplaceByExternalSession re = (ReplaceByExternalSession)httpSession.getAttribute("REPLACE_BY_EXTERNAL_SESSION");
        if (re != null) {
            httpSession.removeAttribute("REPLACE_BY_EXTERNAL_SESSION");
        }
        httpSession.setAttribute("REPLACE_BY_EXTERNAL_SESSION", (Object)replaceByExternalSession);
    }

    public static StatisticalOperationSession getStatisticalOperationSession(HttpSession httpSession) {
        StatisticalOperationSession statisticalOperationSession = (StatisticalOperationSession)httpSession.getAttribute("STATISTICAL_OPERATION_SESSION");
        if (statisticalOperationSession != null) {
            return statisticalOperationSession;
        }
        statisticalOperationSession = new StatisticalOperationSession();
        httpSession.setAttribute("STATISTICAL_OPERATION_SESSION", (Object)statisticalOperationSession);
        return statisticalOperationSession;
    }

    public static void setStatisticalOperationSession(HttpSession httpSession, StatisticalOperationSession statisticalOperationSession) {
        StatisticalOperationSession so = (StatisticalOperationSession)httpSession.getAttribute("STATISTICAL_OPERATION_SESSION");
        if (so != null) {
            httpSession.removeAttribute("STATISTICAL_OPERATION_SESSION");
        }
        httpSession.setAttribute("STATISTICAL_OPERATION_SESSION", (Object)statisticalOperationSession);
    }

    public static MapCreationSession getMapCreationSession(HttpSession httpSession) {
        MapCreationSession mapCreationSession = (MapCreationSession)httpSession.getAttribute("MAP_CREATION_SESSION");
        if (mapCreationSession != null) {
            return mapCreationSession;
        }
        mapCreationSession = new MapCreationSession();
        httpSession.setAttribute("MAP_CREATION_SESSION", (Object)mapCreationSession);
        return mapCreationSession;
    }

    public static void setMapCreationSession(HttpSession httpSession, MapCreationSession mapCreationSession) {
        MapCreationSession mapC = (MapCreationSession)httpSession.getAttribute("MAP_CREATION_SESSION");
        if (mapC != null) {
            httpSession.removeAttribute("MAP_CREATION_SESSION");
        }
        httpSession.setAttribute("MAP_CREATION_SESSION", (Object)mapCreationSession);
    }

    public static ChartTopRatingSession getChartTopRatingSession(HttpSession httpSession) {
        ChartTopRatingSession chartTopRatingSession = (ChartTopRatingSession)httpSession.getAttribute("CHART_TOPRATING_SESSION");
        if (chartTopRatingSession != null) {
            return chartTopRatingSession;
        }
        chartTopRatingSession = new ChartTopRatingSession();
        httpSession.setAttribute("CHART_TOPRATING_SESSION", (Object)chartTopRatingSession);
        return chartTopRatingSession;
    }

    public static void setChartTopRatingSession(HttpSession httpSession, ChartTopRatingSession chartTopRatingSession) {
        ChartTopRatingSession chart = (ChartTopRatingSession)httpSession.getAttribute("CHART_TOPRATING_SESSION");
        if (chart != null) {
            httpSession.removeAttribute("CHART_TOPRATING_SESSION");
        }
        httpSession.setAttribute("CHART_TOPRATING_SESSION", (Object)chartTopRatingSession);
    }

    public static GeospatialCreateCoordinatesSession getGeospatialCreateCoordinatesSession(HttpSession httpSession) {
        GeospatialCreateCoordinatesSession geospatialCreateCoordinatesSession = (GeospatialCreateCoordinatesSession)httpSession.getAttribute("GEOSPATIAL_CREATE_COORDINATES_SESSION");
        if (geospatialCreateCoordinatesSession != null) {
            return geospatialCreateCoordinatesSession;
        }
        geospatialCreateCoordinatesSession = new GeospatialCreateCoordinatesSession();
        httpSession.setAttribute("GEOSPATIAL_CREATE_COORDINATES_SESSION", (Object)geospatialCreateCoordinatesSession);
        return geospatialCreateCoordinatesSession;
    }

    public static void setGeospatialCreateCoordinatesSession(HttpSession httpSession, GeospatialCreateCoordinatesSession geospatialCreateCoordinateSession) {
        GeospatialCreateCoordinatesSession sc = (GeospatialCreateCoordinatesSession)httpSession.getAttribute("GEOSPATIAL_CREATE_COORDINATES_SESSION");
        if (sc != null) {
            httpSession.removeAttribute("GEOSPATIAL_CREATE_COORDINATES_SESSION");
        }
        httpSession.setAttribute("GEOSPATIAL_CREATE_COORDINATES_SESSION", (Object)geospatialCreateCoordinateSession);
    }

    public static GeospatialDownscaleCSquareSession getGeospatialDownscaleCSquareSession(HttpSession httpSession) {
        GeospatialDownscaleCSquareSession geospatialDownscaleCSquareSession = (GeospatialDownscaleCSquareSession)httpSession.getAttribute("GEOSPATIAL_DOWNSCALE_CSQUARE_SESSION");
        if (geospatialDownscaleCSquareSession != null) {
            return geospatialDownscaleCSquareSession;
        }
        geospatialDownscaleCSquareSession = new GeospatialDownscaleCSquareSession();
        httpSession.setAttribute("GEOSPATIAL_DOWNSCALE_CSQUARE_SESSION", (Object)geospatialDownscaleCSquareSession);
        return geospatialDownscaleCSquareSession;
    }

    public static void setGeospatialDownscaleCSquareSession(HttpSession httpSession, GeospatialDownscaleCSquareSession geospatialDownscaleCSquareSession) {
        GeospatialDownscaleCSquareSession sc = (GeospatialDownscaleCSquareSession)httpSession.getAttribute("GEOSPATIAL_DOWNSCALE_CSQUARE_SESSION");
        if (sc != null) {
            httpSession.removeAttribute("GEOSPATIAL_DOWNSCALE_CSQUARE_SESSION");
        }
        httpSession.setAttribute("GEOSPATIAL_DOWNSCALE_CSQUARE_SESSION", (Object)geospatialDownscaleCSquareSession);
    }

    public static GeometryCreatePointSession getGeometryCreatePointSession(HttpSession httpSession) {
        GeometryCreatePointSession geometryCreatePointSession = (GeometryCreatePointSession)httpSession.getAttribute("GEOMETRY_CREATE_POINT_SESSION");
        if (geometryCreatePointSession != null) {
            return geometryCreatePointSession;
        }
        geometryCreatePointSession = new GeometryCreatePointSession();
        httpSession.setAttribute("GEOMETRY_CREATE_POINT_SESSION", (Object)geometryCreatePointSession);
        return geometryCreatePointSession;
    }

    public static void setGeometryCreatePointSession(HttpSession httpSession, GeometryCreatePointSession geometryCreatePointSession) {
        GeometryCreatePointSession geom = (GeometryCreatePointSession)httpSession.getAttribute("GEOMETRY_CREATE_POINT_SESSION");
        if (geom != null) {
            httpSession.removeAttribute("GEOMETRY_CREATE_POINT_SESSION");
        }
        httpSession.setAttribute("GEOMETRY_CREATE_POINT_SESSION", (Object)geometryCreatePointSession);
    }

    public static TaskWrapper getStartedTask(HttpSession httpSession, String taskId) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        TaskWrapper taskWrapper = null;
        if (taskId == null || taskId.isEmpty()) {
            logger.error("TaskId is not valid: " + taskId);
        } else {
            HashMap scopeToTasksStartedMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP");
            if (scopeToTasksStartedMap == null) {
                logger.debug("Task with id=" + taskId + " was not acquired");
            } else {
                HashMap tasksStarted = (HashMap)scopeToTasksStartedMap.get(aslSession.getScope());
                if (tasksStarted == null) {
                    logger.debug("Task with id=" + taskId + " was not acquired");
                } else {
                    taskWrapper = (TaskWrapper)tasksStarted.get(taskId);
                    if (taskWrapper == null) {
                        logger.debug("Task with id=" + taskId + " was not acquired");
                    }
                }
            }
        }
        return taskWrapper;
    }

    public static void removeStartedTask(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id");
            return;
        }
        HashMap scopeToTasksStartedMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP");
        if (scopeToTasksStartedMap == null) {
            logger.debug("TaskWrapper was not acquired: " + taskWrapper);
        } else {
            HashMap tasksStarted = (HashMap)scopeToTasksStartedMap.get(aslSession.getScope());
            if (tasksStarted == null) {
                logger.debug("TaskWrapper was not acquired: " + taskWrapper);
            } else {
                tasksStarted.remove(taskWrapper.getTask().getId().getValue());
                scopeToTasksStartedMap.put(aslSession.getScope(), tasksStarted);
                httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP");
                httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP", (Object)scopeToTasksStartedMap);
            }
        }
    }

    public static void setStartedTask(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id");
            return;
        }
        HashMap scopeToTasksStartedMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP");
        if (scopeToTasksStartedMap == null) {
            scopeToTasksStartedMap = new HashMap();
            HashMap<String, TaskWrapper> tasksStarted = new HashMap<String, TaskWrapper>();
            tasksStarted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
            scopeToTasksStartedMap.put(aslSession.getScope(), tasksStarted);
        } else {
            HashMap<String, TaskWrapper> tasksStarted = (HashMap<String, TaskWrapper>)scopeToTasksStartedMap.get(aslSession.getScope());
            if (tasksStarted == null) {
                tasksStarted = new HashMap<String, TaskWrapper>();
                tasksStarted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksStartedMap.put(aslSession.getScope(), tasksStarted);
            } else {
                tasksStarted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksStartedMap.put(aslSession.getScope(), tasksStarted);
            }
            httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_STARTED_MAP", scopeToTasksStartedMap);
    }

    public static HashMap<String, TaskWrapper> getAbortedTaskMap(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTasksAbortedMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_ABORTED_MAP");
        if (scopeToTasksAbortedMap == null) {
            return null;
        }
        HashMap tasksAborted = (HashMap)scopeToTasksAbortedMap.get(aslSession.getScope());
        return tasksAborted;
    }

    public static void setAbortedTasks(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask() == null || taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id: " + taskWrapper);
            return;
        }
        HashMap scopeToTasksAbortedMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_ABORTED_MAP");
        if (scopeToTasksAbortedMap == null) {
            scopeToTasksAbortedMap = new HashMap();
            HashMap<String, TaskWrapper> tasksAborted = new HashMap<String, TaskWrapper>();
            tasksAborted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
            scopeToTasksAbortedMap.put(aslSession.getScope(), tasksAborted);
        } else {
            HashMap<String, TaskWrapper> tasksAborted = (HashMap<String, TaskWrapper>)scopeToTasksAbortedMap.get(aslSession.getScope());
            if (tasksAborted == null) {
                tasksAborted = new HashMap<String, TaskWrapper>();
                tasksAborted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksAbortedMap.put(aslSession.getScope(), tasksAborted);
            } else {
                tasksAborted.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksAbortedMap.put(aslSession.getScope(), tasksAborted);
            }
            httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_ABORTED_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_ABORTED_MAP", scopeToTasksAbortedMap);
    }

    public static HashMap<String, TaskWrapper> getHiddenTaskMap(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToHiddenTasksMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_HIDDEN_MAP");
        if (scopeToHiddenTasksMap == null) {
            return null;
        }
        HashMap hiddenTasks = (HashMap)scopeToHiddenTasksMap.get(aslSession.getScope());
        return hiddenTasks;
    }

    public static void setHiddenTask(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask() == null || taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id: " + taskWrapper);
            return;
        }
        HashMap scopeToHiddenTasksMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_HIDDEN_MAP");
        if (scopeToHiddenTasksMap == null) {
            scopeToHiddenTasksMap = new HashMap();
            HashMap<String, TaskWrapper> hiddenTasks = new HashMap<String, TaskWrapper>();
            hiddenTasks.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
            scopeToHiddenTasksMap.put(aslSession.getScope(), hiddenTasks);
        } else {
            HashMap<String, TaskWrapper> hiddenTasks = (HashMap<String, TaskWrapper>)scopeToHiddenTasksMap.get(aslSession.getScope());
            if (hiddenTasks == null) {
                hiddenTasks = new HashMap<String, TaskWrapper>();
                hiddenTasks.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToHiddenTasksMap.put(aslSession.getScope(), hiddenTasks);
            } else {
                hiddenTasks.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToHiddenTasksMap.put(aslSession.getScope(), hiddenTasks);
            }
            httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_HIDDEN_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_HIDDEN_MAP", scopeToHiddenTasksMap);
    }

    public static HashMap<String, TaskWrapper> getTaskInBackgroundMap(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTasksInBackgroundMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        if (scopeToTasksInBackgroundMap == null) {
            return null;
        }
        HashMap tasksInBackground = (HashMap)scopeToTasksInBackgroundMap.get(aslSession.getScope());
        return tasksInBackground;
    }

    public static void setTaskInBackground(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask() == null || taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id: " + taskWrapper);
            return;
        }
        HashMap scopeToTasksInBackgroundMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        if (scopeToTasksInBackgroundMap == null) {
            scopeToTasksInBackgroundMap = new HashMap();
            HashMap<String, TaskWrapper> tasksInBackground = new HashMap<String, TaskWrapper>();
            tasksInBackground.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
            scopeToTasksInBackgroundMap.put(aslSession.getScope(), tasksInBackground);
        } else {
            HashMap<String, TaskWrapper> tasksInBackground = (HashMap<String, TaskWrapper>)scopeToTasksInBackgroundMap.get(aslSession.getScope());
            if (tasksInBackground == null) {
                tasksInBackground = new HashMap<String, TaskWrapper>();
                tasksInBackground.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksInBackgroundMap.put(aslSession.getScope(), tasksInBackground);
            } else {
                tasksInBackground.put(taskWrapper.getTask().getId().getValue(), taskWrapper);
                scopeToTasksInBackgroundMap.put(aslSession.getScope(), tasksInBackground);
            }
            httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        }
        httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP", scopeToTasksInBackgroundMap);
    }

    public static void removeTaskInBackground(HttpSession httpSession, TaskWrapper taskWrapper) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (taskWrapper == null) {
            logger.error("TaskWrapper is null");
            return;
        }
        if (taskWrapper.getTask() == null || taskWrapper.getTask().getId() == null || taskWrapper.getTask().getId().getValue() == null || taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.error("TaskWrapper contains Task with invalid task id: " + taskWrapper);
            return;
        }
        HashMap scopeToTasksInBackgroundMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        if (scopeToTasksInBackgroundMap == null) {
            logger.debug("TaskWrapper was not acquired: " + taskWrapper);
        } else {
            HashMap tasksInBackground = (HashMap)scopeToTasksInBackgroundMap.get(aslSession.getScope());
            if (tasksInBackground == null) {
                logger.debug("TaskWrapper was not acquired: " + taskWrapper);
            } else {
                tasksInBackground.remove(taskWrapper.getTask().getId().getValue());
                scopeToTasksInBackgroundMap.put(aslSession.getScope(), tasksInBackground);
                httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
                httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP", (Object)scopeToTasksInBackgroundMap);
            }
        }
    }

    public static void removeAllTasksInBackground(HttpSession httpSession) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        HashMap scopeToTasksInBackgroundMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        if (scopeToTasksInBackgroundMap == null) {
            logger.debug("No tasks in background in session");
        } else {
            HashMap tasksInBackground = (HashMap)scopeToTasksInBackgroundMap.get(aslSession.getScope());
            if (tasksInBackground == null) {
                logger.debug("No tasks in background in session for scope: " + aslSession.getScope());
            } else {
                scopeToTasksInBackgroundMap.remove(aslSession.getScope());
                httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
                httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP", (Object)scopeToTasksInBackgroundMap);
            }
        }
    }

    public static void removeTaskInBackgroundOnTRId(HttpSession httpSession, TRId trId) throws TDGWTSessionExpiredException {
        ASLSession aslSession = SessionUtil.getAslSession(httpSession);
        ScopeProvider.instance.set(aslSession.getScope());
        if (trId == null) {
            logger.error("TRId is null");
            return;
        }
        if (trId.getId() == null || trId.getId().isEmpty()) {
            logger.error("TRId contains Id invalid: " + trId);
            return;
        }
        HashMap scopeToTasksInBackgroundMap = (HashMap)httpSession.getAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
        if (scopeToTasksInBackgroundMap == null) {
            logger.debug("No Background task in Session for TRId: " + trId);
        } else {
            HashMap tasksInBackground = (HashMap)scopeToTasksInBackgroundMap.get(aslSession.getScope());
            if (tasksInBackground == null) {
                logger.debug("No Background task for TRId: " + trId);
            } else {
                ArrayList<String> removableKeys = new ArrayList<String>();
                for (String key : tasksInBackground.keySet()) {
                    TaskWrapper taskWrapper = (TaskWrapper)tasksInBackground.get(key);
                    if (taskWrapper.getTrId() == null || taskWrapper.getTrId().getId() == null || taskWrapper.getTrId().getId().compareTo(trId.getId()) != 0) continue;
                    removableKeys.add(key);
                }
                for (String key : removableKeys) {
                    tasksInBackground.remove(key);
                }
                scopeToTasksInBackgroundMap.put(aslSession.getScope(), tasksInBackground);
                httpSession.removeAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP");
                httpSession.setAttribute("SCOPE_TO_OPERATIONS_TASKS_IN_BACKGROUND_MAP", (Object)scopeToTasksInBackgroundMap);
            }
        }
    }

    public static FileUploadMonitor getFileUploadMonitor(HttpSession httpSession) {
        FileUploadMonitor fileUploadMonitor = (FileUploadMonitor)httpSession.getAttribute("FILE_UPLOAD_MONITOR");
        if (fileUploadMonitor != null) {
            return fileUploadMonitor;
        }
        fileUploadMonitor = new FileUploadMonitor();
        httpSession.setAttribute("FILE_UPLOAD_MONITOR", (Object)fileUploadMonitor);
        return fileUploadMonitor;
    }

    public static void setFileUploadMonitor(HttpSession httpSession, FileUploadMonitor fileUploadMonitor) {
        FileUploadMonitor fum = (FileUploadMonitor)httpSession.getAttribute("FILE_UPLOAD_MONITOR");
        if (fum != null) {
            httpSession.removeAttribute("FILE_UPLOAD_MONITOR");
        }
        httpSession.setAttribute("FILE_UPLOAD_MONITOR", (Object)fileUploadMonitor);
    }

    public static SaveResourceSession getSaveResourceSession(HttpSession httpSession) {
        SaveResourceSession saveResourceSession = (SaveResourceSession)httpSession.getAttribute("RESOURCE_SAVE_SESSION");
        if (saveResourceSession != null) {
            return saveResourceSession;
        }
        saveResourceSession = new SaveResourceSession();
        httpSession.setAttribute("RESOURCE_SAVE_SESSION", (Object)saveResourceSession);
        return saveResourceSession;
    }

    public static void setSaveResourceSession(HttpSession httpSession, SaveResourceSession saveResourceSession) {
        SaveResourceSession srs = (SaveResourceSession)httpSession.getAttribute("RESOURCE_SAVE_SESSION");
        if (srs != null) {
            httpSession.removeAttribute("RESOURCE_SAVE_SESSION");
        }
        httpSession.setAttribute("RESOURCE_SAVE_SESSION", (Object)saveResourceSession);
    }
}

