/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnTypeCodeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4MergeColumn
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4MergeColumn.class);
    private TabularDataService service;
    private MergeColumnSession mergeColumnSession;

    public OpExecution4MergeColumn(TabularDataService service, MergeColumnSession mergeColumnSession) {
        this.service = service;
        this.mergeColumnSession = mergeColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        ArrayList<OperationExecution> invocations = new ArrayList<OperationExecution>();
        logger.debug(this.mergeColumnSession.toString());
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.AddColumn.toString(), this.service);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Expression expression = this.mergeColumnSession.getExpression();
        if (expression == null) {
            throw new TDGWTServiceException("No valid expression in splitColumnSession");
        }
        map.put("columnType", ColumnTypeCodeMap.getColumnType(this.mergeColumnSession.getMergeColumnType()));
        map.put("dataType", ColumnDataTypeMap.map(this.mergeColumnSession.getMergeColumnDataType()));
        map.put("label", new ImmutableLocalizedText(this.mergeColumnSession.getLabel()));
        map.put("value", expression);
        invocations.add(new OperationExecution(operationDefinition.getOperationId(), map));
        if (this.mergeColumnSession.isDeleteColumn()) {
            OperationDefinition operationDefinitionRemoveColumn = OperationDefinitionMap.map(OperationsId.RemoveColumn.toString(), this.service);
            HashMap mapRemoveColumn = new HashMap();
            invocations.add(new OperationExecution(this.mergeColumnSession.getColumnDataSource1().getColumnId(), operationDefinitionRemoveColumn.getOperationId(), mapRemoveColumn));
            invocations.add(new OperationExecution(this.mergeColumnSession.getColumnDataSource2().getColumnId(), operationDefinitionRemoveColumn.getOperationId(), mapRemoveColumn));
        }
        this.operationExecutionSpec.setOps(invocations);
    }
}

