/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.engine.StructureWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.StructureWriterFactory;
import org.sdmxsource.sdmx.api.manager.output.StructureWriterManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.format.StructureFormat;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class StructureWriterManagerImpl
implements StructureWriterManager,
ApplicationContextAware {
    private static Logger LOG = Logger.getLogger(StructureWriterManagerImpl.class);
    private ApplicationContext applicationContext;

    public void writeStructures(SdmxBeans beans, StructureFormat outputFormat, OutputStream out) {
        LOG.debug((Object)("Write Structures as " + outputFormat));
        this.getStructureWritingEngine(outputFormat, out).writeStructures(beans);
    }

    public void writeStructure(MaintainableBean bean, HeaderBean header, StructureFormat outputFormat, OutputStream out) {
        LOG.debug((Object)("Write Structure '" + bean + "' as " + outputFormat));
        this.getStructureWritingEngine(outputFormat, out).writeStructure(bean);
    }

    private StructureWriterEngine getStructureWritingEngine(StructureFormat outputFormat, OutputStream out) {
        for (StructureWriterFactory factory : this.applicationContext.getBeansOfType(StructureWriterFactory.class).values()) {
            StructureWriterEngine engine = factory.getStructureWriterEngine(outputFormat, out);
            if (engine == null) continue;
            return engine;
        }
        throw new SdmxNotImplementedException("Could not write structures out in format: " + outputFormat);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

