/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.registry.NotificationEvent;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.NotificationEventImpl;
import org.sdmxsource.sdmx.structureparser.manager.parsing.NotificationParsingManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.stereotype.Service;

@Service
public class NotificationParsingManagerImpl
implements NotificationParsingManager {
    private Logger log = Logger.getLogger(NotificationParsingManagerImpl.class);

    @Override
    public NotificationEvent createNotificationEvent(ReadableDataLocation dataLocation) {
        LoggingUtil.debug((Logger)this.log, (String)("Parse Structure request, for xml at location: " + dataLocation.toString()));
        InputStream stream = null;
        NotificationEventImpl notificationEvent = null;
        try {
            try {
                SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation);
                LoggingUtil.debug((Logger)this.log, (String)("Schema Version Determined to be : " + schemaVersion));
                XMLParser.validateXML((ReadableDataLocation)dataLocation, (SDMX_SCHEMA)schemaVersion, (ReadableDataLocation[])new ReadableDataLocation[0]);
                LoggingUtil.debug((Logger)this.log, (String)"XML VALID");
                stream = dataLocation.getInputStream();
                switch (schemaVersion) {
                    case VERSION_TWO: {
                        org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse((InputStream)stream);
                        if (rid.getRegistryInterface().getNotifyRegistryEvent() == null) {
                            throw new IllegalArgumentException("Can not parse message as NotifyRegistryEvent, as there are no NotifyRegistryEvent in message");
                        }
                        notificationEvent = new NotificationEventImpl(rid.getRegistryInterface().getNotifyRegistryEvent());
                        break;
                    }
                    case VERSION_TWO_POINT_ONE: {
                        RegistryInterfaceDocument rid21 = RegistryInterfaceDocument.Factory.parse((InputStream)stream);
                        if (rid21.getRegistryInterface().getNotifyRegistryEvent() == null) {
                            throw new IllegalArgumentException("Can not parse message as NotifyRegistryEvent, as there are no NotifyRegistryEvent in message");
                        }
                        notificationEvent = new NotificationEventImpl(rid21.getRegistryInterface().getNotifyRegistryEvent());
                        break;
                    }
                    default: {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Parse NotificationEvent at version: " + schemaVersion});
                    }
                }
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return notificationEvent;
    }
}

