/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.ExternalReferenceExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.MultipleArgumentsExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.UnaryExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.condtional.Case;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringByIndex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextReplaceMatchingRegex;
import org.gcube.data.analysis.tabulardata.expression.leaf.ColumnReferencePlaceholder;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;

public class PlaceholderReplacer {
    private Expression expression;
    private Map<String, List<PlaceholderContainer>> placeholderMap = new HashMap<String, List<PlaceholderContainer>>();

    public PlaceholderReplacer(Expression expr) throws MalformedExpressionException {
        this.expression = (Expression)expr.clone();
        this.expression.validate();
        this.scanForReferences(this.expression);
    }

    public boolean hasPlaceholder() {
        return !this.placeholderMap.isEmpty();
    }

    public Integer getCount() {
        return this.placeholderMap.size();
    }

    public PlaceholderReplacer replaceAll(ColumnReference ref) throws MalformedExpressionException {
        for (String id : this.placeholderMap.keySet()) {
            this.replaceById(ref, id);
        }
        return this;
    }

    public PlaceholderReplacer replaceById(ColumnReference ref, String placeholderId) throws MalformedExpressionException {
        if (this.placeholderMap.containsKey(placeholderId)) {
            for (PlaceholderContainer container : this.placeholderMap.get(placeholderId)) {
                container.setReference(ref);
            }
        }
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    private void scanForReferences(Expression toScan) {
        block25: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    if (toScan instanceof LeafExpression) break block25;
                                    if (!(toScan instanceof MultipleArgumentsExpression)) break block26;
                                    List<Expression> args = ((MultipleArgumentsExpression)toScan).getArguments();
                                    for (int i = 0; i < args.size(); ++i) {
                                        Expression expr = args.get(i);
                                        if (expr instanceof ColumnReferencePlaceholder) {
                                            this.putInMap((MultipleArgumentsExpression)toScan, (ColumnReferencePlaceholder)expr, i);
                                            continue;
                                        }
                                        this.scanForReferences(expr);
                                    }
                                    break block25;
                                }
                                if (!(toScan instanceof BinaryExpression)) break block27;
                                BinaryExpression binary = (BinaryExpression)toScan;
                                if (binary.getLeftArgument() instanceof ColumnReferencePlaceholder) {
                                    this.putInMap(binary, (ColumnReferencePlaceholder)binary.getLeftArgument(), 0);
                                } else {
                                    this.scanForReferences(binary.getLeftArgument());
                                }
                                if (binary.getRightArgument() instanceof ColumnReferencePlaceholder) {
                                    this.putInMap(binary, (ColumnReferencePlaceholder)binary.getRightArgument(), 1);
                                } else {
                                    this.scanForReferences(binary.getRightArgument());
                                }
                                break block25;
                            }
                            if (!(toScan instanceof UnaryExpression)) break block28;
                            Expression child = ((UnaryExpression)toScan).getArgument();
                            if (child instanceof ColumnReferencePlaceholder) {
                                this.putInMap((UnaryExpression)toScan, (ColumnReferencePlaceholder)child, 0);
                            } else {
                                this.scanForReferences(child);
                            }
                            break block25;
                        }
                        if (!(toScan instanceof ExternalReferenceExpression)) break block29;
                        ExternalReferenceExpression expr = (ExternalReferenceExpression)toScan;
                        if (expr.getSelectArgument() instanceof ColumnReferencePlaceholder) {
                            this.putInMap(expr, (ColumnReferencePlaceholder)expr.getSelectArgument(), 0);
                        } else {
                            this.scanForReferences(expr.getSelectArgument());
                        }
                        if (expr.getExternalCondition() instanceof ColumnReferencePlaceholder) {
                            this.putInMap(expr, (ColumnReferencePlaceholder)expr.getExternalCondition(), 1);
                        } else {
                            this.scanForReferences(expr.getExternalCondition());
                        }
                        break block25;
                    }
                    if (!(toScan instanceof TextReplaceMatchingRegex)) break block30;
                    TextReplaceMatchingRegex expr = (TextReplaceMatchingRegex)toScan;
                    if (expr.getToCheckText() instanceof ColumnReferencePlaceholder) {
                        this.putInMap(expr, (ColumnReferencePlaceholder)expr.getToCheckText(), 0);
                    } else {
                        this.scanForReferences(expr.getToCheckText());
                    }
                    break block25;
                }
                if (!(toScan instanceof SubstringByIndex)) break block31;
                SubstringByIndex expr = (SubstringByIndex)toScan;
                if (expr.getSourceString() instanceof ColumnReferencePlaceholder) {
                    this.putInMap(expr, (ColumnReferencePlaceholder)expr.getSourceString(), 0);
                } else {
                    this.scanForReferences(expr.getSourceString());
                }
                if (expr.getFromIndex() instanceof ColumnReferencePlaceholder) {
                    this.putInMap(expr, (ColumnReferencePlaceholder)expr.getFromIndex(), 1);
                } else {
                    this.scanForReferences(expr.getFromIndex());
                }
                if (expr.getToIndex() instanceof ColumnReferencePlaceholder) {
                    this.putInMap(expr, (ColumnReferencePlaceholder)expr.getToIndex(), 2);
                } else {
                    this.scanForReferences(expr.getToIndex());
                }
                break block25;
            }
            if (!(toScan instanceof Case)) break block25;
            Case expr = (Case)toScan;
            int index = 0;
            for (Case.WhenConstruct construct : ((Case)toScan).getWhenConstructs()) {
                if (construct.getWhen() instanceof ColumnReferencePlaceholder) {
                    this.putInMap(expr, (ColumnReferencePlaceholder)construct.getWhen(), index);
                } else {
                    this.scanForReferences(construct.getWhen());
                }
                if (construct.getThen() instanceof ColumnReferencePlaceholder) {
                    this.putInMap(expr, (ColumnReferencePlaceholder)construct.getThen(), index + 1);
                } else {
                    this.scanForReferences(construct.getThen());
                }
                ++index;
            }
        }
    }

    private void putInMap(CompositeExpression holder, ColumnReferencePlaceholder placeholder, int index) {
        if (!this.placeholderMap.containsKey(placeholder.getId())) {
            this.placeholderMap.put(placeholder.getId(), new ArrayList());
        }
        this.placeholderMap.get(placeholder.getId()).add(new PlaceholderContainer(index, holder));
    }

    private class PlaceholderContainer {
        private int index;
        private CompositeExpression expression;

        public PlaceholderContainer(int index, CompositeExpression expression) {
            this.index = index;
            this.expression = expression;
        }

        public void setReference(ColumnReference reference) {
            if (this.expression instanceof UnaryExpression) {
                ((UnaryExpression)this.expression).setArgument(reference);
            } else if (this.expression instanceof BinaryExpression) {
                BinaryExpression bin = (BinaryExpression)this.expression;
                if (this.index == 0) {
                    bin.setLeftArgument(reference);
                } else {
                    bin.setRightArgument(reference);
                }
            } else if (this.expression instanceof ExternalReferenceExpression) {
                ExternalReferenceExpression expr = (ExternalReferenceExpression)this.expression;
                if (this.index == 0) {
                    expr.setSelectArgument(reference);
                } else {
                    expr.setExternalCondition(reference);
                }
            } else if (this.expression instanceof MultipleArgumentsExpression) {
                MultipleArgumentsExpression multi = (MultipleArgumentsExpression)this.expression;
                multi.getArguments().set(this.index, reference);
            } else if (this.expression instanceof TextReplaceMatchingRegex) {
                TextReplaceMatchingRegex reg = (TextReplaceMatchingRegex)this.expression;
                reg.setToCheckText(reference);
            } else if (this.expression instanceof SubstringByIndex) {
                SubstringByIndex sub = (SubstringByIndex)this.expression;
                if (this.index == 0) {
                    sub.setSourceString(reference);
                } else if (this.index == 1) {
                    sub.setFromIndex(reference);
                } else {
                    sub.setToIndex(reference);
                }
            } else if (this.expression instanceof Case) {
                Case caseExp = (Case)this.expression;
                int ind = this.index / 2;
                int mod = this.index % 2;
                Case.WhenConstruct whenConstruct = caseExp.getWhenConstructs().get(ind);
                if (mod == 0) {
                    whenConstruct.setWhen(reference);
                } else {
                    whenConstruct.setThen(reference);
                }
            }
        }
    }
}

